/*
 * Decompiled with CFR 0.152.
 */
package dr.evomodel.alloppnet.operators;

import dr.evolution.util.Taxon;
import dr.evomodel.alloppnet.speciation.AlloppLeggedTree;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesBindings;
import dr.evomodel.alloppnet.speciation.AlloppSpeciesNetworkModel;
import dr.inference.operators.SimpleMCMCOperator;
import dr.math.MathUtils;
import java.util.ArrayList;

public class AlloppSequenceReassignment
extends SimpleMCMCOperator {
    private final AlloppSpeciesNetworkModel apspnet;
    private final AlloppSpeciesBindings apsp;

    public AlloppSequenceReassignment(AlloppSpeciesNetworkModel alloppSpeciesNetworkModel, AlloppSpeciesBindings alloppSpeciesBindings, double d) {
        this.apspnet = alloppSpeciesNetworkModel;
        this.apsp = alloppSpeciesBindings;
        this.setWeight(d);
    }

    public String getPerformanceSuggestion() {
        return "None";
    }

    @Override
    public String getOperatorName() {
        return "sequenceReassignment(" + this.apspnet.getId() + "," + this.apsp.getId() + ")";
    }

    @Override
    public double doOperation() {
        this.apspnet.beginNetworkEdit();
        if (MathUtils.nextInt(10) == 0) {
            int n = MathUtils.nextInt(this.apspnet.getNumberOfTetraTrees());
            AlloppLeggedTree alloppLeggedTree = this.apspnet.getTetraploidTree(n);
            ArrayList<Taxon> arrayList = alloppLeggedTree.getSpeciesTaxons();
            for (Taxon taxon : arrayList) {
                int n2 = this.apsp.apspeciesId2index(taxon.getId());
                this.apsp.flipAssignmentsForAllGenesOneSpecies(n2);
            }
            this.apspnet.flipLegsOfTetraTree(n);
        } else if (MathUtils.nextInt(2) == 0) {
            this.apsp.permuteOneSpeciesOneIndivForOneGene();
        } else {
            this.apsp.permuteSetOfIndivsForOneGene();
        }
        this.apspnet.endNetworkEdit();
        assert (this.apspnet.alloppspeciesnetworkOK());
        return 0.0;
    }
}

