/*
 * Decompiled with CFR 0.152.
 */
package eponine.model;

import eponine.model.BasisFunctionWithHistory;
import eponine.model.BundleConstraint;
import eponine.model.ConstraintBasisFunction;
import eponine.model.ModelTools;
import eponine.model.PositionedConstraint;
import eponine.model.WeightMatrixConstraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dp.SimpleWeightMatrix;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.FundamentalAtomicSymbol;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeVetoException;
import stats.glm.BasisFunction;
import stats.glm.BasisSource;
import stats.glm.SLMTrainingContext;

public class DropColumnBasisSource
extends FundamentalAtomicSymbol
implements BasisSource {
    private double nullModelWeighting = 3.0;
    private int sampleCounts = 71;
    private String name = "dropcol";

    public DropColumnBasisSource() {
        super("dropcol", ' ', Annotation.EMPTY_ANNOTATION);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public BasisFunction next(SLMTrainingContext sLMTrainingContext) {
        Object object;
        Object object2;
        List list = sLMTrainingContext.getBasisList();
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object2 = (BasisFunction)iterator.next();
            object = ModelTools.removeHistory((BasisFunction)object2);
            if (!(object instanceof ConstraintBasisFunction)) continue;
            PositionedConstraint positionedConstraint = (PositionedConstraint)((ConstraintBasisFunction)object).getConstraint();
            int n2 = 1;
            if (positionedConstraint.getConstraint() instanceof BundleConstraint) {
                n2 = ((BundleConstraint)positionedConstraint.getConstraint()).getConstraints().size();
            }
            hashMap.put(object2, new Integer(n2));
            n += n2;
        }
        try {
            n = (int)Math.ceil((double)n * Math.random());
            object2 = hashMap.entrySet().iterator();
            while (object2.hasNext()) {
                object = (Map.Entry)object2.next();
                int n3 = (Integer)object.getValue();
                if ((n -= n3) > 0) continue;
                BasisFunction basisFunction = (BasisFunction)object.getKey();
                PositionedConstraint positionedConstraint = (PositionedConstraint)ModelTools.getConstraint(basisFunction);
                if (n3 == 1) {
                    WeightMatrixConstraint weightMatrixConstraint = (WeightMatrixConstraint)positionedConstraint.getConstraint();
                    weightMatrixConstraint = this.sampleWeightMatrixConstraint(weightMatrixConstraint);
                    return new BasisFunctionWithHistory(new ConstraintBasisFunction(new PositionedConstraint(weightMatrixConstraint, positionedConstraint.getPosition(), positionedConstraint.getDistribution(), positionedConstraint.isMaximum())), Collections.singleton(basisFunction), this, sLMTrainingContext.getCurrentCycle());
                }
                ArrayList<PositionedConstraint> arrayList = new ArrayList<PositionedConstraint>(((BundleConstraint)positionedConstraint.getConstraint()).getConstraints());
                PositionedConstraint positionedConstraint2 = (PositionedConstraint)arrayList.get(-n);
                WeightMatrixConstraint weightMatrixConstraint = (WeightMatrixConstraint)positionedConstraint2.getConstraint();
                weightMatrixConstraint = this.sampleWeightMatrixConstraint(weightMatrixConstraint);
                arrayList.set(-n, new PositionedConstraint(weightMatrixConstraint, positionedConstraint2.getPosition(), positionedConstraint2.getDistribution(), positionedConstraint2.isMaximum()));
                return new BasisFunctionWithHistory(new ConstraintBasisFunction(new PositionedConstraint(new BundleConstraint(arrayList), positionedConstraint.getPosition(), positionedConstraint.getDistribution(), positionedConstraint.isMaximum())), Collections.singleton(basisFunction), this, sLMTrainingContext.getCurrentCycle());
            }
        }
        catch (BioException bioException) {
            return null;
        }
        System.out.println("totalProb exceeded");
        return null;
    }

    private WeightMatrixConstraint sampleWeightMatrixConstraint(WeightMatrixConstraint weightMatrixConstraint) throws BioException {
        WeightMatrix weightMatrix = weightMatrixConstraint.getWeightMatrix();
        SimpleWeightMatrix simpleWeightMatrix = null;
        WeightMatrixConstraint weightMatrixConstraint2 = null;
        if (weightMatrix.columns() > 2) {
            simpleWeightMatrix = new SimpleWeightMatrix(weightMatrix.getAlphabet(), weightMatrix.columns() - 1, ModelTools.DIST_FACTORY);
            int n = (int)Math.round(Math.random());
            int n2 = 0;
            while (n2 < simpleWeightMatrix.columns()) {
                Distribution distribution = weightMatrix.getColumn(n2 + n);
                Distribution distribution2 = simpleWeightMatrix.getColumn(n2);
                Iterator iterator = ((FiniteAlphabet)weightMatrix.getAlphabet()).iterator();
                while (iterator.hasNext()) {
                    Symbol symbol = (Symbol)iterator.next();
                    try {
                        distribution2.setWeight(symbol, distribution.getWeight(symbol));
                    }
                    catch (ChangeVetoException changeVetoException) {
                        throw new BioError(changeVetoException);
                    }
                }
                ++n2;
            }
        } else {
            throw new BioException("That WM is far too short!");
        }
        weightMatrixConstraint2 = new WeightMatrixConstraint(simpleWeightMatrix, weightMatrixConstraint.getReversibility());
        return weightMatrixConstraint2;
    }

    public boolean hasNext(SLMTrainingContext sLMTrainingContext) {
        return sLMTrainingContext.getCurrentCycle() > 0 && sLMTrainingContext.getBasisList().size() >= 3;
    }
}

