GENOME <- "bosTau4"
ORGANISM <- "Bos taurus"
ASSEMBLED_MOLECULES <- paste0("chr", c(1:29, "X", "M"))
CIRC_SEQS <- "chrM"

.order_seqlevels <- function(seqlevels)
{
    tmp <- IRanges::CharacterList(strsplit(seqlevels, ".", fixed=TRUE))
    npart <- lengths(tmp)
    stopifnot(all(npart %in% c(1L, 3L)))

    idx1 <- which(npart == 1L)
    stopifnot(length(idx1) == length(ASSEMBLED_MOLECULES))
    oo1 <- match(ASSEMBLED_MOLECULES, seqlevels[idx1])
    stopifnot(!anyNA(oo1))
    idx1 <- idx1[oo1]

    idx3 <- which(npart == 3L)
    m3 <- matrix(unlist(tmp[idx3]), ncol=3L, byrow=TRUE)
    stopifnot(all(m3[ , 1L] == "chrUn"))
    stopifnot(all(m3[ , 2L] == "004"))
    m33 <- as.integer(m3[ , 3L])
    stopifnot(!anyNA(m33))
    oo3 <- order(m33)
    idx3 <- idx3[oo3]

    c(idx1, idx3)
}

FETCH_ORDERED_CHROM_SIZES <-
    function(goldenPath.url=getOption("UCSC.goldenPath.url"))
{
    chrom_sizes <- GenomeInfoDb:::fetch_chrom_sizes_from_UCSC(GENOME,
                                              goldenPath.url=goldenPath.url)
    oo <- .order_seqlevels(chrom_sizes[ , "chrom"])
    S4Vectors:::extract_data_frame_rows(chrom_sizes, oo)
}

