/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.common;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.util.CastToJavaLongExactNode;
import com.oracle.graal.python.nodes.util.CastToJavaUnsignedLongNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.BufferFormat;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public abstract class BufferStorageNodes {

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={BufferFormat.class, PGuards.class})
    public static abstract class PackValueNode
    extends Node {
        public abstract void execute(VirtualFrame var1, Node var2, BufferFormat var3, Object var4, Object var5, int var6);

        @Specialization(guards={"format == UINT_8"})
        static void packUnsignedByteInt(Node inliningTarget, BufferFormat format, int value, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PRaiseNode raiseNode) {
            if (value < 0 || value > 255) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError);
            }
            bufferLib.writeByte(buffer, offset, (byte)value);
        }

        @Specialization(guards={"format == UINT_8"}, replaces={"packUnsignedByteInt"})
        static void packUnsignedByteGeneric(VirtualFrame frame, Node inliningTarget, BufferFormat format, Object object, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            int value = asSizeNode.executeExact((Frame)frame, inliningTarget, object);
            if (value < 0 || value > 255) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError);
            }
            bufferLib.writeByte(buffer, offset, (byte)value);
        }

        @Specialization(guards={"format == INT_8"}, replaces={"packUnsignedByteInt"})
        static void packSignedByteGeneric(VirtualFrame frame, Node inliningTarget, BufferFormat format, Object object, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            int value = asSizeNode.executeExact((Frame)frame, inliningTarget, object);
            if (value < -128 || value > 127) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError);
            }
            bufferLib.writeByte(buffer, offset, (byte)value);
        }

        @Specialization(guards={"format == INT_16"})
        static void packSignedShortGeneric(VirtualFrame frame, Node inliningTarget, BufferFormat format, Object object, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            int value = asSizeNode.executeExact((Frame)frame, inliningTarget, object);
            if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError);
            }
            bufferLib.writeShort(buffer, offset, (short)value);
        }

        @Specialization(guards={"format == UINT_16"})
        static void packUnsignedShortGeneric(VirtualFrame frame, Node inliningTarget, BufferFormat format, Object object, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode, @Cached.Shared @Cached PRaiseNode raiseNode) {
            int value = asSizeNode.executeExact((Frame)frame, inliningTarget, object);
            if (value < 0 || value > 65535) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError);
            }
            bufferLib.writeShort(buffer, offset, (short)value);
        }

        @Specialization(guards={"format == INT_32"})
        static void packSignedIntInt(BufferFormat format, int value, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            bufferLib.writeInt(buffer, offset, value);
        }

        @Specialization(guards={"format == INT_32"}, replaces={"packSignedIntInt"})
        static void packSignedIntGeneric(VirtualFrame frame, Node inliningTarget, BufferFormat format, Object object, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode) {
            int value = asSizeNode.executeExact((Frame)frame, inliningTarget, object);
            bufferLib.writeInt(buffer, offset, value);
        }

        @Specialization(guards={"format == UINT_32"}, replaces={"packSignedIntInt"})
        static void packUnsignedIntGeneric(VirtualFrame frame, Node inliningTarget, BufferFormat format, Object object, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PyNumberIndexNode indexNode, @Cached.Shared @Cached CastToJavaLongExactNode castToLong, @Cached.Shared @Cached PRaiseNode raiseNode) {
            long value = castToLong.execute(inliningTarget, indexNode.execute((Frame)frame, inliningTarget, object));
            if (value < 0L || value > 0xFFFFFFFFL) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError);
            }
            bufferLib.writeInt(buffer, offset, (int)value);
        }

        @Specialization(guards={"format == INT_64"})
        static void packSignedLong(VirtualFrame frame, Node inliningTarget, BufferFormat format, Object object, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PyNumberIndexNode indexNode, @Cached.Shared @Cached CastToJavaLongExactNode castToLong) {
            long value = castToLong.execute(inliningTarget, indexNode.execute((Frame)frame, inliningTarget, object));
            bufferLib.writeLong(buffer, offset, value);
        }

        @Specialization(guards={"format == UINT_64"})
        static void packUnsignedLong(VirtualFrame frame, Node inliningTarget, BufferFormat format, Object object, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached.Exclusive @Cached PyNumberIndexNode indexNode, @Cached CastToJavaUnsignedLongNode castToUnsignedLong) {
            long value = castToUnsignedLong.execute(inliningTarget, indexNode.execute((Frame)frame, inliningTarget, object));
            bufferLib.writeLong(buffer, offset, value);
        }

        @Specialization(guards={"format == HALF_FLOAT"})
        static void packFloat16(VirtualFrame frame, Node inliningTarget, BufferFormat format, Object object, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PyFloatAsDoubleNode asDoubleNode) {
            float value = (float)asDoubleNode.execute(frame, inliningTarget, object);
            bufferLib.writeFloat16(buffer, offset, value);
        }

        @Specialization(guards={"format == FLOAT"})
        static void packFloat(VirtualFrame frame, Node inliningTarget, BufferFormat format, Object object, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PyFloatAsDoubleNode asDoubleNode) {
            float value = (float)asDoubleNode.execute(frame, inliningTarget, object);
            bufferLib.writeFloat(buffer, offset, value);
        }

        @Specialization(guards={"format == DOUBLE"})
        static void packDouble(VirtualFrame frame, Node inliningTarget, BufferFormat format, Object object, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PyFloatAsDoubleNode asDoubleNode) {
            double value = asDoubleNode.execute(frame, inliningTarget, object);
            bufferLib.writeDouble(buffer, offset, value);
        }

        @Specialization(guards={"format == BOOLEAN"})
        static void packBoolean(VirtualFrame frame, BufferFormat format, Object object, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached PyObjectIsTrueNode isTrue) {
            byte value = isTrue.execute((Frame)frame, object) ? (byte)1 : 0;
            bufferLib.writeByte(buffer, offset, value);
        }

        @Specialization(guards={"format == CHAR"})
        static void packChar(Node inliningTarget, BufferFormat format, PBytes object, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached.Shared @Cached PRaiseNode raiseNode) {
            if (bufferLib.getBufferLength(object) != 1) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.OverflowError);
            }
            byte value = bufferLib.readByte(object, 0);
            bufferLib.writeByte(buffer, offset, value);
        }

        @Specialization(guards={"format == CHAR", "!isPBytes(object)"})
        static void packChar(Node inliningTarget, BufferFormat format, Object object, Object buffer, int offset) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.TypeError);
        }

        @Specialization(guards={"format == UNICODE"})
        static void packDouble(Node inliningTarget, BufferFormat format, Object object, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached StringNodes.CastToTruffleStringCheckedNode cast, @Cached(inline=false) TruffleString.CodePointLengthNode codePointLengthNode, @Cached(inline=false) TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached.Exclusive @Cached PRaiseNode raiseNode) {
            TruffleString str = cast.cast(inliningTarget, object, ErrorMessages.ARRAY_ITEM_MUST_BE_UNICODE, new Object[0]);
            if (codePointLengthNode.execute((AbstractTruffleString)str, PythonUtils.TS_ENCODING) != 1) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError);
            }
            int codePoint = codePointAtIndexNode.execute((AbstractTruffleString)str, 0, PythonUtils.TS_ENCODING);
            bufferLib.writeInt(buffer, offset, codePoint);
        }
    }

    @ImportStatic(value={BufferFormat.class})
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class UnpackValueNode
    extends Node {
        public abstract Object execute(Node var1, BufferFormat var2, Object var3, int var4);

        @Specialization(guards={"format == UINT_8"})
        static int unpackUnsignedByte(BufferFormat format, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            return bufferLib.readByte(buffer, offset) & 0xFF;
        }

        @Specialization(guards={"format == INT_8"})
        static int unpackSignedByte(BufferFormat format, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            return bufferLib.readByte(buffer, offset);
        }

        @Specialization(guards={"format == INT_16"})
        static int unpackSignedShort(BufferFormat format, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            return bufferLib.readShort(buffer, offset);
        }

        @Specialization(guards={"format == UINT_16"})
        static int unpackUnsignedShort(BufferFormat format, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            return bufferLib.readShort(buffer, offset) & 0xFFFF;
        }

        @Specialization(guards={"format == INT_32"})
        static int unpackSignedInt(BufferFormat format, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            return bufferLib.readInt(buffer, offset);
        }

        @Specialization(guards={"format == UINT_32"})
        static long unpackUnsignedInt(BufferFormat format, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            return (long)bufferLib.readInt(buffer, offset) & 0xFFFFFFFFL;
        }

        @Specialization(guards={"format == INT_64"})
        static long unpackSignedLong(BufferFormat format, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            return bufferLib.readLong(buffer, offset);
        }

        @Specialization(guards={"format == UINT_64"})
        static Object unpackUnsignedLong(Node inliningTarget, BufferFormat format, Object buffer, int offset, @Bind PythonLanguage language, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached InlinedConditionProfile needsPIntProfile) {
            long signedLong = bufferLib.readLong(buffer, offset);
            if (needsPIntProfile.profile(inliningTarget, signedLong < 0L)) {
                return PFactory.createInt(language, PInt.longToUnsignedBigInteger(signedLong));
            }
            return signedLong;
        }

        @Specialization(guards={"format == HALF_FLOAT"})
        static double unpackFloat16(BufferFormat format, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            return bufferLib.readFloat16(buffer, offset);
        }

        @Specialization(guards={"format == FLOAT"})
        static double unpackFloat(BufferFormat format, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            return bufferLib.readFloat(buffer, offset);
        }

        @Specialization(guards={"format == DOUBLE"})
        static double unpackDouble(BufferFormat format, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            return bufferLib.readDouble(buffer, offset);
        }

        @Specialization(guards={"format == BOOLEAN"})
        static boolean unpackBoolean(BufferFormat format, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            return bufferLib.readByte(buffer, offset) != 0;
        }

        @Specialization(guards={"format == CHAR"})
        static PBytes unpackChar(BufferFormat format, Object buffer, int offset, @Bind PythonLanguage language, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            return PFactory.createBytes(language, new byte[]{bufferLib.readByte(buffer, offset)});
        }

        @Specialization(guards={"format == UNICODE"})
        static TruffleString unpackUnicode(Node inliningTarget, BufferFormat format, Object buffer, int offset, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached PRaiseNode raiseNode, @Cached(inline=false) TruffleString.FromCodePointNode fromCodePointNode) {
            int codePoint = bufferLib.readInt(buffer, offset);
            if (!Character.isValidCodePoint(codePoint)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.UNMAPPABLE_CHARACTER);
            }
            return fromCodePointNode.execute(codePoint, PythonUtils.TS_ENCODING, true);
        }
    }
}

