/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.commandline.command;

import java.nio.file.Path;
import java.util.Map;
import picocli.CommandLine;
import schemacrawler.tools.commandline.state.BaseStateHolder;
import schemacrawler.tools.commandline.state.ShellState;
import schemacrawler.tools.commandline.utility.CommandLineConfigUtility;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.IOUtility;

@CommandLine.Command(name="config-file", header={"** Load SchemaCrawler configuration from the classpath and file"}, description={"", "For more information, see https://www.schemacrawler.com/config.html", ""}, headerHeading="", synopsisHeading="Shell Command:%n", customSynopsis={"config-file"}, optionListHeading="Options:%n")
public class ConfigFileCommand
extends BaseStateHolder
implements Runnable {
    @CommandLine.Option(names={"-g", "--config-file"}, description={"Read SchemaCrawler configuration properties from <configfile>%n<configfile> is the full path to the configuration file%nOptional"})
    private Path configfile;

    public ConfigFileCommand(ShellState state) {
        super(state);
    }

    @Override
    public void run() {
        if (IOUtility.isFileReadable((Path)this.configfile)) {
            System.setProperty("config.file", this.configfile.toString());
        }
        Map<String, Object> appConfig = CommandLineConfigUtility.loadConfig();
        this.state.setBaseConfig(new Config(appConfig));
    }
}

