/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.linter;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import schemacrawler.schema.Table;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.QueryUtility;
import schemacrawler.schemacrawler.exceptions.DatabaseAccessException;
import schemacrawler.tools.lint.BaseLinter;
import schemacrawler.tools.lint.LintCollector;
import schemacrawler.tools.options.Config;
import us.fatehi.utility.Utility;
import us.fatehi.utility.property.PropertyName;

class LinterCatalogSql
extends BaseLinter {
    private String message;
    private String sql;

    LinterCatalogSql(PropertyName propertyName, LintCollector lintCollector) {
        super(propertyName, lintCollector);
    }

    @Override
    public String getSummary() {
        if (Utility.isBlank((CharSequence)this.message)) {
            return "SQL statement based catalog linter";
        }
        return this.message;
    }

    public boolean usesConnection() {
        return true;
    }

    @Override
    protected void configure(Config config) {
        Objects.requireNonNull(config, "No configuration provided");
        this.message = config.getStringValue("message", "");
        Utility.requireNotBlank((String)this.message, (String)"No message provided");
        this.sql = config.getStringValue("sql", "");
        Utility.requireNotBlank((String)this.sql, (String)"No SQL provided");
    }

    @Override
    protected void lint(Table table, Connection connection) {
    }

    @Override
    protected void start(Connection connection) {
        super.start(connection);
        if (Utility.isBlank((CharSequence)this.sql)) {
            return;
        }
        Objects.requireNonNull(connection, "No connection provided");
        try {
            Query query = new Query(this.message, this.sql);
            Object queryResult = QueryUtility.executeForScalar((Query)query, (Connection)connection);
            if (queryResult != null) {
                this.addCatalogLint(this.getSummary() + " " + String.valueOf(queryResult), true);
            }
        }
        catch (SQLException e) {
            throw new DatabaseAccessException("Could not execute SQL for catalog lints%n%s".formatted(this.sql), e);
        }
    }
}

