/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ItertoolsModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.ItertoolsModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.PTee;
import com.oracle.graal.python.builtins.objects.itertools.TeeBuiltins;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(defineModule="itertools")
public final class ItertoolsModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ItertoolsModuleBuiltinsFactory.getFactories();
    }

    @CompilerDirectives.TruffleBoundary
    public static void warnPickleDeprecated() {
        WarningsModuleBuiltins.WarnNode.getUncached().warnEx(null, (Object)PythonBuiltinClassType.DeprecationWarning, ErrorMessages.PICKLE_ITERTOOLS_IN_PYTHON_3_14, 1);
    }

    @Builtin(name="tee", minNumOfPositionalArgs=1, parameterNames={"iterable", "n"})
    @ArgumentClinic(name="n", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="2")
    @GenerateNodeFactory
    public static abstract class TeeNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ItertoolsModuleBuiltinsClinicProviders.TeeNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"n < 0"})
        static Object negativeN(Object iterable, int n, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.ValueError, ErrorMessages.S_MUST_BE_S, "n", ">=0");
        }

        @Specialization(guards={"n == 0"})
        static Object zeroN(Object iterable, int n, @Bind PythonLanguage language) {
            return PFactory.createTuple(language, PythonUtils.EMPTY_OBJECT_ARRAY);
        }

        @Specialization(guards={"n > 0"})
        static Object tee(VirtualFrame frame, Object iterable, int n, @Bind Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached InlinedConditionProfile isTeeInstanceProfile, @Bind PythonLanguage language) {
            Object it = getIter.execute((Frame)frame, inliningTarget, iterable);
            Object[] tupleObjs = new Object[n];
            PTee to = TeeBuiltins.NewNode.teeFromIterable(frame, null, it, inliningTarget, getIter, isTeeInstanceProfile, language);
            tupleObjs[0] = to;
            for (int i = 1; i < n; ++i) {
                tupleObjs[i] = TeeBuiltins.CopyNode.copy(to, language);
            }
            return PFactory.createTuple(language, tupleObjs);
        }
    }
}

