/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.internal.json4j;

import com.ibm.db2.cmx.internal.json4j.JSONObject;
import com.ibm.db2.cmx.internal.json4j.Parser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;

public class OrderedJSONObject
extends JSONObject {
    private static final long serialVersionUID = -3269263069889337299L;
    private ArrayList order = new ArrayList();

    public static JSONObject parse(Reader reader) throws IOException {
        reader = new BufferedReader(reader);
        return new Parser(reader).parse(true);
    }

    public static JSONObject parse(String string) throws IOException {
        StringReader stringReader = new StringReader(string);
        return OrderedJSONObject.parse(stringReader);
    }

    public static JSONObject parse(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        }
        catch (Exception exception) {
            inputStreamReader = new InputStreamReader(inputStream);
        }
        return OrderedJSONObject.parse(inputStreamReader);
    }

    @Override
    public Object put(Object object, Object object2) {
        if (null == object) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (!(object instanceof String)) {
            throw new IllegalArgumentException("key must be a String");
        }
        if (!OrderedJSONObject.isValidObject(object2)) {
            if (object2 != null) {
                throw new IllegalArgumentException("Invalid type of value.  Type: [" + object2.getClass().getName() + "] with value: [" + object2.toString() + "]");
            }
            throw new IllegalArgumentException("Invalid type of value.");
        }
        if (!this.containsKey(object)) {
            this.order.add(object);
        }
        return super.put(object, object2);
    }

    @Override
    public Object remove(Object object) {
        Object var2_2 = null;
        if (null == object) {
            throw new IllegalArgumentException("key must not be null");
        }
        if (this.containsKey(object)) {
            var2_2 = super.remove(object);
            for (int i10 = 0; i10 < this.order.size(); ++i10) {
                Object e10 = this.order.get(i10);
                if (!e10.equals(object)) continue;
                this.order.remove(i10);
                break;
            }
        }
        return var2_2;
    }

    @Override
    public void clear() {
        super.clear();
        this.order.clear();
    }

    @Override
    public Object clone() {
        OrderedJSONObject orderedJSONObject = (OrderedJSONObject)super.clone();
        Iterator iterator = orderedJSONObject.getOrder();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
            orderedJSONObject.order = arrayList;
        }
        return orderedJSONObject;
    }

    public Iterator getOrder() {
        return this.order.iterator();
    }
}

