/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.codec;

import java.io.IOException;
import java.util.Objects;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.BytesRef;
import org.opensearch.neuralsearch.sparse.cache.CacheKey;
import org.opensearch.neuralsearch.sparse.cache.CacheableSparseVectorWriter;
import org.opensearch.neuralsearch.sparse.cache.ForwardIndexCache;
import org.opensearch.neuralsearch.sparse.codec.MergeHelper;
import org.opensearch.neuralsearch.sparse.codec.SparseBinaryDocValues;
import org.opensearch.neuralsearch.sparse.codec.SparseDocValuesReader;
import org.opensearch.neuralsearch.sparse.common.MergeStateFacade;
import org.opensearch.neuralsearch.sparse.common.PredicateUtils;
import org.opensearch.neuralsearch.sparse.data.SparseVector;
import org.opensearch.neuralsearch.sparse.mapper.SparseVectorField;
import org.opensearch.neuralsearch.sparse.quantization.ByteQuantizationUtil;
import org.opensearch.neuralsearch.sparse.quantization.ByteQuantizer;

public class SparseDocValuesConsumer
extends DocValuesConsumer {
    @Generated
    private static final Logger log = LogManager.getLogger(SparseDocValuesConsumer.class);
    private final DocValuesConsumer delegate;
    private final SegmentWriteState state;
    private final MergeHelper mergeHelper;

    public SparseDocValuesConsumer(@NonNull SegmentWriteState state, @NonNull DocValuesConsumer delegate, @NonNull MergeHelper mergeHelper) {
        Objects.requireNonNull(state, "state is marked non-null but is null");
        Objects.requireNonNull(delegate, "delegate is marked non-null but is null");
        Objects.requireNonNull(mergeHelper, "mergeHelper is marked non-null but is null");
        this.delegate = delegate;
        this.state = state;
        this.mergeHelper = mergeHelper;
    }

    public void addNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegate.addNumericField(field, valuesProducer);
    }

    public void addBinaryField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegate.addBinaryField(field, valuesProducer);
        if (!SparseVectorField.isSparseField(field)) {
            return;
        }
        this.addSparseVectorBinary(field, valuesProducer, false);
    }

    private void addSparseVectorBinary(FieldInfo field, DocValuesProducer valuesProducer, boolean isMerge) throws IOException {
        if (!PredicateUtils.shouldRunSeisPredicate.test(this.state.segmentInfo, field)) {
            return;
        }
        BinaryDocValues binaryDocValues = valuesProducer.getBinary(field);
        CacheKey key = new CacheKey(this.state.segmentInfo, field);
        int docCount = this.state.segmentInfo.maxDoc();
        CacheableSparseVectorWriter writer = ForwardIndexCache.getInstance().getOrCreate(key, docCount).getWriter();
        int docId = binaryDocValues.nextDoc();
        while (docId != Integer.MAX_VALUE) {
            SparseBinaryDocValues sparseBinaryDocValues;
            SparseVector vector;
            boolean written = false;
            if (isMerge && (vector = (sparseBinaryDocValues = (SparseBinaryDocValues)binaryDocValues).cachedSparseVector()) != null) {
                writer.insert(docId, vector);
                written = true;
            }
            if (!written) {
                BytesRef bytesRef = binaryDocValues.binaryValue();
                ByteQuantizer byteQuantizer = ByteQuantizationUtil.getByteQuantizerIngest(field);
                writer.insert(docId, new SparseVector(bytesRef, byteQuantizer));
            }
            docId = binaryDocValues.nextDoc();
        }
        if (isMerge && valuesProducer instanceof SparseDocValuesReader) {
            SparseDocValuesReader reader = (SparseDocValuesReader)valuesProducer;
            this.mergeHelper.clearCacheData(reader.getMergeStateFacade(), field, ForwardIndexCache.getInstance()::onIndexRemoval);
        }
    }

    public void addSortedField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegate.addSortedField(field, valuesProducer);
    }

    public void addSortedNumericField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegate.addSortedNumericField(field, valuesProducer);
    }

    public void addSortedSetField(FieldInfo field, DocValuesProducer valuesProducer) throws IOException {
        this.delegate.addSortedSetField(field, valuesProducer);
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public void merge(MergeState mergeState) throws IOException {
        this.delegate.merge(mergeState);
        try {
            assert (mergeState != null);
            MergeStateFacade mergeStateFacade = this.mergeHelper.convertToMergeStateFacade(mergeState);
            FieldInfos mergeFieldInfos = mergeStateFacade.getMergeFieldInfos();
            if (mergeFieldInfos == null) {
                return;
            }
            for (FieldInfo fieldInfo : mergeFieldInfos) {
                DocValuesType type = fieldInfo.getDocValuesType();
                if (type != DocValuesType.BINARY || !SparseVectorField.isSparseField(fieldInfo)) continue;
                this.addSparseVectorBinary(fieldInfo, (DocValuesProducer)this.mergeHelper.newSparseDocValuesReader(mergeStateFacade), true);
            }
        }
        catch (Exception e) {
            log.error("Merge sparse doc values error", (Throwable)e);
        }
    }
}

