/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.http.HttpClientConnectionManager;
import software.amazon.awssdk.http.HttpExecuteRequest;
import software.amazon.awssdk.metrics.MetricCollector;

@SdkInternalApi
public final class CrtRequestContext {
    private final HttpExecuteRequest request;
    private final long readBufferSize;
    private final HttpClientConnectionManager crtConnPool;
    private final MetricCollector metricCollector;

    private CrtRequestContext(Builder builder) {
        this.request = builder.request;
        this.readBufferSize = builder.readBufferSize;
        this.crtConnPool = builder.crtConnPool;
        this.metricCollector = this.request.metricCollector().orElse(null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public HttpExecuteRequest sdkRequest() {
        return this.request;
    }

    public long readBufferSize() {
        return this.readBufferSize;
    }

    public HttpClientConnectionManager crtConnPool() {
        return this.crtConnPool;
    }

    public MetricCollector metricCollector() {
        return this.metricCollector;
    }

    public static final class Builder {
        private HttpExecuteRequest request;
        private long readBufferSize;
        private HttpClientConnectionManager crtConnPool;

        private Builder() {
        }

        public Builder request(HttpExecuteRequest request) {
            this.request = request;
            return this;
        }

        public Builder readBufferSize(long readBufferSize) {
            this.readBufferSize = readBufferSize;
            return this;
        }

        public Builder crtConnPool(HttpClientConnectionManager crtConnPool) {
            this.crtConnPool = crtConnPool;
            return this;
        }

        public CrtRequestContext build() {
            return new CrtRequestContext(this);
        }
    }
}

