/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sns.message;

import com.amazonaws.services.sns.message.SnsMessage;
import com.amazonaws.services.sns.message.SnsNotification;
import com.amazonaws.services.sns.message.SnsSubscriptionConfirmation;
import com.amazonaws.services.sns.message.SnsUnknownMessage;
import com.amazonaws.services.sns.message.SnsUnsubscribeConfirmation;
import com.amazonaws.util.DateUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.Date;
import org.apache.http.client.HttpClient;

final class SnsMessageUnmarshaller {
    private static final String TYPE = "Type";
    private static final String MESSAGE_ID = "MessageId";
    private static final String TOPIC_ARN = "TopicArn";
    private static final String SUBJECT = "Subject";
    private static final String MESSAGE = "Message";
    private static final String TIMESTAMP = "Timestamp";
    private static final String SUBSCRIBE_URL = "SubscribeURL";
    private static final String UNSUBSCRIBE_URL = "UnsubscribeURL";
    private static final String TOKEN = "Token";
    private static final String TYPE_NOTIFICATION = "Notification";
    private static final String TYPE_SUBSCRIPTION_CONFIRMATION = "SubscriptionConfirmation";
    private static final String TYPE_UNSUBSCRIBE_CONFIRMATION = "UnsubscribeConfirmation";
    private final HttpClient client;

    SnsMessageUnmarshaller(HttpClient client) {
        this.client = client;
    }

    public SnsMessage unmarshall(JsonNode rawMessage) {
        SnsJsonNode message = new SnsJsonNode(rawMessage);
        return this.unmarshallBase(this.createSubMessage(message), message).build();
    }

    private SnsMessage.Builder<? extends SnsMessage.Builder> createSubMessage(SnsJsonNode message) {
        String type = message.getString(TYPE);
        if (TYPE_NOTIFICATION.equals(type)) {
            return this.unmarshallNotification(message);
        }
        if (TYPE_SUBSCRIPTION_CONFIRMATION.equals(type)) {
            return this.unmarshallSubscriptionConfirmation(message);
        }
        if (TYPE_UNSUBSCRIBE_CONFIRMATION.equals(type)) {
            return this.unmarshallUnsubscribeConfirmation(message);
        }
        return SnsUnknownMessage.builder();
    }

    private SnsMessage.Builder<? extends SnsMessage.Builder> unmarshallUnsubscribeConfirmation(SnsJsonNode message) {
        return SnsUnsubscribeConfirmation.builder(this.client).withMessage(message.getString(MESSAGE)).withSubscribeUrl(message.getString(SUBSCRIBE_URL)).withToken(message.getString(TOKEN));
    }

    private SnsMessage.Builder<? extends SnsMessage.Builder> unmarshallSubscriptionConfirmation(SnsJsonNode message) {
        return SnsSubscriptionConfirmation.builder(this.client).withSubscribeUrl(message.getString(SUBSCRIBE_URL)).withToken(message.getString(TOKEN)).withMessage(message.getString(MESSAGE));
    }

    private SnsMessage.Builder<? extends SnsMessage.Builder> unmarshallNotification(SnsJsonNode message) {
        return SnsNotification.builder(this.client).withMessage(message.getString(MESSAGE)).withSubject(message.getString(SUBJECT)).withUnsubscribeUrl(message.getString(UNSUBSCRIBE_URL));
    }

    public SnsMessage.Builder<?> unmarshallBase(SnsMessage.Builder<?> builder, SnsJsonNode message) {
        return ((SnsMessage.Builder)((SnsMessage.Builder)builder.withMessageId(message.getString(MESSAGE_ID))).withTopicArn(message.getString(TOPIC_ARN))).withTimestamp(message.getIso8601Date(TIMESTAMP));
    }

    private static final class SnsJsonNode {
        private final JsonNode source;

        private SnsJsonNode(JsonNode source) {
            this.source = source;
        }

        private Date getIso8601Date(String fieldName) {
            String dateString = this.getString(fieldName);
            return dateString != null ? DateUtils.parseISO8601Date((String)dateString) : null;
        }

        private String getString(String fieldName) {
            return this.source.has(fieldName) ? this.source.get(fieldName).asText() : null;
        }
    }
}

