/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.core.pipeline.jersey;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;

public class ClientConfigSettings {
    private static final int DEFAULT_TIMEOUT_MS = 90000;
    private final Integer connectTimeout;
    private final Integer readTimeout;
    private final boolean shouldLog;

    public ClientConfigSettings() {
        this.connectTimeout = Integer.valueOf(null);
        this.readTimeout = Integer.valueOf(null);
        this.shouldLog = false;
    }

    public ClientConfigSettings(Object connectTimeout, Object readTimeout, boolean shouldLog) {
        this.connectTimeout = this.getTimeout(connectTimeout);
        this.readTimeout = this.getTimeout(readTimeout);
        this.shouldLog = shouldLog;
    }

    public void applyConfig(ClientConfig clientConfig) {
        clientConfig.getProperties().put("com.sun.jersey.client.property.connectTimeout", this.connectTimeout);
        clientConfig.getProperties().put("com.sun.jersey.client.property.readTimeout", this.readTimeout);
    }

    public void applyConfig(Client client) {
        if (this.shouldLog) {
            client.addFilter((ClientFilter)new LoggingFilter());
        }
    }

    private Integer getTimeout(Object timeoutValue) {
        if (timeoutValue == null) {
            return new Integer(90000);
        }
        if (timeoutValue instanceof Integer) {
            return (Integer)timeoutValue;
        }
        if (timeoutValue instanceof String) {
            return Integer.valueOf((String)timeoutValue);
        }
        throw new IllegalArgumentException("timeoutValue");
    }
}

