/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.statistics;

import com.amazon.randomcutforest.CommonUtils;

public class Deviation {
    protected double discount;
    protected double weight = 0.0;
    protected double sumSquared = 0.0;
    protected double sum = 0.0;
    protected int count = 0;

    public Deviation() {
        this.discount = 0.0;
    }

    public Deviation(double discount) {
        CommonUtils.checkArgument(0.0 <= discount && discount < 1.0, "incorrect discount parameter");
        this.discount = discount;
    }

    public Deviation(double discount, double weight, double sumSquared, double sum, int count) {
        this.discount = discount;
        this.weight = weight;
        this.sumSquared = sumSquared;
        this.sum = sum;
        this.count = count;
    }

    public Deviation copy() {
        return new Deviation(this.discount, this.weight, this.sumSquared, this.sum, this.count);
    }

    public double getMean() {
        return this.weight <= 0.0 ? 0.0 : this.sum / this.weight;
    }

    public void update(double score) {
        double factor = 1.0 - this.discount;
        this.sum = this.sum * factor + score;
        this.sumSquared = this.sumSquared * factor + score * score;
        this.weight = this.weight * factor + 1.0;
        ++this.count;
    }

    public double getDeviation() {
        if (this.weight <= 0.0) {
            return 0.0;
        }
        double temp = this.sum / this.weight;
        double answer = this.sumSquared / this.weight - temp * temp;
        return answer > 0.0 ? Math.sqrt(answer) : 0.0;
    }

    public boolean isEmpty() {
        return this.weight == 0.0;
    }

    public double getDiscount() {
        return this.discount;
    }

    public void setDiscount(double discount) {
        CommonUtils.checkArgument(discount >= 0.0, "cannot be negative");
        CommonUtils.checkArgument(discount < 1.0, "can be at most 1");
        this.discount = discount;
    }

    public double getSum() {
        return this.sum;
    }

    public double getSumSquared() {
        return this.sumSquared;
    }

    public double getWeight() {
        return this.weight;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void reset() {
        this.weight = 0.0;
        this.sum = 0.0;
        this.count = 0;
        this.sumSquared = 0.0;
    }
}

