/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.compositeindex.datacube.startree.aggregators;

import org.opensearch.index.compositeindex.datacube.startree.aggregators.ValueAggregator;
import org.opensearch.index.compositeindex.datacube.startree.utils.CompensatedSumType;
import org.opensearch.index.mapper.FieldValueConverter;
import org.opensearch.index.mapper.NumberFieldMapper;
import org.opensearch.search.aggregations.metrics.CompensatedSum;

class SumValueAggregator
implements ValueAggregator<CompensatedSum> {
    private final FieldValueConverter fieldValueConverter;
    private final CompensatedSumType compensatedSumConverter;
    private static final FieldValueConverter VALUE_AGGREGATOR_TYPE = NumberFieldMapper.NumberType.DOUBLE;

    public SumValueAggregator(FieldValueConverter fieldValueConverter) {
        this.fieldValueConverter = fieldValueConverter;
        this.compensatedSumConverter = new CompensatedSumType();
    }

    @Override
    public FieldValueConverter getAggregatedValueType() {
        return this.compensatedSumConverter;
    }

    @Override
    public CompensatedSum getInitialAggregatedValueForSegmentDocValue(Long segmentDocValue) {
        CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        if (segmentDocValue != null) {
            kahanSummation.reset(this.fieldValueConverter.toDoubleValue(segmentDocValue), 0.0);
        } else {
            kahanSummation.reset(this.getIdentityMetricDoubleValue(), 0.0);
        }
        return kahanSummation;
    }

    @Override
    public CompensatedSum mergeAggregatedValueAndSegmentValue(CompensatedSum value, Long segmentDocValue) {
        CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        if (value != null) {
            kahanSummation.reset(value.value(), value.delta());
        }
        if (segmentDocValue != null) {
            kahanSummation.add(this.fieldValueConverter.toDoubleValue(segmentDocValue));
        } else {
            kahanSummation.add(this.getIdentityMetricDoubleValue());
        }
        return kahanSummation;
    }

    @Override
    public CompensatedSum mergeAggregatedValues(CompensatedSum value, CompensatedSum aggregatedValue) {
        CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        if (aggregatedValue != null) {
            kahanSummation.reset(aggregatedValue.value(), aggregatedValue.delta());
        }
        if (value != null) {
            kahanSummation.add(value.value(), value.delta());
        } else {
            kahanSummation.add(this.getIdentityMetricDoubleValue());
        }
        return kahanSummation;
    }

    @Override
    public CompensatedSum getInitialAggregatedValue(CompensatedSum value) {
        CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        if (value == null) {
            kahanSummation.reset(this.getIdentityMetricDoubleValue(), 0.0);
        } else {
            kahanSummation.reset(value.value(), value.delta());
        }
        return kahanSummation;
    }

    @Override
    public CompensatedSum toAggregatedValueType(Long value) {
        CompensatedSum kahanSummation = new CompensatedSum(0.0, 0.0);
        try {
            if (value == null) {
                kahanSummation.reset(this.getIdentityMetricDoubleValue(), 0.0);
                return kahanSummation;
            }
            kahanSummation.reset(VALUE_AGGREGATOR_TYPE.toDoubleValue(value), 0.0);
            return kahanSummation;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot convert " + value + " to sortable aggregation type", e);
        }
    }

    private double getIdentityMetricDoubleValue() {
        return 0.0;
    }

    @Override
    public CompensatedSum getIdentityMetricValue() {
        return new CompensatedSum(0.0, 0.0);
    }
}

