// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at https://mozilla.org/MPL/2.0/.

//! This file contains the Generated Glean Metrics API
//!
//! The contents of this module are generated by
//! `toolkit/components/glean/build_scripts/glean_parser_ext/run_glean_parser.py`, from
//! metrics files identified in 'toolkit/components/glean/metrics_index.py`.

include!(mozbuild::objdir_path!(
    "toolkit/components/glean/api/src/metrics.rs"
));

use crate::private::{EventMetric, ExtraKeys};

#[cfg(feature = "with_gecko")]
extern "C" {
    fn fog_malloc_size_of(ptr: *const ::xpcom::reexports::libc::c_void) -> usize;
}

#[cfg(feature = "with_gecko")]
thread_local! {
    static METRIC_MEMORY_USAGE: std::cell::RefCell<usize> = std::cell::RefCell::new(0);
    static METRIC_MEM_OPS: std::cell::RefCell<::malloc_size_of::MallocSizeOfOps> = std::cell::RefCell::new(::malloc_size_of::MallocSizeOfOps::new(fog_malloc_size_of, None));
}

#[cfg(feature = "with_gecko")]
pub(crate) fn count_memory_usage(size: usize) {
    METRIC_MEMORY_USAGE.with_borrow_mut(|usg| *usg += size);
}

#[cfg(feature = "with_gecko")]
pub(crate) fn metric_memory_usage() -> usize {
    METRIC_MEMORY_USAGE.with(|c| *c.borrow())
}

/// Helper to get the number of allowed extra keys for a given event metric.
fn extra_keys_len<K: ExtraKeys>(_event: &EventMetric<K>) -> usize {
    K::ALLOWED_KEYS.len()
}
