struct cs_clip_rectangle_common {
struct Samplers {
 sampler2D_impl sGpuCache_impl;
 int sGpuCache_slot;
 sampler2D_impl sRenderTasks_impl;
 int sRenderTasks_slot;
 sampler2D_impl sTransformPalette_impl;
 int sTransformPalette_slot;
 bool set_slot(int index, int value) {
  switch (index) {
  case 2:
   sGpuCache_slot = value;
   return true;
  case 1:
   sRenderTasks_slot = value;
   return true;
  case 3:
   sTransformPalette_slot = value;
   return true;
  }
  return false;
 }
} samplers;
struct AttribLocations {
 int aPosition = NULL_ATTRIB;
 int aClipDeviceArea = NULL_ATTRIB;
 int aClipOrigins = NULL_ATTRIB;
 int aDevicePixelScale = NULL_ATTRIB;
 int aTransformIds = NULL_ATTRIB;
 int aClipLocalPos = NULL_ATTRIB;
 int aClipLocalRect = NULL_ATTRIB;
 int aClipMode = NULL_ATTRIB;
 int aClipRect_TL = NULL_ATTRIB;
 int aClipRadii_TL = NULL_ATTRIB;
 int aClipRect_TR = NULL_ATTRIB;
 int aClipRadii_TR = NULL_ATTRIB;
 int aClipRect_BL = NULL_ATTRIB;
 int aClipRadii_BL = NULL_ATTRIB;
 int aClipRect_BR = NULL_ATTRIB;
 int aClipRadii_BR = NULL_ATTRIB;
 void bind_loc(const char* name, int index) {
  if (strcmp("aPosition", name) == 0) { aPosition = index; return; }
  if (strcmp("aClipDeviceArea", name) == 0) { aClipDeviceArea = index; return; }
  if (strcmp("aClipOrigins", name) == 0) { aClipOrigins = index; return; }
  if (strcmp("aDevicePixelScale", name) == 0) { aDevicePixelScale = index; return; }
  if (strcmp("aTransformIds", name) == 0) { aTransformIds = index; return; }
  if (strcmp("aClipLocalPos", name) == 0) { aClipLocalPos = index; return; }
  if (strcmp("aClipLocalRect", name) == 0) { aClipLocalRect = index; return; }
  if (strcmp("aClipMode", name) == 0) { aClipMode = index; return; }
  if (strcmp("aClipRect_TL", name) == 0) { aClipRect_TL = index; return; }
  if (strcmp("aClipRadii_TL", name) == 0) { aClipRadii_TL = index; return; }
  if (strcmp("aClipRect_TR", name) == 0) { aClipRect_TR = index; return; }
  if (strcmp("aClipRadii_TR", name) == 0) { aClipRadii_TR = index; return; }
  if (strcmp("aClipRect_BL", name) == 0) { aClipRect_BL = index; return; }
  if (strcmp("aClipRadii_BL", name) == 0) { aClipRadii_BL = index; return; }
  if (strcmp("aClipRect_BR", name) == 0) { aClipRect_BR = index; return; }
  if (strcmp("aClipRadii_BR", name) == 0) { aClipRadii_BR = index; return; }
 }
 int get_loc(const char* name) const {
  if (strcmp("aPosition", name) == 0) { return aPosition != NULL_ATTRIB ? aPosition : -1; }
  if (strcmp("aClipDeviceArea", name) == 0) { return aClipDeviceArea != NULL_ATTRIB ? aClipDeviceArea : -1; }
  if (strcmp("aClipOrigins", name) == 0) { return aClipOrigins != NULL_ATTRIB ? aClipOrigins : -1; }
  if (strcmp("aDevicePixelScale", name) == 0) { return aDevicePixelScale != NULL_ATTRIB ? aDevicePixelScale : -1; }
  if (strcmp("aTransformIds", name) == 0) { return aTransformIds != NULL_ATTRIB ? aTransformIds : -1; }
  if (strcmp("aClipLocalPos", name) == 0) { return aClipLocalPos != NULL_ATTRIB ? aClipLocalPos : -1; }
  if (strcmp("aClipLocalRect", name) == 0) { return aClipLocalRect != NULL_ATTRIB ? aClipLocalRect : -1; }
  if (strcmp("aClipMode", name) == 0) { return aClipMode != NULL_ATTRIB ? aClipMode : -1; }
  if (strcmp("aClipRect_TL", name) == 0) { return aClipRect_TL != NULL_ATTRIB ? aClipRect_TL : -1; }
  if (strcmp("aClipRadii_TL", name) == 0) { return aClipRadii_TL != NULL_ATTRIB ? aClipRadii_TL : -1; }
  if (strcmp("aClipRect_TR", name) == 0) { return aClipRect_TR != NULL_ATTRIB ? aClipRect_TR : -1; }
  if (strcmp("aClipRadii_TR", name) == 0) { return aClipRadii_TR != NULL_ATTRIB ? aClipRadii_TR : -1; }
  if (strcmp("aClipRect_BL", name) == 0) { return aClipRect_BL != NULL_ATTRIB ? aClipRect_BL : -1; }
  if (strcmp("aClipRadii_BL", name) == 0) { return aClipRadii_BL != NULL_ATTRIB ? aClipRadii_BL : -1; }
  if (strcmp("aClipRect_BR", name) == 0) { return aClipRect_BR != NULL_ATTRIB ? aClipRect_BR : -1; }
  if (strcmp("aClipRadii_BR", name) == 0) { return aClipRadii_BR != NULL_ATTRIB ? aClipRadii_BR : -1; }
  return -1;
 }
} attrib_locations;
vec4_scalar vTransformBounds;
vec4_scalar vClipCenter_Radius_TL;
vec4_scalar vClipCenter_Radius_TR;
vec4_scalar vClipCenter_Radius_BL;
vec4_scalar vClipCenter_Radius_BR;
vec3_scalar vClipPlane_TL;
vec3_scalar vClipPlane_TR;
vec3_scalar vClipPlane_BL;
vec3_scalar vClipPlane_BR;
vec2_scalar vClipMode;
sampler2D sGpuCache;
sampler2D sRenderTasks;
sampler2D sTransformPalette;
mat4_scalar uTransform;
void bind_textures() {
 sGpuCache = lookup_sampler(&samplers.sGpuCache_impl, samplers.sGpuCache_slot);
 sRenderTasks = lookup_sampler(&samplers.sRenderTasks_impl, samplers.sRenderTasks_slot);
 sTransformPalette = lookup_sampler(&samplers.sTransformPalette_impl, samplers.sTransformPalette_slot);
}
};
struct cs_clip_rectangle_vert : VertexShaderImpl, cs_clip_rectangle_common {
private:
typedef cs_clip_rectangle_vert Self;
// mat4_scalar uTransform;
vec2 aPosition;
struct RectWithSize_scalar {
vec2_scalar p0;
vec2_scalar size;
RectWithSize_scalar() = default;
RectWithSize_scalar(vec2_scalar p0, vec2_scalar size) : p0(p0), size(size){}
};
struct RectWithSize {
vec2 p0;
vec2 size;
RectWithSize() = default;
RectWithSize(vec2 p0, vec2 size) : p0(p0), size(size){}
RectWithSize(vec2_scalar p0, vec2_scalar size):p0(p0),size(size){
}
IMPLICIT RectWithSize(RectWithSize_scalar s):p0(s.p0),size(s.size){
}
friend RectWithSize if_then_else(I32 c, RectWithSize t, RectWithSize e) { return RectWithSize(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.size, e.size));
}};
struct RectWithEndpoint_scalar {
vec2_scalar p0;
vec2_scalar p1;
RectWithEndpoint_scalar() = default;
RectWithEndpoint_scalar(vec2_scalar p0, vec2_scalar p1) : p0(p0), p1(p1){}
};
struct RectWithEndpoint {
vec2 p0;
vec2 p1;
RectWithEndpoint() = default;
RectWithEndpoint(vec2 p0, vec2 p1) : p0(p0), p1(p1){}
RectWithEndpoint(vec2_scalar p0, vec2_scalar p1):p0(p0),p1(p1){
}
IMPLICIT RectWithEndpoint(RectWithEndpoint_scalar s):p0(s.p0),p1(s.p1){
}
friend RectWithEndpoint if_then_else(I32 c, RectWithEndpoint t, RectWithEndpoint e) { return RectWithEndpoint(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.p1, e.p1));
}};
// sampler2D sRenderTasks;
struct RenderTaskData_scalar {
RectWithEndpoint_scalar task_rect;
vec4_scalar user_data;
RenderTaskData_scalar() = default;
RenderTaskData_scalar(RectWithEndpoint_scalar task_rect, vec4_scalar user_data) : task_rect(task_rect), user_data(user_data){}
};
struct RenderTaskData {
RectWithEndpoint task_rect;
vec4 user_data;
RenderTaskData() = default;
RenderTaskData(RectWithEndpoint task_rect, vec4 user_data) : task_rect(task_rect), user_data(user_data){}
RenderTaskData(RectWithEndpoint_scalar task_rect, vec4_scalar user_data):task_rect(task_rect),user_data(user_data){
}
IMPLICIT RenderTaskData(RenderTaskData_scalar s):task_rect(s.task_rect),user_data(s.user_data){
}
friend RenderTaskData if_then_else(I32 c, RenderTaskData t, RenderTaskData e) { return RenderTaskData(
if_then_else(c, t.task_rect, e.task_rect), if_then_else(c, t.user_data, e.user_data));
}};
struct PictureTask_scalar {
RectWithEndpoint_scalar task_rect;
float device_pixel_scale;
vec2_scalar content_origin;
PictureTask_scalar() = default;
PictureTask_scalar(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar content_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), content_origin(content_origin){}
};
struct PictureTask {
RectWithEndpoint task_rect;
Float device_pixel_scale;
vec2 content_origin;
PictureTask() = default;
PictureTask(RectWithEndpoint task_rect, Float device_pixel_scale, vec2 content_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), content_origin(content_origin){}
PictureTask(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar content_origin):task_rect(task_rect),device_pixel_scale(device_pixel_scale),content_origin(content_origin){
}
IMPLICIT PictureTask(PictureTask_scalar s):task_rect(s.task_rect),device_pixel_scale(s.device_pixel_scale),content_origin(s.content_origin){
}
friend PictureTask if_then_else(I32 c, PictureTask t, PictureTask e) { return PictureTask(
if_then_else(c, t.task_rect, e.task_rect), if_then_else(c, t.device_pixel_scale, e.device_pixel_scale), if_then_else(c, t.content_origin, e.content_origin));
}};
struct ClipArea_scalar {
RectWithEndpoint_scalar task_rect;
float device_pixel_scale;
vec2_scalar screen_origin;
ClipArea_scalar() = default;
ClipArea_scalar(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar screen_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), screen_origin(screen_origin){}
};
struct ClipArea {
RectWithEndpoint task_rect;
Float device_pixel_scale;
vec2 screen_origin;
ClipArea() = default;
ClipArea(RectWithEndpoint task_rect, Float device_pixel_scale, vec2 screen_origin) : task_rect(task_rect), device_pixel_scale(device_pixel_scale), screen_origin(screen_origin){}
ClipArea(RectWithEndpoint_scalar task_rect, float device_pixel_scale, vec2_scalar screen_origin):task_rect(task_rect),device_pixel_scale(device_pixel_scale),screen_origin(screen_origin){
}
IMPLICIT ClipArea(ClipArea_scalar s):task_rect(s.task_rect),device_pixel_scale(s.device_pixel_scale),screen_origin(s.screen_origin){
}
friend ClipArea if_then_else(I32 c, ClipArea t, ClipArea e) { return ClipArea(
if_then_else(c, t.task_rect, e.task_rect), if_then_else(c, t.device_pixel_scale, e.device_pixel_scale), if_then_else(c, t.screen_origin, e.screen_origin));
}};
// sampler2D sGpuCache;
struct ImageSource_scalar {
RectWithEndpoint_scalar uv_rect;
vec4_scalar user_data;
ImageSource_scalar() = default;
ImageSource_scalar(RectWithEndpoint_scalar uv_rect, vec4_scalar user_data) : uv_rect(uv_rect), user_data(user_data){}
};
struct ImageSource {
RectWithEndpoint uv_rect;
vec4 user_data;
ImageSource() = default;
ImageSource(RectWithEndpoint uv_rect, vec4 user_data) : uv_rect(uv_rect), user_data(user_data){}
ImageSource(RectWithEndpoint_scalar uv_rect, vec4_scalar user_data):uv_rect(uv_rect),user_data(user_data){
}
IMPLICIT ImageSource(ImageSource_scalar s):uv_rect(s.uv_rect),user_data(s.user_data){
}
friend ImageSource if_then_else(I32 c, ImageSource t, ImageSource e) { return ImageSource(
if_then_else(c, t.uv_rect, e.uv_rect), if_then_else(c, t.user_data, e.user_data));
}};
struct ImageSourceExtra_scalar {
vec4_scalar st_tl;
vec4_scalar st_tr;
vec4_scalar st_bl;
vec4_scalar st_br;
ImageSourceExtra_scalar() = default;
ImageSourceExtra_scalar(vec4_scalar st_tl, vec4_scalar st_tr, vec4_scalar st_bl, vec4_scalar st_br) : st_tl(st_tl), st_tr(st_tr), st_bl(st_bl), st_br(st_br){}
};
struct ImageSourceExtra {
vec4 st_tl;
vec4 st_tr;
vec4 st_bl;
vec4 st_br;
ImageSourceExtra() = default;
ImageSourceExtra(vec4 st_tl, vec4 st_tr, vec4 st_bl, vec4 st_br) : st_tl(st_tl), st_tr(st_tr), st_bl(st_bl), st_br(st_br){}
ImageSourceExtra(vec4_scalar st_tl, vec4_scalar st_tr, vec4_scalar st_bl, vec4_scalar st_br):st_tl(st_tl),st_tr(st_tr),st_bl(st_bl),st_br(st_br){
}
IMPLICIT ImageSourceExtra(ImageSourceExtra_scalar s):st_tl(s.st_tl),st_tr(s.st_tr),st_bl(s.st_bl),st_br(s.st_br){
}
friend ImageSourceExtra if_then_else(I32 c, ImageSourceExtra t, ImageSourceExtra e) { return ImageSourceExtra(
if_then_else(c, t.st_tl, e.st_tl), if_then_else(c, t.st_tr, e.st_tr), if_then_else(c, t.st_bl, e.st_bl), if_then_else(c, t.st_br, e.st_br));
}};
// vec4_scalar vTransformBounds;
// sampler2D sTransformPalette;
struct Transform_scalar {
mat4_scalar m;
mat4_scalar inv_m;
bool is_axis_aligned;
Transform_scalar() = default;
Transform_scalar(mat4_scalar m, mat4_scalar inv_m, bool is_axis_aligned) : m(m), inv_m(inv_m), is_axis_aligned(is_axis_aligned){}
};
struct Transform {
mat4 m;
mat4 inv_m;
Bool is_axis_aligned;
Transform() = default;
Transform(mat4 m, mat4 inv_m, Bool is_axis_aligned) : m(m), inv_m(inv_m), is_axis_aligned(is_axis_aligned){}
Transform(mat4_scalar m, mat4_scalar inv_m, bool is_axis_aligned):m(m),inv_m(inv_m),is_axis_aligned(is_axis_aligned){
}
IMPLICIT Transform(Transform_scalar s):m(s.m),inv_m(s.inv_m),is_axis_aligned(s.is_axis_aligned){
}
friend Transform if_then_else(I32 c, Transform t, Transform e) { return Transform(
if_then_else(c, t.m, e.m), if_then_else(c, t.inv_m, e.inv_m), if_then_else(c, t.is_axis_aligned, e.is_axis_aligned));
}};
vec4_scalar aClipDeviceArea;
vec4_scalar aClipOrigins;
float aDevicePixelScale;
ivec2_scalar aTransformIds;
struct ClipMaskInstanceCommon_scalar {
RectWithEndpoint_scalar sub_rect;
vec2_scalar task_origin;
vec2_scalar screen_origin;
float device_pixel_scale;
int32_t clip_transform_id;
int32_t prim_transform_id;
ClipMaskInstanceCommon_scalar() = default;
ClipMaskInstanceCommon_scalar(RectWithEndpoint_scalar sub_rect, vec2_scalar task_origin, vec2_scalar screen_origin, float device_pixel_scale, int32_t clip_transform_id, int32_t prim_transform_id) : sub_rect(sub_rect), task_origin(task_origin), screen_origin(screen_origin), device_pixel_scale(device_pixel_scale), clip_transform_id(clip_transform_id), prim_transform_id(prim_transform_id){}
};
struct ClipMaskInstanceCommon {
RectWithEndpoint sub_rect;
vec2 task_origin;
vec2 screen_origin;
Float device_pixel_scale;
I32 clip_transform_id;
I32 prim_transform_id;
ClipMaskInstanceCommon() = default;
ClipMaskInstanceCommon(RectWithEndpoint sub_rect, vec2 task_origin, vec2 screen_origin, Float device_pixel_scale, I32 clip_transform_id, I32 prim_transform_id) : sub_rect(sub_rect), task_origin(task_origin), screen_origin(screen_origin), device_pixel_scale(device_pixel_scale), clip_transform_id(clip_transform_id), prim_transform_id(prim_transform_id){}
ClipMaskInstanceCommon(RectWithEndpoint_scalar sub_rect, vec2_scalar task_origin, vec2_scalar screen_origin, float device_pixel_scale, int32_t clip_transform_id, int32_t prim_transform_id):sub_rect(sub_rect),task_origin(task_origin),screen_origin(screen_origin),device_pixel_scale(device_pixel_scale),clip_transform_id(clip_transform_id),prim_transform_id(prim_transform_id){
}
IMPLICIT ClipMaskInstanceCommon(ClipMaskInstanceCommon_scalar s):sub_rect(s.sub_rect),task_origin(s.task_origin),screen_origin(s.screen_origin),device_pixel_scale(s.device_pixel_scale),clip_transform_id(s.clip_transform_id),prim_transform_id(s.prim_transform_id){
}
friend ClipMaskInstanceCommon if_then_else(I32 c, ClipMaskInstanceCommon t, ClipMaskInstanceCommon e) { return ClipMaskInstanceCommon(
if_then_else(c, t.sub_rect, e.sub_rect), if_then_else(c, t.task_origin, e.task_origin), if_then_else(c, t.screen_origin, e.screen_origin), if_then_else(c, t.device_pixel_scale, e.device_pixel_scale), if_then_else(c, t.clip_transform_id, e.clip_transform_id), if_then_else(c, t.prim_transform_id, e.prim_transform_id));
}};
struct ClipVertexInfo_scalar {
vec4_scalar local_pos;
RectWithEndpoint_scalar clipped_local_rect;
ClipVertexInfo_scalar() = default;
ClipVertexInfo_scalar(vec4_scalar local_pos, RectWithEndpoint_scalar clipped_local_rect) : local_pos(local_pos), clipped_local_rect(clipped_local_rect){}
};
struct ClipVertexInfo {
vec4 local_pos;
RectWithEndpoint clipped_local_rect;
ClipVertexInfo() = default;
ClipVertexInfo(vec4 local_pos, RectWithEndpoint clipped_local_rect) : local_pos(local_pos), clipped_local_rect(clipped_local_rect){}
ClipVertexInfo(vec4_scalar local_pos, RectWithEndpoint_scalar clipped_local_rect):local_pos(local_pos),clipped_local_rect(clipped_local_rect){
}
IMPLICIT ClipVertexInfo(ClipVertexInfo_scalar s):local_pos(s.local_pos),clipped_local_rect(s.clipped_local_rect){
}
friend ClipVertexInfo if_then_else(I32 c, ClipVertexInfo t, ClipVertexInfo e) { return ClipVertexInfo(
if_then_else(c, t.local_pos, e.local_pos), if_then_else(c, t.clipped_local_rect, e.clipped_local_rect));
}};
vec4 vLocalPos;
// vec4_scalar vClipCenter_Radius_TL;
// vec4_scalar vClipCenter_Radius_TR;
// vec4_scalar vClipCenter_Radius_BL;
// vec4_scalar vClipCenter_Radius_BR;
// vec3_scalar vClipPlane_TL;
// vec3_scalar vClipPlane_TR;
// vec3_scalar vClipPlane_BL;
// vec3_scalar vClipPlane_BR;
// vec2_scalar vClipMode;
vec2_scalar aClipLocalPos;
vec4_scalar aClipLocalRect;
float aClipMode;
vec4_scalar aClipRect_TL;
vec4_scalar aClipRadii_TL;
vec4_scalar aClipRect_TR;
vec4_scalar aClipRadii_TR;
vec4_scalar aClipRect_BL;
vec4_scalar aClipRadii_BL;
vec4_scalar aClipRect_BR;
vec4_scalar aClipRadii_BR;
struct ClipMaskInstanceRect_scalar {
ClipMaskInstanceCommon_scalar base;
vec2_scalar local_pos;
ClipMaskInstanceRect_scalar() = default;
ClipMaskInstanceRect_scalar(ClipMaskInstanceCommon_scalar base, vec2_scalar local_pos) : base(base), local_pos(local_pos){}
};
struct ClipMaskInstanceRect {
ClipMaskInstanceCommon base;
vec2 local_pos;
ClipMaskInstanceRect() = default;
ClipMaskInstanceRect(ClipMaskInstanceCommon base, vec2 local_pos) : base(base), local_pos(local_pos){}
ClipMaskInstanceRect(ClipMaskInstanceCommon_scalar base, vec2_scalar local_pos):base(base),local_pos(local_pos){
}
IMPLICIT ClipMaskInstanceRect(ClipMaskInstanceRect_scalar s):base(s.base),local_pos(s.local_pos){
}
friend ClipMaskInstanceRect if_then_else(I32 c, ClipMaskInstanceRect t, ClipMaskInstanceRect e) { return ClipMaskInstanceRect(
if_then_else(c, t.base, e.base), if_then_else(c, t.local_pos, e.local_pos));
}};
struct ClipRect_scalar {
RectWithEndpoint_scalar rect;
float mode;
ClipRect_scalar() = default;
ClipRect_scalar(RectWithEndpoint_scalar rect, float mode) : rect(rect), mode(mode){}
};
struct ClipRect {
RectWithEndpoint rect;
Float mode;
ClipRect() = default;
ClipRect(RectWithEndpoint rect, Float mode) : rect(rect), mode(mode){}
ClipRect(RectWithEndpoint_scalar rect, float mode):rect(rect),mode(mode){
}
IMPLICIT ClipRect(ClipRect_scalar s):rect(s.rect),mode(s.mode){
}
friend ClipRect if_then_else(I32 c, ClipRect t, ClipRect e) { return ClipRect(
if_then_else(c, t.rect, e.rect), if_then_else(c, t.mode, e.mode));
}};
struct ClipCorner_scalar {
RectWithEndpoint_scalar rect;
vec4_scalar outer_inner_radius;
ClipCorner_scalar() = default;
ClipCorner_scalar(RectWithEndpoint_scalar rect, vec4_scalar outer_inner_radius) : rect(rect), outer_inner_radius(outer_inner_radius){}
};
struct ClipCorner {
RectWithEndpoint rect;
vec4 outer_inner_radius;
ClipCorner() = default;
ClipCorner(RectWithEndpoint rect, vec4 outer_inner_radius) : rect(rect), outer_inner_radius(outer_inner_radius){}
ClipCorner(RectWithEndpoint_scalar rect, vec4_scalar outer_inner_radius):rect(rect),outer_inner_radius(outer_inner_radius){
}
IMPLICIT ClipCorner(ClipCorner_scalar s):rect(s.rect),outer_inner_radius(s.outer_inner_radius){
}
friend ClipCorner if_then_else(I32 c, ClipCorner t, ClipCorner e) { return ClipCorner(
if_then_else(c, t.rect, e.rect), if_then_else(c, t.outer_inner_radius, e.outer_inner_radius));
}};
struct ClipData_scalar {
ClipRect_scalar rect;
ClipCorner_scalar top_left;
ClipCorner_scalar top_right;
ClipCorner_scalar bottom_left;
ClipCorner_scalar bottom_right;
ClipData_scalar() = default;
ClipData_scalar(ClipRect_scalar rect, ClipCorner_scalar top_left, ClipCorner_scalar top_right, ClipCorner_scalar bottom_left, ClipCorner_scalar bottom_right) : rect(rect), top_left(top_left), top_right(top_right), bottom_left(bottom_left), bottom_right(bottom_right){}
};
struct ClipData {
ClipRect rect;
ClipCorner top_left;
ClipCorner top_right;
ClipCorner bottom_left;
ClipCorner bottom_right;
ClipData() = default;
ClipData(ClipRect rect, ClipCorner top_left, ClipCorner top_right, ClipCorner bottom_left, ClipCorner bottom_right) : rect(rect), top_left(top_left), top_right(top_right), bottom_left(bottom_left), bottom_right(bottom_right){}
ClipData(ClipRect_scalar rect, ClipCorner_scalar top_left, ClipCorner_scalar top_right, ClipCorner_scalar bottom_left, ClipCorner_scalar bottom_right):rect(rect),top_left(top_left),top_right(top_right),bottom_left(bottom_left),bottom_right(bottom_right){
}
IMPLICIT ClipData(ClipData_scalar s):rect(s.rect),top_left(s.top_left),top_right(s.top_right),bottom_left(s.bottom_left),bottom_right(s.bottom_right){
}
friend ClipData if_then_else(I32 c, ClipData t, ClipData e) { return ClipData(
if_then_else(c, t.rect, e.rect), if_then_else(c, t.top_left, e.top_left), if_then_else(c, t.top_right, e.top_right), if_then_else(c, t.bottom_left, e.bottom_left), if_then_else(c, t.bottom_right, e.bottom_right));
}};
ClipMaskInstanceCommon_scalar fetch_clip_item_common() {
 ClipMaskInstanceCommon_scalar cmi;
 (cmi).sub_rect = RectWithEndpoint_scalar((aClipDeviceArea).sel(X,Y), (aClipDeviceArea).sel(Z,W));
 (cmi).task_origin = (aClipOrigins).sel(X,Y);
 (cmi).screen_origin = (aClipOrigins).sel(Z,W);
 (cmi).device_pixel_scale = aDevicePixelScale;
 (cmi).clip_transform_id = (aTransformIds).x;
 (cmi).prim_transform_id = (aTransformIds).y;
 return cmi;
}
ClipMaskInstanceRect_scalar fetch_clip_item() {
 ClipMaskInstanceRect_scalar cmi;
 (cmi).base = fetch_clip_item_common();
 (cmi).local_pos = aClipLocalPos;
 return cmi;
}
Transform_scalar fetch_transform(int32_t id) {
 Transform_scalar transform;
 (transform).is_axis_aligned = ((id)>>(23))==(0);
 int32_t index = (id)&(8388607);
 ivec2_scalar uv = make_ivec2(make_int((8u)*((make_uint(index))%((1024u)/(8u)))), make_int((make_uint(index))/((1024u)/(8u))));
 ivec2_scalar uv0 = make_ivec2(((uv).x)+(0), (uv).y);
 auto sTransformPalette_uv0_fetch = texelFetchPtr(sTransformPalette, uv0, 0, 7, 0, 0);
 (transform).m[0] = texelFetchUnchecked(sTransformPalette, sTransformPalette_uv0_fetch, 0, 0);
 (transform).m[1] = texelFetchUnchecked(sTransformPalette, sTransformPalette_uv0_fetch, 1, 0);
 (transform).m[2] = texelFetchUnchecked(sTransformPalette, sTransformPalette_uv0_fetch, 2, 0);
 (transform).m[3] = texelFetchUnchecked(sTransformPalette, sTransformPalette_uv0_fetch, 3, 0);
 (transform).inv_m[0] = texelFetchUnchecked(sTransformPalette, sTransformPalette_uv0_fetch, 4, 0);
 (transform).inv_m[1] = texelFetchUnchecked(sTransformPalette, sTransformPalette_uv0_fetch, 5, 0);
 (transform).inv_m[2] = texelFetchUnchecked(sTransformPalette, sTransformPalette_uv0_fetch, 6, 0);
 (transform).inv_m[3] = texelFetchUnchecked(sTransformPalette, sTransformPalette_uv0_fetch, 7, 0);
 return transform;
}
ClipData_scalar fetch_clip() {
 ClipData_scalar clip;
 (clip).rect = ClipRect_scalar(RectWithEndpoint_scalar((aClipLocalRect).sel(X,Y), (aClipLocalRect).sel(Z,W)), aClipMode);
 (clip).top_left = ClipCorner_scalar(RectWithEndpoint_scalar((aClipRect_TL).sel(X,Y), (aClipRect_TL).sel(Z,W)), aClipRadii_TL);
 (clip).top_right = ClipCorner_scalar(RectWithEndpoint_scalar((aClipRect_TR).sel(X,Y), (aClipRect_TR).sel(Z,W)), aClipRadii_TR);
 (clip).bottom_left = ClipCorner_scalar(RectWithEndpoint_scalar((aClipRect_BL).sel(X,Y), (aClipRect_BL).sel(Z,W)), aClipRadii_BL);
 (clip).bottom_right = ClipCorner_scalar(RectWithEndpoint_scalar((aClipRect_BR).sel(X,Y), (aClipRect_BR).sel(Z,W)), aClipRadii_BR);
 return clip;
}
Bool ray_plane(vec3_scalar normal, vec3_scalar pt, vec3 ray_origin, vec3_scalar ray_dir, Float& t) {
 float denom = dot(normal, ray_dir);
 if ((abs(denom))>(0.000001f)) {
  {
   vec3 d = (pt)-(ray_origin);
   t = (dot(d, normal))/(denom);
   return (t)>=(0.f);
  }
 }
 return false;
}
vec4 untransform(vec2 ref, vec3_scalar n, vec3_scalar a, mat4_scalar inv_transform) {
 vec3 p = make_vec3(ref, -(10000.f));
 vec3_scalar d = make_vec3(0, 0, 1.f);
 Float t = 0.f;
 ray_plane(n, a, p, d, t);
 Float z = ((p).z)+(((d).z)*(t));
 vec4 r = (inv_transform)*(make_vec4(ref, z, 1.f));
 return r;
}
vec4 get_node_pos(vec2 pos, Transform_scalar transform) {
 vec4_scalar ah = ((transform).m)*(make_vec4(0.f, 0.f, 0.f, 1.f));
 vec3_scalar a = ((ah).sel(X,Y,Z))/((ah).w);
 vec3_scalar n = (transpose(make_mat3((transform).inv_m)))*(make_vec3(0.f, 0.f, 1.f));
 return untransform(pos, n, a, (transform).inv_m);
}
void rectangle_aa_vertex(vec4_scalar local_bounds) {
 vTransformBounds = local_bounds;
}
ClipVertexInfo write_clip_tile_vertex(RectWithEndpoint_scalar local_clip_rect, Transform_scalar prim_transform, Transform_scalar clip_transform, RectWithEndpoint_scalar sub_rect, vec2_scalar task_origin, vec2_scalar screen_origin, float device_pixel_scale) {
 vec2 device_pos = (screen_origin)+(mix((sub_rect).p0, (sub_rect).p1, (aPosition).sel(X,Y)));
 vec2 world_pos = (device_pos)/(device_pixel_scale);
 vec4 pos = ((prim_transform).m)*(make_vec4(world_pos, 0.f, 1.f));
 (pos).lsel(X,Y,Z) /= (pos).w;
 vec4 p = get_node_pos((pos).sel(X,Y), clip_transform);
 vec4 local_pos = (p)*((pos).w);
 vec4 vertex_pos = make_vec4((task_origin)+(mix((sub_rect).p0, (sub_rect).p1, (aPosition).sel(X,Y))), 0.f, 1.f);
 gl_Position = (uTransform)*(vertex_pos);
 rectangle_aa_vertex(make_vec4((local_clip_rect).p0, (local_clip_rect).p1));
 ClipVertexInfo vi = ClipVertexInfo(local_pos, local_clip_rect);
 return vi;
}
vec2_scalar inverse_radii_squared(vec2_scalar radii) {
 return (1.f)/(max((radii)*(radii), 0.000001f));
}
ALWAYS_INLINE void main(void) {
 ClipMaskInstanceRect_scalar cmi = fetch_clip_item();
 Transform_scalar clip_transform = fetch_transform(((cmi).base).clip_transform_id);
 Transform_scalar prim_transform = fetch_transform(((cmi).base).prim_transform_id);
 ClipData_scalar clip = fetch_clip();
 RectWithEndpoint_scalar local_rect = ((clip).rect).rect;
 vec2_scalar diff = ((cmi).local_pos)-((local_rect).p0);
 (local_rect).p0 = (cmi).local_pos;
 (local_rect).p1 += diff;
 ClipVertexInfo vi = write_clip_tile_vertex(local_rect, prim_transform, clip_transform, ((cmi).base).sub_rect, ((cmi).base).task_origin, ((cmi).base).screen_origin, ((cmi).base).device_pixel_scale);
 (vClipMode).x = ((clip).rect).mode;
 vLocalPos = (vi).local_pos;
 RectWithEndpoint_scalar clip_rect = local_rect;
 vec2_scalar r_tl = (((clip).top_left).outer_inner_radius).sel(X,Y);
 vec2_scalar r_tr = (((clip).top_right).outer_inner_radius).sel(X,Y);
 vec2_scalar r_br = (((clip).bottom_right).outer_inner_radius).sel(X,Y);
 vec2_scalar r_bl = (((clip).bottom_left).outer_inner_radius).sel(X,Y);
 vClipCenter_Radius_TL = make_vec4(((clip_rect).p0)+(r_tl), inverse_radii_squared(r_tl));
 vClipCenter_Radius_TR = make_vec4((((clip_rect).p1).x)-((r_tr).x), (((clip_rect).p0).y)+((r_tr).y), inverse_radii_squared(r_tr));
 vClipCenter_Radius_BR = make_vec4(((clip_rect).p1)-(r_br), inverse_radii_squared(r_br));
 vClipCenter_Radius_BL = make_vec4((((clip_rect).p0).x)+((r_bl).x), (((clip_rect).p1).y)-((r_bl).y), inverse_radii_squared(r_bl));
 vec2_scalar n_tl = -((r_tl).sel(Y,X));
 vec2_scalar n_tr = make_vec2((r_tr).y, -((r_tr).x));
 vec2_scalar n_br = (r_br).sel(Y,X);
 vec2_scalar n_bl = make_vec2(-((r_bl).y), (r_bl).x);
 vClipPlane_TL = make_vec3(n_tl, dot(n_tl, make_vec2(((clip_rect).p0).x, (((clip_rect).p0).y)+((r_tl).y))));
 vClipPlane_TR = make_vec3(n_tr, dot(n_tr, make_vec2((((clip_rect).p1).x)-((r_tr).x), ((clip_rect).p0).y)));
 vClipPlane_BR = make_vec3(n_br, dot(n_br, make_vec2(((clip_rect).p1).x, (((clip_rect).p1).y)-((r_br).y))));
 vClipPlane_BL = make_vec3(n_bl, dot(n_bl, make_vec2((((clip_rect).p0).x)+((r_bl).x), ((clip_rect).p1).y)));
}
static void set_uniform_1i(VertexShaderImpl* impl, int index, int value) {
 Self* self = (Self*)impl;
 if (self->samplers.set_slot(index, value)) return;
 switch (index) {
 case 2:
  assert(0); // sGpuCache
  break;
 case 1:
  assert(0); // sRenderTasks
  break;
 case 3:
  assert(0); // sTransformPalette
  break;
 case 4:
  assert(0); // uTransform
  break;
 }
}
static void set_uniform_4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 2:
  assert(0); // sGpuCache
  break;
 case 1:
  assert(0); // sRenderTasks
  break;
 case 3:
  assert(0); // sTransformPalette
  break;
 case 4:
  assert(0); // uTransform
  break;
 }
}
static void set_uniform_matrix4fv(VertexShaderImpl* impl, int index, const float *value) {
 Self* self = (Self*)impl;
 switch (index) {
 case 2:
  assert(0); // sGpuCache
  break;
 case 1:
  assert(0); // sRenderTasks
  break;
 case 3:
  assert(0); // sTransformPalette
  break;
 case 4:
  self->uTransform = mat4_scalar::load_from_ptr(value);
  break;
 }
}
static void load_attribs(VertexShaderImpl* impl, VertexAttrib *attribs, uint32_t start, int instance, int count) {Self* self = (Self*)impl;
 load_attrib(self->aPosition, attribs[self->attrib_locations.aPosition], start, instance, count);
 load_flat_attrib(self->aClipDeviceArea, attribs[self->attrib_locations.aClipDeviceArea], start, instance, count);
 load_flat_attrib(self->aClipOrigins, attribs[self->attrib_locations.aClipOrigins], start, instance, count);
 load_flat_attrib(self->aDevicePixelScale, attribs[self->attrib_locations.aDevicePixelScale], start, instance, count);
 load_flat_attrib(self->aTransformIds, attribs[self->attrib_locations.aTransformIds], start, instance, count);
 load_flat_attrib(self->aClipLocalPos, attribs[self->attrib_locations.aClipLocalPos], start, instance, count);
 load_flat_attrib(self->aClipLocalRect, attribs[self->attrib_locations.aClipLocalRect], start, instance, count);
 load_flat_attrib(self->aClipMode, attribs[self->attrib_locations.aClipMode], start, instance, count);
 load_flat_attrib(self->aClipRect_TL, attribs[self->attrib_locations.aClipRect_TL], start, instance, count);
 load_flat_attrib(self->aClipRadii_TL, attribs[self->attrib_locations.aClipRadii_TL], start, instance, count);
 load_flat_attrib(self->aClipRect_TR, attribs[self->attrib_locations.aClipRect_TR], start, instance, count);
 load_flat_attrib(self->aClipRadii_TR, attribs[self->attrib_locations.aClipRadii_TR], start, instance, count);
 load_flat_attrib(self->aClipRect_BL, attribs[self->attrib_locations.aClipRect_BL], start, instance, count);
 load_flat_attrib(self->aClipRadii_BL, attribs[self->attrib_locations.aClipRadii_BL], start, instance, count);
 load_flat_attrib(self->aClipRect_BR, attribs[self->attrib_locations.aClipRect_BR], start, instance, count);
 load_flat_attrib(self->aClipRadii_BR, attribs[self->attrib_locations.aClipRadii_BR], start, instance, count);
}
public:
struct InterpOutputs {
vec4_scalar vLocalPos;
};
private:
ALWAYS_INLINE void store_interp_outputs(char* dest_ptr, size_t stride) {
  for(int n = 0; n < 4; n++) {
    auto* dest = reinterpret_cast<InterpOutputs*>(dest_ptr);
    dest->vLocalPos = get_nth(vLocalPos, n);
    dest_ptr += stride;
  }
}
static void run(VertexShaderImpl* impl, char* interps, size_t interp_stride) {
 Self* self = (Self*)impl;
 self->main();
 self->store_interp_outputs(interps, interp_stride);
}
static void init_batch(VertexShaderImpl* impl) {
 Self* self = (Self*)impl; self->bind_textures(); }
public:
cs_clip_rectangle_vert() {
 set_uniform_1i_func = &set_uniform_1i;
 set_uniform_4fv_func = &set_uniform_4fv;
 set_uniform_matrix4fv_func = &set_uniform_matrix4fv;
 init_batch_func = &init_batch;
 load_attribs_func = &load_attribs;
 run_primitive_func = &run;
}
};


struct cs_clip_rectangle_frag : FragmentShaderImpl, cs_clip_rectangle_vert {
private:
typedef cs_clip_rectangle_frag Self;
#define oFragColor gl_FragColor
// vec4 oFragColor;
struct RectWithSize_scalar {
vec2_scalar p0;
vec2_scalar size;
RectWithSize_scalar() = default;
RectWithSize_scalar(vec2_scalar p0, vec2_scalar size) : p0(p0), size(size){}
};
struct RectWithSize {
vec2 p0;
vec2 size;
RectWithSize() = default;
RectWithSize(vec2 p0, vec2 size) : p0(p0), size(size){}
RectWithSize(vec2_scalar p0, vec2_scalar size):p0(p0),size(size){
}
IMPLICIT RectWithSize(RectWithSize_scalar s):p0(s.p0),size(s.size){
}
friend RectWithSize if_then_else(I32 c, RectWithSize t, RectWithSize e) { return RectWithSize(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.size, e.size));
}};
struct RectWithEndpoint_scalar {
vec2_scalar p0;
vec2_scalar p1;
RectWithEndpoint_scalar() = default;
RectWithEndpoint_scalar(vec2_scalar p0, vec2_scalar p1) : p0(p0), p1(p1){}
};
struct RectWithEndpoint {
vec2 p0;
vec2 p1;
RectWithEndpoint() = default;
RectWithEndpoint(vec2 p0, vec2 p1) : p0(p0), p1(p1){}
RectWithEndpoint(vec2_scalar p0, vec2_scalar p1):p0(p0),p1(p1){
}
IMPLICIT RectWithEndpoint(RectWithEndpoint_scalar s):p0(s.p0),p1(s.p1){
}
friend RectWithEndpoint if_then_else(I32 c, RectWithEndpoint t, RectWithEndpoint e) { return RectWithEndpoint(
if_then_else(c, t.p0, e.p0), if_then_else(c, t.p1, e.p1));
}};
// sampler2D sGpuCache;
// vec4_scalar vTransformBounds;
vec4 vLocalPos;
// vec4_scalar vClipCenter_Radius_TL;
// vec4_scalar vClipCenter_Radius_TR;
// vec4_scalar vClipCenter_Radius_BL;
// vec4_scalar vClipCenter_Radius_BR;
// vec3_scalar vClipPlane_TL;
// vec3_scalar vClipPlane_TR;
// vec3_scalar vClipPlane_BL;
// vec3_scalar vClipPlane_BR;
// vec2_scalar vClipMode;
float compute_aa_range(vec2 position) {
 return recip((fwidth(position)).x);
}
Float distance_to_ellipse_approx(vec2 p, vec2 inv_radii_sq, float scale) {
 vec2 p_r = (p)*(inv_radii_sq);
 Float g = (dot(p, p_r))-(scale);
 vec2 dG = ((1.f)+(scale))*(p_r);
 return (g)*(inversesqrt(dot(dG, dG)));
}
vec2 signed_distance_rect_xy(vec2 pos, vec2_scalar p0, vec2_scalar p1) {
 return max((p0)-(pos), (pos)-(p1));
}
Float signed_distance_rect(vec2 pos, vec2_scalar p0, vec2_scalar p1) {
 vec2 d = signed_distance_rect_xy(pos, p0, p1);
 return max((d).x, (d).y);
}
Float distance_to_rounded_rect(vec2 pos, vec3_scalar plane_tl, vec4 center_radius_tl, vec3_scalar plane_tr, vec4 center_radius_tr, vec3_scalar plane_br, vec4 center_radius_br, vec3_scalar plane_bl, vec4 center_radius_bl, vec4_scalar rect_bounds) {
 vec4 corner = make_vec4(make_vec2(0.000001f), make_vec2(1.f));
 (center_radius_tl).lsel(X,Y) = ((center_radius_tl).sel(X,Y))-(pos);
 (center_radius_tr).lsel(X,Y) = (((center_radius_tr).sel(X,Y))-(pos))*(make_vec2(-(1.f), 1.f));
 (center_radius_br).lsel(X,Y) = (pos)-((center_radius_br).sel(X,Y));
 (center_radius_bl).lsel(X,Y) = (((center_radius_bl).sel(X,Y))-(pos))*(make_vec2(1.f, -(1.f)));
 auto _c5_ = (dot(pos, (plane_tl).sel(X,Y)))>((plane_tl).z);
 {
  corner = if_then_else(_c5_,center_radius_tl,corner);
 }
 auto _c6_ = (dot(pos, (plane_tr).sel(X,Y)))>((plane_tr).z);
 {
  corner = if_then_else(_c6_,center_radius_tr,corner);
 }
 auto _c7_ = (dot(pos, (plane_br).sel(X,Y)))>((plane_br).z);
 {
  corner = if_then_else(_c7_,center_radius_br,corner);
 }
 auto _c8_ = (dot(pos, (plane_bl).sel(X,Y)))>((plane_bl).z);
 {
  corner = if_then_else(_c8_,center_radius_bl,corner);
 }
 return max(distance_to_ellipse_approx((corner).sel(X,Y), (corner).sel(Z,W), 1.f), signed_distance_rect(pos, (rect_bounds).sel(X,Y), (rect_bounds).sel(Z,W)));
}
Float distance_aa(float aa_range, Float signed_distance) {
 Float dist = (signed_distance)*(aa_range);
 return clamp((0.5f)-(dist), 0.f, 1.f);
}
ALWAYS_INLINE void main(void) {
 vec2 local_pos = ((vLocalPos).sel(X,Y))/((vLocalPos).w);
 float aa_range = compute_aa_range(local_pos);
 Float dist = distance_to_rounded_rect(local_pos, vClipPlane_TL, vClipCenter_Radius_TL, vClipPlane_TR, vClipCenter_Radius_TR, vClipPlane_BR, vClipCenter_Radius_BR, vClipPlane_BL, vClipCenter_Radius_BL, vTransformBounds);
 Float alpha = distance_aa(aa_range, dist);
 Float final_alpha = mix(alpha, (1.f)-(alpha), (vClipMode).x);
 Float final_final_alpha = if_then_else(((vLocalPos).w)>(0.f), final_alpha, 0.f);
 oFragColor = make_vec4(final_final_alpha, 0.f, 0.f, 1.f);
}
Float distance_to_ellipse_approx(vec2 p, vec2_scalar inv_radii_sq, float scale) {
 vec2 p_r = (p)*(inv_radii_sq);
 Float g = (dot(p, p_r))-(scale);
 vec2 dG = ((1.f)+(scale))*(p_r);
 return (g)*(inversesqrt(dot(dG, dG)));
}
void swgl_drawSpanR8() {
 if (((swgl_interpStep(vLocalPos)).w)!=(0.f)) {
  {
   return;
  }
 }
 float w = swgl_forceScalar((vLocalPos).w);
 if ((w)<=(0.f)) {
  {
   swgl_commitSolidR8(0.f);
   return;
  }
 }
 w = (1.f)/(w);
 vec2 local_pos = ((vLocalPos).sel(X,Y))*(w);
 vec2_scalar local_pos0 = swgl_forceScalar(local_pos);
 vec2_scalar local_step = ((swgl_interpStep(vLocalPos)).sel(X,Y))*(w);
 float step_scale = max(dot(local_step, local_step), 0.000001f);
 float aa_range = compute_aa_range(local_pos);
 float aa_margin = inversesqrt(((aa_range)*(aa_range))*(step_scale));
 vec4_scalar clip_rect = vTransformBounds;
 vec4_scalar clip_dist = (mix(clip_rect, (clip_rect).sel(Z,W,X,Y), (lessThan(local_step, make_vec2(0.f))).sel(X,Y,X,Y)))-((local_pos0).sel(X,Y,X,Y));
 clip_dist = mix((1000000.f)*(step(0.f, clip_dist)), (clip_dist)*((recip(local_step)).sel(X,Y,X,Y)), (notEqual(local_step, make_vec2(0.f))).sel(X,Y,X,Y));
 float opaque_start = max((clip_dist).x, (clip_dist).y);
 float opaque_end = min((clip_dist).z, (clip_dist).w);
 float aa_start = opaque_start;
 float aa_end = opaque_end;
 vec3_scalar start_plane = make_vec3(1000000.f);
 vec3_scalar end_plane = make_vec3(1000000.f);
 vec4_scalar start_corner = make_vec4(make_vec2(1000000.f), make_vec2(1.f));
 vec4_scalar end_corner = make_vec4(make_vec2(1000000.f), make_vec2(1.f));
 do  {
  float dist = (dot(local_pos0, (vClipPlane_TL).sel(X,Y)))-((vClipPlane_TL).z);
  float scale = -(dot(local_step, (vClipPlane_TL).sel(X,Y)));
  if ((scale)>=(0.f)) {
   {
    if ((dist)>((opaque_start)*(scale))) {
     {
      start_corner = vClipCenter_Radius_TL;
      start_plane = vClipPlane_TL;
      float inv_scale = recip(max(scale, 0.000001f));
      opaque_start = (dist)*(inv_scale);
      float apex = (((0.7071f)-(0.5f))*(2.f))*(abs(((vClipPlane_TL).x)*((vClipPlane_TL).y)));
      aa_start = (opaque_start)-((apex)*(inv_scale));
     }
    }
   }
  } else   if ((dist)>((opaque_end)*(scale))) {
   {
    end_corner = vClipCenter_Radius_TL;
    end_plane = vClipPlane_TL;
    float inv_scale = recip(min(scale, -(0.000001f)));
    opaque_end = (dist)*(inv_scale);
    float apex = (((0.7071f)-(0.5f))*(2.f))*(abs(((vClipPlane_TL).x)*((vClipPlane_TL).y)));
    aa_end = (opaque_end)-((apex)*(inv_scale));
   }
  }
 }
 while (false);
 do  {
  float dist = (dot(local_pos0, (vClipPlane_TR).sel(X,Y)))-((vClipPlane_TR).z);
  float scale = -(dot(local_step, (vClipPlane_TR).sel(X,Y)));
  if ((scale)>=(0.f)) {
   {
    if ((dist)>((opaque_start)*(scale))) {
     {
      start_corner = vClipCenter_Radius_TR;
      start_plane = vClipPlane_TR;
      float inv_scale = recip(max(scale, 0.000001f));
      opaque_start = (dist)*(inv_scale);
      float apex = (((0.7071f)-(0.5f))*(2.f))*(abs(((vClipPlane_TR).x)*((vClipPlane_TR).y)));
      aa_start = (opaque_start)-((apex)*(inv_scale));
     }
    }
   }
  } else   if ((dist)>((opaque_end)*(scale))) {
   {
    end_corner = vClipCenter_Radius_TR;
    end_plane = vClipPlane_TR;
    float inv_scale = recip(min(scale, -(0.000001f)));
    opaque_end = (dist)*(inv_scale);
    float apex = (((0.7071f)-(0.5f))*(2.f))*(abs(((vClipPlane_TR).x)*((vClipPlane_TR).y)));
    aa_end = (opaque_end)-((apex)*(inv_scale));
   }
  }
 }
 while (false);
 do  {
  float dist = (dot(local_pos0, (vClipPlane_BR).sel(X,Y)))-((vClipPlane_BR).z);
  float scale = -(dot(local_step, (vClipPlane_BR).sel(X,Y)));
  if ((scale)>=(0.f)) {
   {
    if ((dist)>((opaque_start)*(scale))) {
     {
      start_corner = vClipCenter_Radius_BR;
      start_plane = vClipPlane_BR;
      float inv_scale = recip(max(scale, 0.000001f));
      opaque_start = (dist)*(inv_scale);
      float apex = (((0.7071f)-(0.5f))*(2.f))*(abs(((vClipPlane_BR).x)*((vClipPlane_BR).y)));
      aa_start = (opaque_start)-((apex)*(inv_scale));
     }
    }
   }
  } else   if ((dist)>((opaque_end)*(scale))) {
   {
    end_corner = vClipCenter_Radius_BR;
    end_plane = vClipPlane_BR;
    float inv_scale = recip(min(scale, -(0.000001f)));
    opaque_end = (dist)*(inv_scale);
    float apex = (((0.7071f)-(0.5f))*(2.f))*(abs(((vClipPlane_BR).x)*((vClipPlane_BR).y)));
    aa_end = (opaque_end)-((apex)*(inv_scale));
   }
  }
 }
 while (false);
 do  {
  float dist = (dot(local_pos0, (vClipPlane_BL).sel(X,Y)))-((vClipPlane_BL).z);
  float scale = -(dot(local_step, (vClipPlane_BL).sel(X,Y)));
  if ((scale)>=(0.f)) {
   {
    if ((dist)>((opaque_start)*(scale))) {
     {
      start_corner = vClipCenter_Radius_BL;
      start_plane = vClipPlane_BL;
      float inv_scale = recip(max(scale, 0.000001f));
      opaque_start = (dist)*(inv_scale);
      float apex = (((0.7071f)-(0.5f))*(2.f))*(abs(((vClipPlane_BL).x)*((vClipPlane_BL).y)));
      aa_start = (opaque_start)-((apex)*(inv_scale));
     }
    }
   }
  } else   if ((dist)>((opaque_end)*(scale))) {
   {
    end_corner = vClipCenter_Radius_BL;
    end_plane = vClipPlane_BL;
    float inv_scale = recip(min(scale, -(0.000001f)));
    opaque_end = (dist)*(inv_scale);
    float apex = (((0.7071f)-(0.5f))*(2.f))*(abs(((vClipPlane_BL).x)*((vClipPlane_BL).y)));
    aa_end = (opaque_end)-((apex)*(inv_scale));
   }
  }
 }
 while (false);
 aa_margin = max((aa_margin)-(max((aa_start)-(aa_end), 0.f)), 0.f);
 aa_start -= aa_margin;
 aa_end += aa_margin;
 ivec4_scalar steps = make_ivec4(clamp((swgl_SpanLength)-((swgl_StepSize)*(make_vec4(floor(aa_start), ceil(opaque_start), floor(opaque_end), ceil(aa_end)))), 0.f, swgl_SpanLength));
 int32_t aa_start_len = (steps).x;
 int32_t opaque_start_len = (steps).y;
 int32_t opaque_end_len = (steps).z;
 int32_t aa_end_len = (steps).w;
 if ((swgl_SpanLength)>(aa_start_len)) {
  {
   int32_t num_aa = (swgl_SpanLength)-(aa_start_len);
   swgl_commitPartialSolidR8(num_aa, (vClipMode).x);
   local_pos += (make_float((num_aa)/(swgl_StepSize)))*(local_step);
  }
 }
 if (((start_plane).x)<(100000.f)) {
  {
   while ((swgl_SpanLength)>(opaque_start_len))    {
    Float alpha = distance_aa(aa_range, if_then_else((dot(local_pos, (start_plane).sel(X,Y)))>((start_plane).z), distance_to_ellipse_approx((local_pos)-((start_corner).sel(X,Y)), (start_corner).sel(Z,W), 1.f), signed_distance_rect(local_pos, (vTransformBounds).sel(X,Y), (vTransformBounds).sel(Z,W))));
    swgl_commitColorR8(mix(alpha, (1.f)-(alpha), (vClipMode).x));
    local_pos += local_step;
   }
  }
 }
 while ((swgl_SpanLength)>(opaque_start_len))  {
  Float alpha = distance_aa(aa_range, signed_distance_rect(local_pos, (vTransformBounds).sel(X,Y), (vTransformBounds).sel(Z,W)));
  swgl_commitColorR8(mix(alpha, (1.f)-(alpha), (vClipMode).x));
  local_pos += local_step;
 }
 if ((swgl_SpanLength)>(opaque_end_len)) {
  {
   int32_t num_opaque = (swgl_SpanLength)-(opaque_end_len);
   swgl_commitPartialSolidR8(num_opaque, (1.f)-((vClipMode).x));
   local_pos += (make_float((num_opaque)/(swgl_StepSize)))*(local_step);
  }
 }
 if (((end_plane).x)<(100000.f)) {
  {
   while ((swgl_SpanLength)>(aa_end_len))    {
    Float alpha = distance_aa(aa_range, if_then_else((dot(local_pos, (end_plane).sel(X,Y)))>((end_plane).z), distance_to_ellipse_approx((local_pos)-((end_corner).sel(X,Y)), (end_corner).sel(Z,W), 1.f), signed_distance_rect(local_pos, (vTransformBounds).sel(X,Y), (vTransformBounds).sel(Z,W))));
    swgl_commitColorR8(mix(alpha, (1.f)-(alpha), (vClipMode).x));
    local_pos += local_step;
   }
  }
 }
 while ((swgl_SpanLength)>(aa_end_len))  {
  Float alpha = distance_aa(aa_range, signed_distance_rect(local_pos, (vTransformBounds).sel(X,Y), (vTransformBounds).sel(Z,W)));
  swgl_commitColorR8(mix(alpha, (1.f)-(alpha), (vClipMode).x));
  local_pos += local_step;
 }
 if ((swgl_SpanLength)>(0)) {
  {
   swgl_commitPartialSolidR8(swgl_SpanLength, (vClipMode).x);
  }
 }
}
typedef cs_clip_rectangle_vert::InterpOutputs InterpInputs;
InterpInputs interp_step;
struct InterpPerspective {
vec4 vLocalPos;
};
InterpPerspective interp_perspective;
static void read_interp_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  self->vLocalPos = init_interp(init->vLocalPos, step->vLocalPos);
  self->interp_step.vLocalPos = step->vLocalPos * 4.0f;
}
static void read_perspective_inputs(FragmentShaderImpl* impl, const void* init_, const void* step_) {Self* self = (Self*)impl;const InterpInputs* init = (const InterpInputs*)init_;const InterpInputs* step = (const InterpInputs*)step_;
  Float w = 1.0f / self->gl_FragCoord.w;
  self->interp_perspective.vLocalPos = init_interp(init->vLocalPos, step->vLocalPos);
  self->vLocalPos = self->interp_perspective.vLocalPos * w;
  self->interp_step.vLocalPos = step->vLocalPos * 4.0f;
}
ALWAYS_INLINE void step_interp_inputs(int steps = 4) {
  float chunks = steps * 0.25f;
  vLocalPos += interp_step.vLocalPos * chunks;
}
ALWAYS_INLINE void step_perspective_inputs(int steps = 4) {
  step_perspective(steps);
  float chunks = steps * 0.25f;
  Float w = 1.0f / gl_FragCoord.w;
  interp_perspective.vLocalPos += interp_step.vLocalPos * chunks;
  vLocalPos = w * interp_perspective.vLocalPos;
}
static void run(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_interp_inputs();
}
static void skip(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_interp_inputs(steps);
}
static void run_perspective(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl;
 self->main();
 self->step_perspective_inputs();
}
static void skip_perspective(FragmentShaderImpl* impl, int steps) {
 Self* self = (Self*)impl;
 self->step_perspective_inputs(steps);
}
static int draw_span_R8(FragmentShaderImpl* impl) {
 Self* self = (Self*)impl; DISPATCH_DRAW_SPAN(self, R8); }
public:
cs_clip_rectangle_frag() {
 init_span_func = &read_interp_inputs;
 run_func = &run;
 skip_func = &skip;
 draw_span_R8_func = &draw_span_R8;
 enable_perspective();
 init_span_w_func = &read_perspective_inputs;
 run_w_func = &run_perspective;
 skip_w_func = &skip_perspective;
}
};

struct cs_clip_rectangle_program : ProgramImpl, cs_clip_rectangle_frag {
int get_uniform(const char *name) const override {
 if (strcmp("sGpuCache", name) == 0) { return 2; }
 if (strcmp("sRenderTasks", name) == 0) { return 1; }
 if (strcmp("sTransformPalette", name) == 0) { return 3; }
 if (strcmp("uTransform", name) == 0) { return 4; }
 return -1;
}
void bind_attrib(const char* name, int index) override {
 attrib_locations.bind_loc(name, index);
}
int get_attrib(const char* name) const override {
 return attrib_locations.get_loc(name);
}
size_t interpolants_size() const override { return sizeof(InterpOutputs); }
VertexShaderImpl* get_vertex_shader() override {
 return this;
}
FragmentShaderImpl* get_fragment_shader() override {
 return this;
}
const char* get_name() const override { return "cs_clip_rectangle"; }
static ProgramImpl* loader() { return new cs_clip_rectangle_program; }
};

