//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/loader/PScriptCacheChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/TimeStamp.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/loader/ScriptCacheActors.h"

#include "mozilla/dom/PContentChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace loader {


MOZ_IMPLICIT PScriptCacheChild::PScriptCacheChild() :
    mozilla::ipc::IProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PScriptCacheChild);
}

PScriptCacheChild::~PScriptCacheChild()
{
    MOZ_COUNT_DTOR(PScriptCacheChild);
}

auto PScriptCacheChild::ActorAlloc() -> void
{
}

auto PScriptCacheChild::ActorDealloc() -> void
{
    if (Manager()) {
        Manager()->DeallocManagee(kProtocolId, this);
    }
}

auto PScriptCacheChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PScriptCacheChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PScriptCacheChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PScriptCacheChild::Manager() const -> PContentChild*
{
    return static_cast<PContentChild*>(IProtocol::Manager());
}

auto PScriptCacheChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PScriptCacheChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PScriptCacheChild::Send__delete__(
        PScriptCacheChild* actor,
        mozilla::Span<ScriptData const> scripts) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PScriptCache::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};

    IPC::WriteParam((&(writer__)), scripts);
    // Sentinel = 'scripts'
    ((&(writer__)))->WriteSentinel(201786121);

    if (mozilla::ipc::LoggingEnabledFor("PScriptCache", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PScriptCacheChild",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PScriptCache::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PScriptCacheChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PScriptCacheChild::OnMessageReceived(const Message& msg__) -> PScriptCacheChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PScriptCache::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PScriptCacheChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PScriptCacheChild::Result
{
    return MsgNotKnown;
}



} // namespace loader
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::loader::PScriptCacheChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PScriptCache'
    (aWriter)->WriteSentinel(494797978);
}

auto ParamTraits<::mozilla::loader::PScriptCacheChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PScriptCache actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PScriptCache'
    if ((!((aReader)->ReadSentinel(494797978)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PScriptCache actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PScriptCacheMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PScriptCache)");

        return {};
    }
    return static_cast<::mozilla::loader::PScriptCacheChild*>(actor);
}

} // namespace IPC
