//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/net/PDNSRequestChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/TimeStamp.h"
#include "mozilla/net/DNSRequestChild.h"
#include "mozilla/net/NeckoMessageUtils.h"

#include "mozilla/net/PNeckoChild.h"
#include "mozilla/net/PSocketProcessChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace net {


auto PDNSRequestChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PDNSRequestChild::PDNSRequestChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PDNSRequestChild);
}

PDNSRequestChild::~PDNSRequestChild()
{
    MOZ_COUNT_DTOR(PDNSRequestChild);
}

auto PDNSRequestChild::ActorAlloc() -> void
{
    AddRef();
}

auto PDNSRequestChild::ActorDealloc() -> void
{
    Release();
}

auto PDNSRequestChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PDNSRequestChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PDNSRequestChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PDNSRequestChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PDNSRequestChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PDNSRequestChild::SendCancelDNSRequest(
        const nsACString& hostName,
        const nsACString& trrServer,
        const int32_t& port,
        const uint16_t& type,
        const OriginAttributes& originAttributes,
        const DNSFlags& flags,
        const nsresult& reason) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDNSRequest::Msg_CancelDNSRequest(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), hostName);
    // Sentinel = 'hostName'
    ((&(writer__)))->WriteSentinel(249627456);
    IPC::WriteParam((&(writer__)), trrServer);
    // Sentinel = 'trrServer'
    ((&(writer__)))->WriteSentinel(320603088);
    IPC::WriteParam((&(writer__)), port);
    // Sentinel = 'port'
    ((&(writer__)))->WriteSentinel(73990598);
    IPC::WriteParam((&(writer__)), type);
    // Sentinel = 'type'
    ((&(writer__)))->WriteSentinel(75760067);
    IPC::WriteParam((&(writer__)), originAttributes);
    // Sentinel = 'originAttributes'
    ((&(writer__)))->WriteSentinel(947259056);
    IPC::WriteParam((&(writer__)), flags);
    // Sentinel = 'flags'
    ((&(writer__)))->WriteSentinel(102171150);
    IPC::WriteParam((&(writer__)), reason);
    // Sentinel = 'reason'
    ((&(writer__)))->WriteSentinel(148112009);


    if (mozilla::ipc::LoggingEnabledFor("PDNSRequest", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDNSRequestChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDNSRequest::Msg_CancelDNSRequest", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDNSRequestChild::Send__delete__(PDNSRequestChild* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PDNSRequest::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PDNSRequest", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDNSRequestChild",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDNSRequest::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PDNSRequestChild::SendLookupCompleted(const DNSRequestResponse& reply) -> bool
{
    UniquePtr<IPC::Message> msg__ = PDNSRequest::Msg_LookupCompleted(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), reply);
    // Sentinel = 'reply'
    ((&(writer__)))->WriteSentinel(108266029);


    if (mozilla::ipc::LoggingEnabledFor("PDNSRequest", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDNSRequestChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDNSRequest::Msg_LookupCompleted", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PDNSRequestChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PDNSRequestChild::OnMessageReceived(const Message& msg__) -> PDNSRequestChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PDNSRequest::Msg_CancelDNSRequest__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDNSRequest", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDNSRequestChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDNSRequest::Msg_CancelDNSRequest", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__hostName = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__hostName) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& hostName = *maybe__hostName;
            // Sentinel = 'hostName'
            if ((!(((&(reader__)))->ReadSentinel(249627456)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__trrServer = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__trrServer) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& trrServer = *maybe__trrServer;
            // Sentinel = 'trrServer'
            if ((!(((&(reader__)))->ReadSentinel(320603088)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__port = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__port) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& port = *maybe__port;
            // Sentinel = 'port'
            if ((!(((&(reader__)))->ReadSentinel(73990598)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            auto maybe__type = IPC::ReadParam<uint16_t>((&(reader__)));
            if (!maybe__type) {
                FatalError("Error deserializing 'uint16_t'");
                return MsgValueError;

            }
            auto& type = *maybe__type;
            // Sentinel = 'type'
            if ((!(((&(reader__)))->ReadSentinel(75760067)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint16_t'");
                return MsgValueError;
            }
            auto maybe__originAttributes = IPC::ReadParam<OriginAttributes>((&(reader__)));
            if (!maybe__originAttributes) {
                FatalError("Error deserializing 'OriginAttributes'");
                return MsgValueError;

            }
            auto& originAttributes = *maybe__originAttributes;
            // Sentinel = 'originAttributes'
            if ((!(((&(reader__)))->ReadSentinel(947259056)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OriginAttributes'");
                return MsgValueError;
            }
            auto maybe__flags = IPC::ReadParam<DNSFlags>((&(reader__)));
            if (!maybe__flags) {
                FatalError("Error deserializing 'DNSFlags'");
                return MsgValueError;

            }
            auto& flags = *maybe__flags;
            // Sentinel = 'flags'
            if ((!(((&(reader__)))->ReadSentinel(102171150)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'DNSFlags'");
                return MsgValueError;
            }
            auto maybe__reason = IPC::ReadParam<nsresult>((&(reader__)));
            if (!maybe__reason) {
                FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& reason = *maybe__reason;
            // Sentinel = 'reason'
            if ((!(((&(reader__)))->ReadSentinel(148112009)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<DNSRequestChild*>(this))->RecvCancelDNSRequest(std::move(hostName), std::move(trrServer), std::move(port), std::move(type), std::move(originAttributes), std::move(flags), std::move(reason));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PDNSRequest::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    case PDNSRequest::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDNSRequest", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDNSRequestChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDNSRequest::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<DNSRequestChild*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    case PDNSRequest::Msg_LookupCompleted__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PDNSRequest", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PDNSRequestChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PDNSRequest::Msg_LookupCompleted", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__reply = IPC::ReadParam<DNSRequestResponse>((&(reader__)));
            if (!maybe__reply) {
                FatalError("Error deserializing 'DNSRequestResponse'");
                return MsgValueError;

            }
            auto& reply = *maybe__reply;
            // Sentinel = 'reply'
            if ((!(((&(reader__)))->ReadSentinel(108266029)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'DNSRequestResponse'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<DNSRequestChild*>(this))->RecvLookupCompleted(std::move(reply));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PDNSRequestChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PDNSRequestChild::Result
{
    return MsgNotKnown;
}



} // namespace net
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::net::PDNSRequestChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PDNSRequest'
    (aWriter)->WriteSentinel(380044319);
}

auto ParamTraits<::mozilla::net::PDNSRequestChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PDNSRequest actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PDNSRequest'
    if ((!((aReader)->ReadSentinel(380044319)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PDNSRequest actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PDNSRequestMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PDNSRequest)");

        return {};
    }
    return static_cast<::mozilla::net::PDNSRequestChild*>(actor);
}

} // namespace IPC
