//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/gfx/PCanvasManagerChild.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/ProfilerMarkers.h"
#include "mozilla/gfx/CanvasManagerChild.h"
#include "mozilla/layers/LayersMessageUtils.h"

#include "mozilla/layers/PCanvasChild.h"
#include "mozilla/dom/PWebGLChild.h"
#include "mozilla/webgpu/PWebGPUChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace gfx {


auto PCanvasManagerChild::ProcessingError(
        Result aCode,
        const char* aReason) -> void
{
}

auto PCanvasManagerChild::ShouldContinueFromReplyTimeout() -> bool
{
    return true;
}

MOZ_IMPLICIT PCanvasManagerChild::PCanvasManagerChild() :
    mozilla::ipc::IToplevelProtocol("PCanvasManagerChild", kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PCanvasManagerChild);
}

PCanvasManagerChild::~PCanvasManagerChild()
{
    MOZ_COUNT_DTOR(PCanvasManagerChild);
}

auto PCanvasManagerChild::ActorAlloc() -> void
{
    MOZ_RELEASE_ASSERT(XRE_IsParentProcess() || XRE_IsContentProcess(), "Invalid process for `PCanvasManagerChild'");
    AddRef();
}

auto PCanvasManagerChild::ActorDealloc() -> void
{
    Release();
}

auto PCanvasManagerChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PCanvasManagerChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PCanvasManagerChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PCanvasManagerChild::ManagedPCanvasChild(nsTArray<PCanvasChild*>& aArr) const -> void
{
    mManagedPCanvasChild.ToArray(aArr);
}

auto PCanvasManagerChild::ManagedPCanvasChild() const -> const ManagedContainer<PCanvasChild>&
{
    return mManagedPCanvasChild;
}

auto PCanvasManagerChild::ManagedPWebGLChild(nsTArray<PWebGLChild*>& aArr) const -> void
{
    mManagedPWebGLChild.ToArray(aArr);
}

auto PCanvasManagerChild::ManagedPWebGLChild() const -> const ManagedContainer<PWebGLChild>&
{
    return mManagedPWebGLChild;
}

auto PCanvasManagerChild::ManagedPWebGPUChild(nsTArray<PWebGPUChild*>& aArr) const -> void
{
    mManagedPWebGPUChild.ToArray(aArr);
}

auto PCanvasManagerChild::ManagedPWebGPUChild() const -> const ManagedContainer<PWebGPUChild>&
{
    return mManagedPWebGPUChild;
}

auto PCanvasManagerChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PCanvasMsgStart,
        PWebGLMsgStart,
        PWebGPUMsgStart
    };
    return sIds;
}

auto PCanvasManagerChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PCanvasMsgStart:
        return (&(mManagedPCanvasChild));
    case PWebGLMsgStart:
        return (&(mManagedPWebGLChild));
    case PWebGPUMsgStart:
        return (&(mManagedPWebGPUChild));
    default:
        return nullptr;
    }
}

auto PCanvasManagerChild::OpenPCanvasEndpoint(PCanvasChild* aActor) -> ManagedEndpoint<PCanvasParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PCanvasChild actor");
        return ManagedEndpoint<PCanvasParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PCanvasChild actor");
        return ManagedEndpoint<PCanvasParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PCanvasParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PCanvasManagerChild::BindPCanvasEndpoint(
        ManagedEndpoint<PCanvasChild> aEndpoint,
        PCanvasChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PCanvasManagerChild::OpenPWebGLEndpoint(PWebGLChild* aActor) -> ManagedEndpoint<PWebGLParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PWebGLChild actor");
        return ManagedEndpoint<PWebGLParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PWebGLChild actor");
        return ManagedEndpoint<PWebGLParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PWebGLParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PCanvasManagerChild::BindPWebGLEndpoint(
        ManagedEndpoint<PWebGLChild> aEndpoint,
        PWebGLChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PCanvasManagerChild::OpenPWebGPUEndpoint(PWebGPUChild* aActor) -> ManagedEndpoint<PWebGPUParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PWebGPUChild actor");
        return ManagedEndpoint<PWebGPUParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PWebGPUChild actor");
        return ManagedEndpoint<PWebGPUParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PWebGPUParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PCanvasManagerChild::BindPWebGPUEndpoint(
        ManagedEndpoint<PWebGPUChild> aEndpoint,
        PWebGPUChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PCanvasManagerChild::SendPCanvasConstructor(PCanvasChild* actor) -> PCanvasChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PCanvasChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PCanvasChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PCanvasManager::Msg_PCanvasConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PCanvasManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCanvasManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCanvasManager::Msg_PCanvasConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PCanvasChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PCanvasManagerChild::SendPWebGLConstructor(PWebGLChild* actor) -> PWebGLChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PWebGLChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PWebGLChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PCanvasManager::Msg_PWebGLConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PCanvasManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCanvasManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCanvasManager::Msg_PWebGLConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PWebGLChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PCanvasManagerChild::SendPWebGPUConstructor(PWebGPUChild* actor) -> PWebGPUChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PWebGPUChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PWebGPUChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PCanvasManager::Msg_PWebGPUConstructor(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PCanvasManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCanvasManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCanvasManager::Msg_PWebGPUConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PWebGPUChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PCanvasManagerChild::SendInitialize(const uint32_t& aManagerId) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCanvasManager::Msg_Initialize(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aManagerId);
    // Sentinel = 'aManagerId'
    ((&(writer__)))->WriteSentinel(347866058);


    if (mozilla::ipc::LoggingEnabledFor("PCanvasManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCanvasManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCanvasManager::Msg_Initialize", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PCanvasManagerChild::SendGetSnapshot(
        const uint32_t& aManagerId,
        const ActorId& aProtocolId,
        const mozilla::Maybe<RemoteTextureOwnerId>& ownerId,
        const mozilla::Maybe<RawId>& commandEncoderId,
        const mozilla::Maybe<RawId>& commandBufferId,
        FrontBufferSnapshotIpc* ret) -> bool
{
    UniquePtr<IPC::Message> msg__ = PCanvasManager::Msg_GetSnapshot(MSG_ROUTING_CONTROL);
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aManagerId);
    // Sentinel = 'aManagerId'
    ((&(writer__)))->WriteSentinel(347866058);
    IPC::WriteParam((&(writer__)), aProtocolId);
    // Sentinel = 'aProtocolId'
    ((&(writer__)))->WriteSentinel(444269665);
    IPC::WriteParam((&(writer__)), ownerId);
    // Sentinel = 'ownerId'
    ((&(writer__)))->WriteSentinel(199230169);
    IPC::WriteParam((&(writer__)), commandEncoderId);
    // Sentinel = 'commandEncoderId'
    ((&(writer__)))->WriteSentinel(913180237);
    IPC::WriteParam((&(writer__)), commandBufferId);
    // Sentinel = 'commandBufferId'
    ((&(writer__)))->WriteSentinel(806553063);

    UniquePtr<Message> reply__;

    if (mozilla::ipc::LoggingEnabledFor("PCanvasManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCanvasManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PCanvasManager::Msg_GetSnapshot", OTHER);

    bool sendok__ = false;
    {
        AUTO_PROFILER_MARKER("PCanvasManager::Msg_GetSnapshot", IPC);
        sendok__ = ChannelSend(std::move(msg__), (&(reply__)));
    }
    if ((!(sendok__))) {
        return false;
    }

    if (mozilla::ipc::LoggingEnabledFor("PCanvasManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PCanvasManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Received reply ",
            reply__->type(),
            mozilla::ipc::MessageDirection::eReceiving);
    }

    IPC::MessageReader reader__{
            (*(reply__)),
            this};

    auto maybe__ret__reply = IPC::ReadParam<FrontBufferSnapshotIpc>((&(reader__)));
    if (!maybe__ret__reply) {
        FatalError("Error deserializing 'FrontBufferSnapshotIpc'");
        return false;

    }
    auto& ret__reply = *maybe__ret__reply;
    // Sentinel = 'ret'
    if ((!(((&(reader__)))->ReadSentinel(43450700)))) {
        mozilla::ipc::SentinelReadError("Error deserializing 'FrontBufferSnapshotIpc'");
        return false;
    }
    (*(ret)) = std::move(ret__reply);
    reader__.EndRead();

    return true;
}

auto PCanvasManagerChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    default:
        FatalError("unreached");
        return;
    }
}

auto PCanvasManagerChild::OnMessageReceived(const Message& msg__) -> PCanvasManagerChild::Result
{
    IPC::Message::routeid_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            if (mozilla::ipc::LoggingEnabledFor("PCanvasManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PCanvasManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Ignored message for dead actor",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eSending);
            }
            return MsgProcessed;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__);
    }

    switch (msg__.type()) {
    case PCanvasManager::Reply_PCanvasConstructor__ID:
        {
            return MsgProcessed;
        }
    case PCanvasManager::Reply_PWebGLConstructor__ID:
        {
            return MsgProcessed;
        }
    case PCanvasManager::Reply_PWebGPUConstructor__ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    case SHMEM_CREATED_MESSAGE_TYPE:
        {
            if (!ShmemCreated(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    case SHMEM_DESTROYED_MESSAGE_TYPE:
        {
            if (!ShmemDestroyed(msg__)) {
                return MsgPayloadError;
            }
            return MsgProcessed;
        }
    }
}

auto PCanvasManagerChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PCanvasManagerChild::Result
{
    IPC::Message::routeid_t route__ = msg__.routing_id();
    if (MSG_ROUTING_CONTROL != route__) {
        IProtocol* routed__ = Lookup(route__);
        if (!routed__ || !routed__->GetLifecycleProxy()) {
            return MsgDropped;

        }

        RefPtr<mozilla::ipc::ActorLifecycleProxy> proxy__ =
            routed__->GetLifecycleProxy();
        return proxy__->Get()->OnMessageReceived(msg__, reply__);
    }

    return MsgNotKnown;
}



} // namespace gfx
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::gfx::PCanvasManagerChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PCanvasManager'
    (aWriter)->WriteSentinel(657720680);
}

auto ParamTraits<::mozilla::gfx::PCanvasManagerChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PCanvasManager actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PCanvasManager'
    if ((!((aReader)->ReadSentinel(657720680)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PCanvasManager actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PCanvasManagerMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PCanvasManager)");

        return {};
    }
    return static_cast<::mozilla::gfx::PCanvasManagerChild*>(actor);
}

} // namespace IPC
