/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM UDPMessageEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "UDPMessageEvent.h"
#include "UDPMessageEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/RootedDictionary.h"
#include "mozilla/dom/UDPMessageEvent.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(UDPMessageEvent)

NS_IMPL_ADDREF_INHERITED(UDPMessageEvent, Event)
NS_IMPL_RELEASE_INHERITED(UDPMessageEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(UDPMessageEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(UDPMessageEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRACE_JS_MEMBER_CALLBACK(mData)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(UDPMessageEvent, Event)
  tmp->mData.setUndefined();
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(UDPMessageEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

UDPMessageEvent::UDPMessageEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

UDPMessageEvent::~UDPMessageEvent()
{
  mozilla::DropJSObjects(this);
}

void
UDPMessageEvent::GetData(JS::MutableHandle<JS::Value> aRetVal) const
{
  JS::ExposeValueToActiveJS(mData);
  aRetVal.set(mData);
}

UDPMessageEvent*
UDPMessageEvent::AsUDPMessageEvent()
{
  return this;
}

JSObject*
UDPMessageEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return UDPMessageEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<UDPMessageEvent>
UDPMessageEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const UDPMessageEventInit& aEventInitDict)
{
  RefPtr<UDPMessageEvent> e = new UDPMessageEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mRemoteAddress = aEventInitDict.mRemoteAddress;
  e->mRemotePort = aEventInitDict.mRemotePort;
  e->mData = aEventInitDict.mData;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  mozilla::HoldJSObjects(e.get());
  return e.forget();
}

already_AddRefed<UDPMessageEvent>
UDPMessageEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const UDPMessageEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

void
UDPMessageEvent::GetRemoteAddress(nsString& aRetVal) const
{
  aRetVal = mRemoteAddress;
}

uint16_t
UDPMessageEvent::RemotePort() const
{
  return mRemotePort;
}

void
UDPMessageEvent::GetData(JSContext* cx, JS::MutableHandle<JS::Value> aRetVal) const
{
  GetData(aRetVal);
}


} // namespace mozilla::dom
