/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM StyleSheetApplicableStateChangeEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "StyleSheetApplicableStateChangeEvent.h"
#include "StyleSheetApplicableStateChangeEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/StyleSheet.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/StyleSheetApplicableStateChangeEvent.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(StyleSheetApplicableStateChangeEvent)

NS_IMPL_ADDREF_INHERITED(StyleSheetApplicableStateChangeEvent, Event)
NS_IMPL_RELEASE_INHERITED(StyleSheetApplicableStateChangeEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(StyleSheetApplicableStateChangeEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mStylesheet)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(StyleSheetApplicableStateChangeEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(StyleSheetApplicableStateChangeEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mStylesheet)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(StyleSheetApplicableStateChangeEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

StyleSheetApplicableStateChangeEvent::StyleSheetApplicableStateChangeEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

StyleSheetApplicableStateChangeEvent::~StyleSheetApplicableStateChangeEvent()
{
}

StyleSheetApplicableStateChangeEvent*
StyleSheetApplicableStateChangeEvent::AsStyleSheetApplicableStateChangeEvent()
{
  return this;
}

JSObject*
StyleSheetApplicableStateChangeEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return StyleSheetApplicableStateChangeEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<StyleSheetApplicableStateChangeEvent>
StyleSheetApplicableStateChangeEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const StyleSheetApplicableStateChangeEventInit& aEventInitDict)
{
  RefPtr<StyleSheetApplicableStateChangeEvent> e = new StyleSheetApplicableStateChangeEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mStylesheet = aEventInitDict.mStylesheet;
  e->mApplicable = aEventInitDict.mApplicable;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<StyleSheetApplicableStateChangeEvent>
StyleSheetApplicableStateChangeEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const StyleSheetApplicableStateChangeEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

StyleSheet*
StyleSheetApplicableStateChangeEvent::GetStylesheet() const
{
  return mStylesheet;
}

bool
StyleSheetApplicableStateChangeEvent::Applicable() const
{
  return mApplicable;
}


} // namespace mozilla::dom
