/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM SpeechRecognitionEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "SpeechRecognitionEvent.h"
#include "SpeechRecognitionEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Document.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/RootedDictionary.h"
#include "mozilla/dom/SpeechRecognitionEvent.h"
#include "mozilla/dom/SpeechRecognitionResultList.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(SpeechRecognitionEvent)

NS_IMPL_ADDREF_INHERITED(SpeechRecognitionEvent, Event)
NS_IMPL_RELEASE_INHERITED(SpeechRecognitionEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(SpeechRecognitionEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mResults)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mEmma)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(SpeechRecognitionEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRACE_JS_MEMBER_CALLBACK(mInterpretation)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(SpeechRecognitionEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mResults)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mEmma)
  tmp->mInterpretation.setUndefined();
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(SpeechRecognitionEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

SpeechRecognitionEvent::SpeechRecognitionEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

SpeechRecognitionEvent::~SpeechRecognitionEvent()
{
  mozilla::DropJSObjects(this);
}

void
SpeechRecognitionEvent::GetInterpretation(JS::MutableHandle<JS::Value> aRetVal) const
{
  JS::ExposeValueToActiveJS(mInterpretation);
  aRetVal.set(mInterpretation);
}

SpeechRecognitionEvent*
SpeechRecognitionEvent::AsSpeechRecognitionEvent()
{
  return this;
}

JSObject*
SpeechRecognitionEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return SpeechRecognitionEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<SpeechRecognitionEvent>
SpeechRecognitionEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const SpeechRecognitionEventInit& aEventInitDict)
{
  RefPtr<SpeechRecognitionEvent> e = new SpeechRecognitionEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mResultIndex = aEventInitDict.mResultIndex;
  e->mResults = aEventInitDict.mResults;
  e->mInterpretation = aEventInitDict.mInterpretation;
  e->mEmma = aEventInitDict.mEmma;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  mozilla::HoldJSObjects(e.get());
  return e.forget();
}

already_AddRefed<SpeechRecognitionEvent>
SpeechRecognitionEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const SpeechRecognitionEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

uint32_t
SpeechRecognitionEvent::ResultIndex() const
{
  return mResultIndex;
}

SpeechRecognitionResultList*
SpeechRecognitionEvent::GetResults() const
{
  return mResults;
}

void
SpeechRecognitionEvent::GetInterpretation(JSContext* cx, JS::MutableHandle<JS::Value> aRetVal) const
{
  GetInterpretation(aRetVal);
}

Document*
SpeechRecognitionEvent::GetEmma() const
{
  return mEmma;
}


} // namespace mozilla::dom
