/* THIS FILE IS AUTOGENERATED FROM PromiseDebugging.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "MainThreadUtils.h"
#include "PromiseDebuggingBinding.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "jsapi.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/PromiseDebugging.h"
#include "mozilla/dom/RootedDictionary.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsContentUtils.h"

namespace mozilla {

namespace dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<PromiseDebuggingState>::Values[3];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, PromiseDebuggingState aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<PromiseDebuggingState>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<PromiseDebuggingState>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<PromiseDebuggingState>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}



PromiseDebuggingStateHolder::PromiseDebuggingStateHolder()
{
  // Safe to pass a null context if we pass a null value
  Init();
}



bool
PromiseDebuggingStateHolder::InitIds(JSContext* cx, PromiseDebuggingStateHolderAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->value_id.init(cx, "value") ||
      !atomsCache->state_id.init(cx, "state") ||
      !atomsCache->reason_id.init(cx, "reason")) {
    return false;
  }
  return true;
}

bool
PromiseDebuggingStateHolder::Init(const char* sourceDescription, bool passedToJSImpl)
{
  {
    // scope for any temporaries our default value setting needs.
    mReason = JS::UndefinedValue();
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mState = PromiseDebuggingState::Pending;
  }
  mIsAnyMemberPresent = true;

  {
    // scope for any temporaries our default value setting needs.
    mValue = JS::UndefinedValue();
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
PromiseDebuggingStateHolder::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  PromiseDebuggingStateHolderAtoms* atomsCache = GetAtomCache<PromiseDebuggingStateHolderAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    JS::Value const & currentValue = mReason;
    JS::ExposeValueToActiveJS(currentValue);
    temp.set(currentValue);
    if (!MaybeWrapValue(cx, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->reason_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    PromiseDebuggingState const & currentValue = mState;
    if (!ToJSValue(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->state_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    JS::Value const & currentValue = mValue;
    JS::ExposeValueToActiveJS(currentValue);
    temp.set(currentValue);
    if (!MaybeWrapValue(cx, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->value_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
PromiseDebuggingStateHolder::TraceDictionary(JSTracer* trc)
{
  JS::TraceRoot(trc, &mReason, "PromiseDebuggingStateHolder.mReason");

  JS::TraceRoot(trc, &mValue, "PromiseDebuggingStateHolder.mValue");
}


namespace PromiseDebugging_Binding {

MOZ_CAN_RUN_SCRIPT static bool
getState(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "PromiseDebugging.getState");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PromiseDebugging", "getState", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "PromiseDebugging.getState", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  JS::Rooted<JSObject*> arg0(cx);
  if (args[0].isObject()) {
    arg0 = &args[0].toObject();
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  FastErrorResult rv;
  RootedDictionary<PromiseDebuggingStateHolder> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::PromiseDebugging::GetState(global, arg0, result, rv))>, "Should be returning void here");
  mozilla::dom::PromiseDebugging::GetState(global, arg0, result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "PromiseDebugging.getState"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!result.ToObjectInternal(cx, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getPromiseID(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "PromiseDebugging.getPromiseID");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PromiseDebugging", "getPromiseID", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "PromiseDebugging.getPromiseID", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  JS::Rooted<JSObject*> arg0(cx);
  if (args[0].isObject()) {
    arg0 = &args[0].toObject();
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  FastErrorResult rv;
  DOMString result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::PromiseDebugging::GetPromiseID(global, arg0, result, rv))>, "Should be returning void here");
  mozilla::dom::PromiseDebugging::GetPromiseID(global, arg0, result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "PromiseDebugging.getPromiseID"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!xpc::NonVoidStringToJsval(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getAllocationStack(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "PromiseDebugging.getAllocationStack");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PromiseDebugging", "getAllocationStack", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "PromiseDebugging.getAllocationStack", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  JS::Rooted<JSObject*> arg0(cx);
  if (args[0].isObject()) {
    arg0 = &args[0].toObject();
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  FastErrorResult rv;
  JS::Rooted<JSObject*> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::PromiseDebugging::GetAllocationStack(global, arg0, &result, rv))>, "Should be returning void here");
  mozilla::dom::PromiseDebugging::GetAllocationStack(global, arg0, &result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "PromiseDebugging.getAllocationStack"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
                JS::ExposeObjectToActiveJS(result);
              }
              args.rval().setObjectOrNull(result);
  if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getRejectionStack(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "PromiseDebugging.getRejectionStack");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PromiseDebugging", "getRejectionStack", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "PromiseDebugging.getRejectionStack", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  JS::Rooted<JSObject*> arg0(cx);
  if (args[0].isObject()) {
    arg0 = &args[0].toObject();
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  FastErrorResult rv;
  JS::Rooted<JSObject*> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::PromiseDebugging::GetRejectionStack(global, arg0, &result, rv))>, "Should be returning void here");
  mozilla::dom::PromiseDebugging::GetRejectionStack(global, arg0, &result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "PromiseDebugging.getRejectionStack"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
                JS::ExposeObjectToActiveJS(result);
              }
              args.rval().setObjectOrNull(result);
  if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
getFullfillmentStack(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "PromiseDebugging.getFullfillmentStack");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PromiseDebugging", "getFullfillmentStack", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "PromiseDebugging.getFullfillmentStack", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  JS::Rooted<JSObject*> arg0(cx);
  if (args[0].isObject()) {
    arg0 = &args[0].toObject();
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  FastErrorResult rv;
  JS::Rooted<JSObject*> result(cx);
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::PromiseDebugging::GetFullfillmentStack(global, arg0, &result, rv))>, "Should be returning void here");
  mozilla::dom::PromiseDebugging::GetFullfillmentStack(global, arg0, &result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "PromiseDebugging.getFullfillmentStack"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (result) {
                JS::ExposeObjectToActiveJS(result);
              }
              args.rval().setObjectOrNull(result);
  if (!MaybeWrapObjectOrNullValue(cx, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
addUncaughtRejectionObserver(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "PromiseDebugging.addUncaughtRejectionObserver");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PromiseDebugging", "addUncaughtRejectionObserver", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "PromiseDebugging.addUncaughtRejectionObserver", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  RootedCallback<OwningNonNull<binding_detail::FastUncaughtRejectionObserver>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastUncaughtRejectionObserver(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(mozilla::dom::PromiseDebugging::AddUncaughtRejectionObserver(global, MOZ_KnownLive(NonNullHelper(arg0))))>, "Should be returning void here");
  mozilla::dom::PromiseDebugging::AddUncaughtRejectionObserver(global, MOZ_KnownLive(NonNullHelper(arg0)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
removeUncaughtRejectionObserver(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "PromiseDebugging.removeUncaughtRejectionObserver");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "PromiseDebugging", "removeUncaughtRejectionObserver", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());

  if (!args.requireAtLeast(cx, "PromiseDebugging.removeUncaughtRejectionObserver", 1)) {
    return false;
  }
  GlobalObject global(cx, xpc::XrayAwareCalleeGlobal(obj));
  if (global.Failed()) {
    return false;
  }

  RootedCallback<OwningNonNull<binding_detail::FastUncaughtRejectionObserver>> arg0(cx);
  if (args[0].isObject()) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastUncaughtRejectionObserver(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  bool result(mozilla::dom::PromiseDebugging::RemoveUncaughtRejectionObserver(global, MOZ_KnownLive(NonNullHelper(arg0))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

MOZ_GLOBINIT static const JSFunctionSpec sStaticMethods_specs[] = {
  JS_FNSPEC("getState", getState, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getPromiseID", getPromiseID, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getAllocationStack", getAllocationStack, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getRejectionStack", getRejectionStack, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("getFullfillmentStack", getFullfillmentStack, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("addUncaughtRejectionObserver", addUncaughtRejectionObserver, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("removeUncaughtRejectionObserver", removeUncaughtRejectionObserver, nullptr, 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sStaticMethods[] = {
  { nullptr, &sStaticMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(7 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[7];
static PropertyInfo sNativeProperties_propertyInfos[7];

static const NativePropertiesN<1> sNativeProperties = {
  true,  0 /* sStaticMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  7,
  sNativeProperties_sortedPropertyIndices,
  {
    { sStaticMethods, &sNativeProperties_propertyInfos[0] }
  }
};
static_assert(7 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::_ID_Count,
  constructors::id::PromiseDebugging,
  &DefaultXrayExpandoObjectClass
};

static const DOMIfaceAndProtoJSClass sNamespaceObjectClass = {
  {
    "PromiseDebugging",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS,
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eNamespace,
  prototypes::id::_ID_Count,
  0,
  &sNativePropertyHooks,
  // This isn't strictly following the spec (see
  // https://console.spec.whatwg.org/#ref-for-dfn-namespace-object),
  // but should be ok for Xrays.
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return nsContentUtils::ThreadsafeIsSystemCaller(aCx);
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Rooted<JSObject*> constructorProto(aCx, JS::GetRealmObjectPrototype(aCx));
  if (!constructorProto) {
    return;
  }

  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::PromiseDebugging);
  dom::CreateNamespaceObject(aCx, aGlobal, constructorProto,
                             sNamespaceObjectClass,
                             interfaceCache,
                             sNativeProperties.Upcast(),
                             nullptr,
                             "PromiseDebugging",
                             ShouldExpose<PromiseDebugging_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal));
}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::PromiseDebugging,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace PromiseDebugging_Binding



bool
UncaughtRejectionObserver::OnLeftUncaught(JS::Handle<JSObject*> p, ErrorResult& aRv, const char* aExecutionReason, ExceptionHandling aExceptionHandling, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "UncaughtRejectionObserver.onLeftUncaught", aExceptionHandling, aRealm);
  if (aRv.Failed()) {
    return bool(0);
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return bool(0);
  }
  unsigned argc = 1;

  do {
    JS::ExposeObjectToActiveJS(p);
    argv[0].setObject(*p);
    if (!MaybeWrapObjectValue(cx, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return bool(0);
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  UncaughtRejectionObserverAtoms* atomsCache = GetAtomCache<UncaughtRejectionObserverAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->onLeftUncaught_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return bool(0);
  }
  bool rvalDecl;
  if (!ValueToPrimitive<bool, eDefault>(cx, rval, "Return value of UncaughtRejectionObserver.onLeftUncaught", &rvalDecl)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return bool(0);
  }
  return rvalDecl;
}

void
UncaughtRejectionObserver::OnConsumed(JS::Handle<JSObject*> p, ErrorResult& aRv, const char* aExecutionReason, ExceptionHandling aExceptionHandling, JS::Realm* aRealm)
{
  CallSetup s(this, aRv, "UncaughtRejectionObserver.onConsumed", aExceptionHandling, aRealm);
  if (aRv.Failed()) {
    return;
  }
  MOZ_ASSERT(s.GetContext());
  BindingCallContext& cx = s.GetCallContext();

  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {
    JS::ExposeObjectToActiveJS(p);
    argv[0].setObject(*p);
    if (!MaybeWrapObjectValue(cx, argv[0])) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx);
  UncaughtRejectionObserverAtoms* atomsCache = GetAtomCache<UncaughtRejectionObserverAtoms>(cx);
  if ((reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
       !InitIds(cx, atomsCache)) ||
      !GetCallableProperty(cx, atomsCache->onConsumed_id, &callable)) {
    aRv.Throw(NS_ERROR_UNEXPECTED);
    return;
  }
  JS::Rooted<JS::Value> thisValue(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, thisValue, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}

bool
UncaughtRejectionObserver::InitIds(JSContext* cx, UncaughtRejectionObserverAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->onConsumed_id.init(cx, "onConsumed") ||
      !atomsCache->onLeftUncaught_id.init(cx, "onLeftUncaught")) {
    return false;
  }
  return true;
}



} // namespace dom


} // namespace mozilla
