/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM PopStateEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "PopStateEvent.h"
#include "PopStateEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PopStateEvent.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/RootedDictionary.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(PopStateEvent)

NS_IMPL_ADDREF_INHERITED(PopStateEvent, Event)
NS_IMPL_RELEASE_INHERITED(PopStateEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(PopStateEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(PopStateEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRACE_JS_MEMBER_CALLBACK(mState)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(PopStateEvent, Event)
  tmp->mState.setUndefined();
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(PopStateEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

PopStateEvent::PopStateEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

PopStateEvent::~PopStateEvent()
{
  mozilla::DropJSObjects(this);
}

void
PopStateEvent::GetState(JS::MutableHandle<JS::Value> aRetVal) const
{
  JS::ExposeValueToActiveJS(mState);
  aRetVal.set(mState);
}

PopStateEvent*
PopStateEvent::AsPopStateEvent()
{
  return this;
}

JSObject*
PopStateEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return PopStateEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<PopStateEvent>
PopStateEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const PopStateEventInit& aEventInitDict)
{
  RefPtr<PopStateEvent> e = new PopStateEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mState = aEventInitDict.mState;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  mozilla::HoldJSObjects(e.get());
  return e.forget();
}

already_AddRefed<PopStateEvent>
PopStateEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const PopStateEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

void
PopStateEvent::GetState(JSContext* cx, JS::MutableHandle<JS::Value> aRetVal) const
{
  GetState(aRetVal);
}


} // namespace mozilla::dom
