/* THIS FILE IS AUTOGENERATED FROM LlamaRunner.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "LlamaRunner.h"
#include "LlamaRunnerBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "jsapi.h"
#include "mozilla/Atomics.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/Blob.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/LlamaRunner.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/Promise.h"
#include "mozilla/dom/ReadableStream.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"
#include "mozilla/dom/ToJSValue.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsThreadUtils.h"

namespace mozilla {

namespace dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<LlamaChatPhase>::Values[2];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, LlamaChatPhase aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<LlamaChatPhase>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<LlamaChatPhase>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<LlamaChatPhase>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<LlamaKVCacheDtype>::Values[7];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, LlamaKVCacheDtype aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<LlamaKVCacheDtype>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<LlamaKVCacheDtype>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<LlamaKVCacheDtype>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<LlamaSamplerType>::Values[14];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, LlamaSamplerType aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<LlamaSamplerType>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<LlamaSamplerType>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<LlamaSamplerType>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}



LlamaChatMessage::LlamaChatMessage()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
LlamaChatMessage::InitIds(JSContext* cx, LlamaChatMessageAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->role_id.init(cx, "role") ||
      !atomsCache->content_id.init(cx, "content")) {
    return false;
  }
  return true;
}

bool
LlamaChatMessage::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  LlamaChatMessageAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<LlamaChatMessageAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->content_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mContent)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'content' member of LlamaChatMessage");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->role_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mRole)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'role' member of LlamaChatMessage");
  }
  return true;
}

bool
LlamaChatMessage::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
LlamaChatMessage::TraceDictionary(JSTracer* trc)
{
}

LlamaChatMessage&
LlamaChatMessage::operator=(const LlamaChatMessage& aOther)
{
  DictionaryBase::operator=(aOther);
  mContent = aOther.mContent;
  mRole = aOther.mRole;
  return *this;
}



LlamaChatResponse::LlamaChatResponse()
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
LlamaChatResponse::InitIds(JSContext* cx, LlamaChatResponseAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->tokens_id.init(cx, "tokens") ||
      !atomsCache->piece_id.init(cx, "piece") ||
      !atomsCache->phase_id.init(cx, "phase") ||
      !atomsCache->isPhaseCompleted_id.init(cx, "isPhaseCompleted")) {
    return false;
  }
  return true;
}

bool
LlamaChatResponse::Init(const char* sourceDescription, bool passedToJSImpl)
{
  return true;
}

bool
LlamaChatResponse::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  LlamaChatResponseAtoms* atomsCache = GetAtomCache<LlamaChatResponseAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mIsPhaseCompleted;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->isPhaseCompleted_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    LlamaChatPhase const & currentValue = mPhase;
    if (!ToJSValue(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->phase_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    nsCString const & currentValue = mPiece;
    if (!NonVoidUTF8StringToJsval(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->piece_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<int32_t> const & currentValue = mTokens;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          tmp.setInt32(int32_t(currentValue[sequenceIdx0]));
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->tokens_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
LlamaChatResponse::TraceDictionary(JSTracer* trc)
{
}

LlamaChatResponse&
LlamaChatResponse::operator=(const LlamaChatResponse& aOther)
{
  DictionaryBase::operator=(aOther);
  mIsPhaseCompleted = aOther.mIsPhaseCompleted;
  mPhase = aOther.mPhase;
  mPiece = aOther.mPiece;
  mTokens = aOther.mTokens;
  return *this;
}



LlamaContextOptions::LlamaContextOptions()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
LlamaContextOptions::InitIds(JSContext* cx, LlamaContextOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->vCacheDtype_id.init(cx, "vCacheDtype") ||
      !atomsCache->swaFull_id.init(cx, "swaFull") ||
      !atomsCache->opOffload_id.init(cx, "opOffload") ||
      !atomsCache->offloadKqv_id.init(cx, "offloadKqv") ||
      !atomsCache->noPerf_id.init(cx, "noPerf") ||
      !atomsCache->nUbatch_id.init(cx, "nUbatch") ||
      !atomsCache->nThreadsBatch_id.init(cx, "nThreadsBatch") ||
      !atomsCache->nThreads_id.init(cx, "nThreads") ||
      !atomsCache->nSeqMax_id.init(cx, "nSeqMax") ||
      !atomsCache->nCtx_id.init(cx, "nCtx") ||
      !atomsCache->nBatch_id.init(cx, "nBatch") ||
      !atomsCache->kCacheDtype_id.init(cx, "kCacheDtype") ||
      !atomsCache->flashAttn_id.init(cx, "flashAttn")) {
    return false;
  }
  return true;
}

bool
LlamaContextOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  LlamaContextOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<LlamaContextOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->flashAttn_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'flashAttn' member of LlamaContextOptions", &mFlashAttn)) {
      return false;
    }
  } else {
    mFlashAttn = false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->kCacheDtype_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<LlamaKVCacheDtype>::Values,
                                                                         "LlamaKVCacheDtype", "'kCacheDtype' member of LlamaContextOptions",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      mKCacheDtype = static_cast<LlamaKVCacheDtype>(index);
    }
  } else {
    mKCacheDtype = LlamaKVCacheDtype::F16;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->nBatch_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'nBatch' member of LlamaContextOptions", &mNBatch)) {
      return false;
    }
  } else {
    mNBatch = 2048U;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->nCtx_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'nCtx' member of LlamaContextOptions", &mNCtx)) {
      return false;
    }
  } else {
    mNCtx = 2048U;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->nSeqMax_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'nSeqMax' member of LlamaContextOptions", &mNSeqMax)) {
      return false;
    }
  } else {
    mNSeqMax = 1U;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->nThreads_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'nThreads' member of LlamaContextOptions", &mNThreads)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'nThreads' member of LlamaContextOptions");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->nThreadsBatch_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'nThreadsBatch' member of LlamaContextOptions", &mNThreadsBatch)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'nThreadsBatch' member of LlamaContextOptions");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->nUbatch_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'nUbatch' member of LlamaContextOptions", &mNUbatch)) {
      return false;
    }
  } else {
    mNUbatch = 512U;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->noPerf_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'noPerf' member of LlamaContextOptions", &mNoPerf)) {
      return false;
    }
  } else {
    mNoPerf = false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->offloadKqv_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'offloadKqv' member of LlamaContextOptions", &mOffloadKqv)) {
      return false;
    }
  } else {
    mOffloadKqv = true;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->opOffload_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'opOffload' member of LlamaContextOptions", &mOpOffload)) {
      return false;
    }
  } else {
    mOpOffload = true;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->swaFull_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'swaFull' member of LlamaContextOptions", &mSwaFull)) {
      return false;
    }
  } else {
    mSwaFull = true;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->vCacheDtype_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<LlamaKVCacheDtype>::Values,
                                                                         "LlamaKVCacheDtype", "'vCacheDtype' member of LlamaContextOptions",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      mVCacheDtype = static_cast<LlamaKVCacheDtype>(index);
    }
  } else {
    mVCacheDtype = LlamaKVCacheDtype::F16;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
LlamaContextOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
LlamaContextOptions::TraceDictionary(JSTracer* trc)
{
}

LlamaContextOptions&
LlamaContextOptions::operator=(const LlamaContextOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mFlashAttn = aOther.mFlashAttn;
  mKCacheDtype = aOther.mKCacheDtype;
  mNBatch = aOther.mNBatch;
  mNCtx = aOther.mNCtx;
  mNSeqMax = aOther.mNSeqMax;
  mNThreads = aOther.mNThreads;
  mNThreadsBatch = aOther.mNThreadsBatch;
  mNUbatch = aOther.mNUbatch;
  mNoPerf = aOther.mNoPerf;
  mOffloadKqv = aOther.mOffloadKqv;
  mOpOffload = aOther.mOpOffload;
  mSwaFull = aOther.mSwaFull;
  mVCacheDtype = aOther.mVCacheDtype;
  return *this;
}



LlamaDeTokenizationOptions::LlamaDeTokenizationOptions()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
LlamaDeTokenizationOptions::InitIds(JSContext* cx, LlamaDeTokenizationOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->renderSpecialTokens_id.init(cx, "renderSpecialTokens") ||
      !atomsCache->maxCharsPerToken_id.init(cx, "maxCharsPerToken")) {
    return false;
  }
  return true;
}

bool
LlamaDeTokenizationOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  LlamaDeTokenizationOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<LlamaDeTokenizationOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->maxCharsPerToken_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'maxCharsPerToken' member of LlamaDeTokenizationOptions", &mMaxCharsPerToken)) {
      return false;
    }
  } else {
    mMaxCharsPerToken = 256;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->renderSpecialTokens_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'renderSpecialTokens' member of LlamaDeTokenizationOptions", &mRenderSpecialTokens)) {
      return false;
    }
  } else {
    mRenderSpecialTokens = true;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
LlamaDeTokenizationOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
LlamaDeTokenizationOptions::TraceDictionary(JSTracer* trc)
{
}

LlamaDeTokenizationOptions&
LlamaDeTokenizationOptions::operator=(const LlamaDeTokenizationOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mMaxCharsPerToken = aOther.mMaxCharsPerToken;
  mRenderSpecialTokens = aOther.mRenderSpecialTokens;
  return *this;
}



LlamaLogitBias::LlamaLogitBias()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
LlamaLogitBias::InitIds(JSContext* cx, LlamaLogitBiasAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->token_id.init(cx, "token") ||
      !atomsCache->bias_id.init(cx, "bias")) {
    return false;
  }
  return true;
}

bool
LlamaLogitBias::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  LlamaLogitBiasAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<LlamaLogitBiasAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->bias_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<float, eDefault>(cx, temp.ref(), "'bias' member of LlamaLogitBias", &mBias)) {
      return false;
    } else if (!std::isfinite(mBias)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'bias' member of LlamaLogitBias");
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'bias' member of LlamaLogitBias");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->token_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'token' member of LlamaLogitBias", &mToken)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'token' member of LlamaLogitBias");
  }
  return true;
}

bool
LlamaLogitBias::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
LlamaLogitBias::TraceDictionary(JSTracer* trc)
{
}

LlamaLogitBias&
LlamaLogitBias::operator=(const LlamaLogitBias& aOther)
{
  DictionaryBase::operator=(aOther);
  mBias = aOther.mBias;
  mToken = aOther.mToken;
  return *this;
}



LlamaTokenizationOptions::LlamaTokenizationOptions()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
LlamaTokenizationOptions::InitIds(JSContext* cx, LlamaTokenizationOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->parseSpecilControlTokens_id.init(cx, "parseSpecilControlTokens") ||
      !atomsCache->addBosAndEos_id.init(cx, "addBosAndEos")) {
    return false;
  }
  return true;
}

bool
LlamaTokenizationOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  LlamaTokenizationOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<LlamaTokenizationOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->addBosAndEos_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'addBosAndEos' member of LlamaTokenizationOptions", &mAddBosAndEos)) {
      return false;
    }
  } else {
    mAddBosAndEos = true;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->parseSpecilControlTokens_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'parseSpecilControlTokens' member of LlamaTokenizationOptions", &mParseSpecilControlTokens)) {
      return false;
    }
  } else {
    mParseSpecilControlTokens = true;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
LlamaTokenizationOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
LlamaTokenizationOptions::TraceDictionary(JSTracer* trc)
{
}

LlamaTokenizationOptions&
LlamaTokenizationOptions::operator=(const LlamaTokenizationOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mAddBosAndEos = aOther.mAddBosAndEos;
  mParseSpecilControlTokens = aOther.mParseSpecilControlTokens;
  return *this;
}



LlamaFormatChatOptions::LlamaFormatChatOptions()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
LlamaFormatChatOptions::InitIds(JSContext* cx, LlamaFormatChatOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->messages_id.init(cx, "messages") ||
      !atomsCache->addAssistant_id.init(cx, "addAssistant")) {
    return false;
  }
  return true;
}

bool
LlamaFormatChatOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  LlamaFormatChatOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<LlamaFormatChatOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->addAssistant_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'addAssistant' member of LlamaFormatChatOptions", &mAddAssistant)) {
      return false;
    }
  } else {
    mAddAssistant = true;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->messages_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'messages' member of LlamaFormatChatOptions", "sequence");
        return false;
      }
      Sequence<LlamaChatMessage> &arr = mMessages;
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        LlamaChatMessage* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        LlamaChatMessage& slot = *slotPtr;
        if (!slot.Init(cx, temp, "Element of 'messages' member of LlamaFormatChatOptions", passedToJSImpl)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'messages' member of LlamaFormatChatOptions", "sequence");
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'messages' member of LlamaFormatChatOptions");
  }
  return true;
}

bool
LlamaFormatChatOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
LlamaFormatChatOptions::TraceDictionary(JSTracer* trc)
{
}

LlamaFormatChatOptions&
LlamaFormatChatOptions::operator=(const LlamaFormatChatOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mAddAssistant = aOther.mAddAssistant;
  mMessages = aOther.mMessages;
  return *this;
}



LlamaModelOptions::LlamaModelOptions()
  : mContext(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
LlamaModelOptions::InitIds(JSContext* cx, LlamaModelOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->useMmap_id.init(cx, "useMmap") ||
      !atomsCache->useMlock_id.init(cx, "useMlock") ||
      !atomsCache->nGpuLayers_id.init(cx, "nGpuLayers") ||
      !atomsCache->context_id.init(cx, "context") ||
      !atomsCache->checkTensors_id.init(cx, "checkTensors")) {
    return false;
  }
  return true;
}

bool
LlamaModelOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  LlamaModelOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<LlamaModelOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->checkTensors_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'checkTensors' member of LlamaModelOptions", &mCheckTensors)) {
      return false;
    }
  } else {
    mCheckTensors = false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->context_id, temp.ptr())) {
      return false;
    }
  }
  if (!mContext.Init(cx, (!isNull && !temp->isUndefined()) ? temp.ref() : JS::NullHandleValue, "'context' member of LlamaModelOptions", passedToJSImpl)) {
    return false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->nGpuLayers_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'nGpuLayers' member of LlamaModelOptions", &mNGpuLayers)) {
      return false;
    }
  } else {
    mNGpuLayers = 0;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->useMlock_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'useMlock' member of LlamaModelOptions", &mUseMlock)) {
      return false;
    }
  } else {
    mUseMlock = false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->useMmap_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'useMmap' member of LlamaModelOptions", &mUseMmap)) {
      return false;
    }
  } else {
    mUseMmap = true;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
LlamaModelOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
LlamaModelOptions::TraceDictionary(JSTracer* trc)
{
}

LlamaModelOptions&
LlamaModelOptions::operator=(const LlamaModelOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mCheckTensors = aOther.mCheckTensors;
  mContext = aOther.mContext;
  mNGpuLayers = aOther.mNGpuLayers;
  mUseMlock = aOther.mUseMlock;
  mUseMmap = aOther.mUseMmap;
  return *this;
}



LlamaSamplerConfig::LlamaSamplerConfig()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
LlamaSamplerConfig::InitIds(JSContext* cx, LlamaSamplerConfigAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->xtcThreshold_id.init(cx, "xtcThreshold") ||
      !atomsCache->xtcProbability_id.init(cx, "xtcProbability") ||
      !atomsCache->type_id.init(cx, "type") ||
      !atomsCache->typP_id.init(cx, "typP") ||
      !atomsCache->topP_id.init(cx, "topP") ||
      !atomsCache->topNSigma_id.init(cx, "topNSigma") ||
      !atomsCache->topK_id.init(cx, "topK") ||
      !atomsCache->temp_id.init(cx, "temp") ||
      !atomsCache->seed_id.init(cx, "seed") ||
      !atomsCache->penaltyRepeat_id.init(cx, "penaltyRepeat") ||
      !atomsCache->penaltyPresent_id.init(cx, "penaltyPresent") ||
      !atomsCache->penaltyLastN_id.init(cx, "penaltyLastN") ||
      !atomsCache->penaltyFreq_id.init(cx, "penaltyFreq") ||
      !atomsCache->noPerf_id.init(cx, "noPerf") ||
      !atomsCache->mirostatTau_id.init(cx, "mirostatTau") ||
      !atomsCache->mirostatEta_id.init(cx, "mirostatEta") ||
      !atomsCache->mirostat_id.init(cx, "mirostat") ||
      !atomsCache->minP_id.init(cx, "minP") ||
      !atomsCache->minKeep_id.init(cx, "minKeep") ||
      !atomsCache->logitBias_id.init(cx, "logitBias") ||
      !atomsCache->dynatempRange_id.init(cx, "dynatempRange") ||
      !atomsCache->dynatempExponent_id.init(cx, "dynatempExponent") ||
      !atomsCache->dryPenaltyLastN_id.init(cx, "dryPenaltyLastN") ||
      !atomsCache->dryMultiplier_id.init(cx, "dryMultiplier") ||
      !atomsCache->dryBase_id.init(cx, "dryBase") ||
      !atomsCache->dryAllowedLength_id.init(cx, "dryAllowedLength")) {
    return false;
  }
  return true;
}

bool
LlamaSamplerConfig::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  LlamaSamplerConfigAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<LlamaSamplerConfigAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->dryAllowedLength_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'dryAllowedLength' member of LlamaSamplerConfig", &mDryAllowedLength)) {
      return false;
    }
  } else {
    mDryAllowedLength = 2;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->dryBase_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<float, eDefault>(cx, temp.ref(), "'dryBase' member of LlamaSamplerConfig", &mDryBase)) {
      return false;
    } else if (!std::isfinite(mDryBase)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'dryBase' member of LlamaSamplerConfig");
      return false;
    }
  } else {
    mDryBase = 1.75F;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->dryMultiplier_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<float, eDefault>(cx, temp.ref(), "'dryMultiplier' member of LlamaSamplerConfig", &mDryMultiplier)) {
      return false;
    } else if (!std::isfinite(mDryMultiplier)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'dryMultiplier' member of LlamaSamplerConfig");
      return false;
    }
  } else {
    mDryMultiplier = 0.0F;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->dryPenaltyLastN_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'dryPenaltyLastN' member of LlamaSamplerConfig", &mDryPenaltyLastN)) {
      return false;
    }
  } else {
    mDryPenaltyLastN = -1;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->dynatempExponent_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<float, eDefault>(cx, temp.ref(), "'dynatempExponent' member of LlamaSamplerConfig", &mDynatempExponent)) {
      return false;
    } else if (!std::isfinite(mDynatempExponent)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'dynatempExponent' member of LlamaSamplerConfig");
      return false;
    }
  } else {
    mDynatempExponent = 1.0F;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->dynatempRange_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<float, eDefault>(cx, temp.ref(), "'dynatempRange' member of LlamaSamplerConfig", &mDynatempRange)) {
      return false;
    } else if (!std::isfinite(mDynatempRange)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'dynatempRange' member of LlamaSamplerConfig");
      return false;
    }
  } else {
    mDynatempRange = 0.0F;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->logitBias_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'logitBias' member of LlamaSamplerConfig", "sequence");
        return false;
      }
      Sequence<LlamaLogitBias> &arr = mLogitBias;
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        LlamaLogitBias* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        LlamaLogitBias& slot = *slotPtr;
        if (!slot.Init(cx, temp, "Element of 'logitBias' member of LlamaSamplerConfig", passedToJSImpl)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'logitBias' member of LlamaSamplerConfig", "sequence");
      return false;
    }
  } else {
    /* mLogitBias array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->minKeep_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'minKeep' member of LlamaSamplerConfig", &mMinKeep)) {
      return false;
    }
  } else {
    mMinKeep = 0;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->minP_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<float, eDefault>(cx, temp.ref(), "'minP' member of LlamaSamplerConfig", &mMinP)) {
      return false;
    } else if (!std::isfinite(mMinP)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'minP' member of LlamaSamplerConfig");
      return false;
    }
  } else {
    mMinP = 0.05F;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->mirostat_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'mirostat' member of LlamaSamplerConfig", &mMirostat)) {
      return false;
    }
  } else {
    mMirostat = 0;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->mirostatEta_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<float, eDefault>(cx, temp.ref(), "'mirostatEta' member of LlamaSamplerConfig", &mMirostatEta)) {
      return false;
    } else if (!std::isfinite(mMirostatEta)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'mirostatEta' member of LlamaSamplerConfig");
      return false;
    }
  } else {
    mMirostatEta = 0.1F;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->mirostatTau_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<float, eDefault>(cx, temp.ref(), "'mirostatTau' member of LlamaSamplerConfig", &mMirostatTau)) {
      return false;
    } else if (!std::isfinite(mMirostatTau)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'mirostatTau' member of LlamaSamplerConfig");
      return false;
    }
  } else {
    mMirostatTau = 5.0F;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->noPerf_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'noPerf' member of LlamaSamplerConfig", &mNoPerf)) {
      return false;
    }
  } else {
    mNoPerf = false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->penaltyFreq_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<float, eDefault>(cx, temp.ref(), "'penaltyFreq' member of LlamaSamplerConfig", &mPenaltyFreq)) {
      return false;
    } else if (!std::isfinite(mPenaltyFreq)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'penaltyFreq' member of LlamaSamplerConfig");
      return false;
    }
  } else {
    mPenaltyFreq = 0.0F;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->penaltyLastN_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'penaltyLastN' member of LlamaSamplerConfig", &mPenaltyLastN)) {
      return false;
    }
  } else {
    mPenaltyLastN = 64;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->penaltyPresent_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<float, eDefault>(cx, temp.ref(), "'penaltyPresent' member of LlamaSamplerConfig", &mPenaltyPresent)) {
      return false;
    } else if (!std::isfinite(mPenaltyPresent)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'penaltyPresent' member of LlamaSamplerConfig");
      return false;
    }
  } else {
    mPenaltyPresent = 0.0F;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->penaltyRepeat_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<float, eDefault>(cx, temp.ref(), "'penaltyRepeat' member of LlamaSamplerConfig", &mPenaltyRepeat)) {
      return false;
    } else if (!std::isfinite(mPenaltyRepeat)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'penaltyRepeat' member of LlamaSamplerConfig");
      return false;
    }
  } else {
    mPenaltyRepeat = 1.0F;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->seed_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mSeed.Construct();
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'seed' member of LlamaSamplerConfig", &(mSeed.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->temp_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<float, eDefault>(cx, temp.ref(), "'temp' member of LlamaSamplerConfig", &mTemp)) {
      return false;
    } else if (!std::isfinite(mTemp)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'temp' member of LlamaSamplerConfig");
      return false;
    }
  } else {
    mTemp = 0.8F;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->topK_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'topK' member of LlamaSamplerConfig", &mTopK)) {
      return false;
    }
  } else {
    mTopK = 40;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->topNSigma_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<float, eDefault>(cx, temp.ref(), "'topNSigma' member of LlamaSamplerConfig", &mTopNSigma)) {
      return false;
    } else if (!std::isfinite(mTopNSigma)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'topNSigma' member of LlamaSamplerConfig");
      return false;
    }
  } else {
    mTopNSigma = -1.0F;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->topP_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<float, eDefault>(cx, temp.ref(), "'topP' member of LlamaSamplerConfig", &mTopP)) {
      return false;
    } else if (!std::isfinite(mTopP)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'topP' member of LlamaSamplerConfig");
      return false;
    }
  } else {
    mTopP = 0.95F;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->typP_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<float, eDefault>(cx, temp.ref(), "'typP' member of LlamaSamplerConfig", &mTypP)) {
      return false;
    } else if (!std::isfinite(mTypP)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'typP' member of LlamaSamplerConfig");
      return false;
    }
  } else {
    mTypP = 1.0F;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->type_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<LlamaSamplerType>::Values,
                                                                         "LlamaSamplerType", "'type' member of LlamaSamplerConfig",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      mType = static_cast<LlamaSamplerType>(index);
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'type' member of LlamaSamplerConfig");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->xtcProbability_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<float, eDefault>(cx, temp.ref(), "'xtcProbability' member of LlamaSamplerConfig", &mXtcProbability)) {
      return false;
    } else if (!std::isfinite(mXtcProbability)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'xtcProbability' member of LlamaSamplerConfig");
      return false;
    }
  } else {
    mXtcProbability = 0.0F;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->xtcThreshold_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<float, eDefault>(cx, temp.ref(), "'xtcThreshold' member of LlamaSamplerConfig", &mXtcThreshold)) {
      return false;
    } else if (!std::isfinite(mXtcThreshold)) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'xtcThreshold' member of LlamaSamplerConfig");
      return false;
    }
  } else {
    mXtcThreshold = 0.1F;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
LlamaSamplerConfig::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
LlamaSamplerConfig::TraceDictionary(JSTracer* trc)
{
}

LlamaSamplerConfig&
LlamaSamplerConfig::operator=(const LlamaSamplerConfig& aOther)
{
  DictionaryBase::operator=(aOther);
  mDryAllowedLength = aOther.mDryAllowedLength;
  mDryBase = aOther.mDryBase;
  mDryMultiplier = aOther.mDryMultiplier;
  mDryPenaltyLastN = aOther.mDryPenaltyLastN;
  mDynatempExponent = aOther.mDynatempExponent;
  mDynatempRange = aOther.mDynatempRange;
  mLogitBias = aOther.mLogitBias;
  mMinKeep = aOther.mMinKeep;
  mMinP = aOther.mMinP;
  mMirostat = aOther.mMirostat;
  mMirostatEta = aOther.mMirostatEta;
  mMirostatTau = aOther.mMirostatTau;
  mNoPerf = aOther.mNoPerf;
  mPenaltyFreq = aOther.mPenaltyFreq;
  mPenaltyLastN = aOther.mPenaltyLastN;
  mPenaltyPresent = aOther.mPenaltyPresent;
  mPenaltyRepeat = aOther.mPenaltyRepeat;
  mSeed.Reset();
  if (aOther.mSeed.WasPassed()) {
    mSeed.Construct(aOther.mSeed.Value());
  }
  mTemp = aOther.mTemp;
  mTopK = aOther.mTopK;
  mTopNSigma = aOther.mTopNSigma;
  mTopP = aOther.mTopP;
  mTypP = aOther.mTypP;
  mType = aOther.mType;
  mXtcProbability = aOther.mXtcProbability;
  mXtcThreshold = aOther.mXtcThreshold;
  return *this;
}



LlamaChatOptions::LlamaChatOptions()
  : mDeTokenizationOptions(FastDictionaryInitializer()),
    mTokenizationOptions(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
LlamaChatOptions::InitIds(JSContext* cx, LlamaChatOptionsAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->tokenizationOptions_id.init(cx, "tokenizationOptions") ||
      !atomsCache->stopTokens_id.init(cx, "stopTokens") ||
      !atomsCache->stopOnEndOfGenerationTokens_id.init(cx, "stopOnEndOfGenerationTokens") ||
      !atomsCache->samplers_id.init(cx, "samplers") ||
      !atomsCache->prompt_id.init(cx, "prompt") ||
      !atomsCache->minOutputBufferSize_id.init(cx, "minOutputBufferSize") ||
      !atomsCache->maxGeneratedTokens_id.init(cx, "maxGeneratedTokens") ||
      !atomsCache->deTokenizationOptions_id.init(cx, "deTokenizationOptions")) {
    return false;
  }
  return true;
}

bool
LlamaChatOptions::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  LlamaChatOptionsAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<LlamaChatOptionsAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->deTokenizationOptions_id, temp.ptr())) {
      return false;
    }
  }
  if (!mDeTokenizationOptions.Init(cx, (!isNull && !temp->isUndefined()) ? temp.ref() : JS::NullHandleValue, "'deTokenizationOptions' member of LlamaChatOptions", passedToJSImpl)) {
    return false;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->maxGeneratedTokens_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'maxGeneratedTokens' member of LlamaChatOptions", &mMaxGeneratedTokens)) {
      return false;
    }
  } else {
    mMaxGeneratedTokens = 512;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->minOutputBufferSize_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, temp.ref(), "'minOutputBufferSize' member of LlamaChatOptions", &mMinOutputBufferSize)) {
      return false;
    }
  } else {
    mMinOutputBufferSize = 1;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->prompt_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, mPrompt)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'prompt' member of LlamaChatOptions");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->samplers_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'samplers' member of LlamaChatOptions", "sequence");
        return false;
      }
      Sequence<LlamaSamplerConfig> &arr = mSamplers;
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        LlamaSamplerConfig* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        LlamaSamplerConfig& slot = *slotPtr;
        if (!slot.Init(cx, temp, "Element of 'samplers' member of LlamaChatOptions", passedToJSImpl)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'samplers' member of LlamaChatOptions", "sequence");
      return false;
    }
  } else {
    /* mSamplers array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->stopOnEndOfGenerationTokens_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'stopOnEndOfGenerationTokens' member of LlamaChatOptions", &mStopOnEndOfGenerationTokens)) {
      return false;
    }
  } else {
    mStopOnEndOfGenerationTokens = true;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->stopTokens_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'stopTokens' member of LlamaChatOptions", "sequence");
        return false;
      }
      Sequence<int32_t> &arr = mStopTokens;
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        int32_t* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        int32_t& slot = *slotPtr;
        if (!ValueToPrimitive<int32_t, eDefault>(cx, temp, "Element of 'stopTokens' member of LlamaChatOptions", &slot)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'stopTokens' member of LlamaChatOptions", "sequence");
      return false;
    }
  } else {
    /* mStopTokens array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->tokenizationOptions_id, temp.ptr())) {
      return false;
    }
  }
  if (!mTokenizationOptions.Init(cx, (!isNull && !temp->isUndefined()) ? temp.ref() : JS::NullHandleValue, "'tokenizationOptions' member of LlamaChatOptions", passedToJSImpl)) {
    return false;
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
LlamaChatOptions::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
LlamaChatOptions::TraceDictionary(JSTracer* trc)
{
}

LlamaChatOptions&
LlamaChatOptions::operator=(const LlamaChatOptions& aOther)
{
  DictionaryBase::operator=(aOther);
  mDeTokenizationOptions = aOther.mDeTokenizationOptions;
  mMaxGeneratedTokens = aOther.mMaxGeneratedTokens;
  mMinOutputBufferSize = aOther.mMinOutputBufferSize;
  mPrompt = aOther.mPrompt;
  mSamplers = aOther.mSamplers;
  mStopOnEndOfGenerationTokens = aOther.mStopOnEndOfGenerationTokens;
  mStopTokens = aOther.mStopTokens;
  mTokenizationOptions = aOther.mTokenizationOptions;
  return *this;
}


namespace LlamaRunner_Binding {

MOZ_CAN_RUN_SCRIPT static bool
initialize(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "LlamaRunner.initialize");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "LlamaRunner", "initialize", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::LlamaRunner*>(void_self);
  if (!args.requireAtLeast(cx, "LlamaRunner.initialize", 2)) {
    return false;
  }
  binding_detail::FastLlamaModelOptions arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  NonNull<mozilla::dom::Blob> arg1;
  if (args[1].isObject()) {
    {
      // Our JSContext should be in the right global to do unwrapping in.
      nsresult rv = UnwrapObject<prototypes::id::Blob, mozilla::dom::Blob>(args[1], arg1, cx);
      if (NS_FAILED(rv)) {
        cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 2", "Blob");
        return false;
      }
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->Initialize(Constify(arg0), MOZ_KnownLive(NonNullHelper(arg1)), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "LlamaRunner.initialize"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
initialize_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = initialize(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo initialize_methodinfo = {
  { (JSJitGetterOp)initialize_promiseWrapper },
  { prototypes::id::LlamaRunner },
  { PrototypeTraits<prototypes::id::LlamaRunner>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
formatChat(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "LlamaRunner.formatChat");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "LlamaRunner", "formatChat", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::LlamaRunner*>(void_self);
  if (!args.requireAtLeast(cx, "LlamaRunner.formatChat", 1)) {
    return false;
  }
  binding_detail::FastLlamaFormatChatOptions arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<Promise>(MOZ_KnownLive(self)->FormatChat(Constify(arg0), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "LlamaRunner.formatChat"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!ToJSValue(cx, result, args.rval())) {
    return false;
  }
  return true;
}

MOZ_CAN_RUN_SCRIPT static bool
formatChat_promiseWrapper(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  bool ok = formatChat(cx, obj, void_self, args);
  if (ok) {
    return true;
  }
  return ConvertExceptionToPromise(cx, args.rval());
}

static const JSJitInfo formatChat_methodinfo = {
  { (JSJitGetterOp)formatChat_promiseWrapper },
  { prototypes::id::LlamaRunner },
  { PrototypeTraits<prototypes::id::LlamaRunner>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
createGenerationStream(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "LlamaRunner.createGenerationStream");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "LlamaRunner", "createGenerationStream", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::LlamaRunner*>(void_self);
  if (!args.requireAtLeast(cx, "LlamaRunner.createGenerationStream", 1)) {
    return false;
  }
  binding_detail::FastLlamaChatOptions arg0;
  if (!arg0.Init(cx, args[0], "Argument 1", false)) {
    return false;
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::ReadableStream>(MOZ_KnownLive(self)->CreateGenerationStream(Constify(arg0), rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "LlamaRunner.createGenerationStream"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo createGenerationStream_methodinfo = {
  { (JSJitGetterOp)createGenerationStream },
  { prototypes::id::LlamaRunner },
  { PrototypeTraits<prototypes::id::LlamaRunner>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::LlamaRunner* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::LlamaRunner>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::LlamaRunner>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("initialize", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&initialize_methodinfo), 2, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("formatChat", (GenericMethod<NormalThisPolicy, ConvertExceptionsToPromises>), reinterpret_cast<const JSJitInfo*>(&formatChat_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FNSPEC("createGenerationStream", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&createGenerationStream_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(3 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[3];
static PropertyInfo sNativeProperties_propertyInfos[3];

static const NativePropertiesN<1> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  3,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] }
  }
};
static_assert(3 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::LlamaRunner,
  constructors::id::LlamaRunner,
  &DefaultXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx, unsigned argc, JS::Value* vp)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "LlamaRunner", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "LlamaRunner");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::LlamaRunner,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  GlobalObject global(cx, obj);
  if (global.Failed()) {
    return false;
  }

  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  Maybe<JSAutoRealm> ar;
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    obj = js::CheckedUnwrapStatic(obj);
    if (!obj) {
      return false;
    }
    ar.emplace(cx, obj);
    if (!JS_WrapObject(cx, &desiredProto)) {
      return false;
    }
  }
  FastErrorResult rv;
  auto result(StrongOrRawPtr<mozilla::dom::LlamaRunner>(mozilla::dom::LlamaRunner::Constructor(global, rv)));
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "LlamaRunner constructor"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::LlamaRunner>::Depth,
  prototypes::id::LlamaRunner,
  true,
  0,
  "LlamaRunner",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "LlamaRunnerPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::LlamaRunner,
  PrototypeTraits<prototypes::id::LlamaRunner>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  if (!NS_IsMainThread()) {
    const char* name = JS::GetClass(aObj)->name;
    if (strcmp(name, "DedicatedWorkerGlobalScope")) {
      return false;
    }
  }

  return LlamaRunner::InInferenceProcess(aCx, aObj);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "LlamaRunner",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::LlamaRunner>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::LlamaRunner, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::LlamaRunner>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::LlamaRunner>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::LlamaRunner>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::LlamaRunner>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::LlamaRunner* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::LlamaRunner>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::LlamaRunner*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::LlamaRunner> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::LlamaRunner);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::LlamaRunner);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "LlamaRunner",
                              ShouldExpose<LlamaRunner_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::LlamaRunner,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::LlamaRunner,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace LlamaRunner_Binding



} // namespace dom


} // namespace mozilla
