/* THIS FILE IS AUTOGENERATED FROM FileSystemDirectoryReader.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "FileSystemBinding.h"
#include "FileSystemDirectoryReaderBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/FileSystemDirectoryReader.h"
#include "mozilla/dom/FileSystemEntry.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/XrayExpandoClass.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


MOZ_CAN_RUN_SCRIPT void
FileSystemEntriesCallback::Call(BindingCallContext& cx, JS::Handle<JS::Value> aThisVal, const Sequence<OwningNonNull<FileSystemEntry>>& entries, ErrorResult& aRv)
{
  JS::Rooted<JS::Value> rval(cx);
  JS::RootedVector<JS::Value> argv(cx);
  if (!argv.resize(1)) {
    // That threw an exception on the JSContext, and our CallSetup will do
    // the right thing with that.
    return;
  }
  unsigned argc = 1;

  do {

    uint32_t length = entries.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      aRv.Throw(NS_ERROR_UNEXPECTED);
      return;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!GetOrCreateDOMReflector(cx, entries[sequenceIdx0], &tmp)) {
            MOZ_ASSERT(JS_IsExceptionPending(cx));
            aRv.Throw(NS_ERROR_UNEXPECTED);
            return;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          aRv.Throw(NS_ERROR_UNEXPECTED);
          return;
        }
      }
    }
    argv[0].setObject(*returnArray);
    break;
  } while (false);

  JS::Rooted<JS::Value> callable(cx, JS::ObjectValue(*mCallback));
  if (!JS::Call(cx, aThisVal, callable,
                JS::HandleValueArray::subarray(argv, 0, argc), &rval)) {
    aRv.NoteJSContextException(cx);
    return;
  }
}



namespace FileSystemDirectoryReader_Binding {

MOZ_CAN_RUN_SCRIPT static bool
readEntries(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "FileSystemDirectoryReader.readEntries");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "FileSystemDirectoryReader", "readEntries", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::FileSystemDirectoryReader*>(void_self);
  if (!args.requireAtLeast(cx, "FileSystemDirectoryReader.readEntries", 1)) {
    return false;
  }
  RootedCallback<OwningNonNull<binding_detail::FastFileSystemEntriesCallback>> arg0(cx);
  if (args[0].isObject()) {
    if (JS::IsCallable(&args[0].toObject())) {
    { // scope for tempRoot and tempGlobalRoot if needed
      arg0 = new binding_detail::FastFileSystemEntriesCallback(&args[0].toObject(), JS::CurrentGlobalOrNull(cx));
    }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 1");
      return false;
    }
  } else {
    cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 1");
    return false;
  }
  Optional<OwningNonNull<ErrorCallback>> arg1;
  if (args.hasDefined(1)) {
    arg1.Construct();
    if (args[1].isObject()) {
      if (JS::IsCallable(&args[1].toObject())) {
      { // scope for tempRoot and tempGlobalRoot if needed
        JS::Rooted<JSObject*> tempRoot(cx, &args[1].toObject());
        JS::Rooted<JSObject*> tempGlobalRoot(cx, JS::CurrentGlobalOrNull(cx));
        arg1.Value() = new ErrorCallback(cx, tempRoot, tempGlobalRoot, GetIncumbentGlobal());
      }
      } else {
        cx.ThrowErrorMessage<MSG_NOT_CALLABLE>("Argument 2");
        return false;
      }
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 2");
      return false;
    }
  }
  FastErrorResult rv;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->ReadEntries(MOZ_KnownLive(NonNullHelper(arg0)), MOZ_KnownLive(NonNullHelper(Constify(arg1))), rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->ReadEntries(MOZ_KnownLive(NonNullHelper(arg0)), MOZ_KnownLive(NonNullHelper(Constify(arg1))), rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "FileSystemDirectoryReader.readEntries"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo readEntries_methodinfo = {
  { (JSJitGetterOp)readEntries },
  { prototypes::id::FileSystemDirectoryReader },
  { PrototypeTraits<prototypes::id::FileSystemDirectoryReader>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::FileSystemDirectoryReader* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::FileSystemDirectoryReader>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::FileSystemDirectoryReader>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("readEntries", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&readEntries_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[1];
static PropertyInfo sNativeProperties_propertyInfos[1];

static const NativePropertiesN<1> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  1,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] }
  }
};
static_assert(1 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::FileSystemDirectoryReader,
  constructors::id::FileSystemDirectoryReader,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::FileSystemDirectoryReader>::Depth,
  prototypes::id::FileSystemDirectoryReader,
  true,
  0,
  "FileSystemDirectoryReader",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "FileSystemDirectoryReaderPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::FileSystemDirectoryReader,
  PrototypeTraits<prototypes::id::FileSystemDirectoryReader>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "FileSystemDirectoryReader",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::FileSystemDirectoryReader>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::FileSystemDirectoryReader, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::FileSystemDirectoryReader>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::FileSystemDirectoryReader>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::FileSystemDirectoryReader>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::FileSystemDirectoryReader>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::FileSystemDirectoryReader* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::FileSystemDirectoryReader>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::FileSystemDirectoryReader*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::FileSystemDirectoryReader> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::FileSystemDirectoryReader);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::FileSystemDirectoryReader);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "FileSystemDirectoryReader",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::FileSystemDirectoryReader,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::FileSystemDirectoryReader,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace FileSystemDirectoryReader_Binding



} // namespace mozilla::dom
