/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.annotate;

import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColors;

public enum AnnotationSource {
    LOCAL(false),
    MERGE(true);

    private final boolean myShowMerged;

    private AnnotationSource(boolean showMerged) {
        this.myShowMerged = showMerged;
    }

    public boolean showMerged() {
        return this.myShowMerged;
    }

    public ColorKey getColor(boolean lastCommit) {
        return lastCommit ? EditorColors.ANNOTATIONS_LAST_COMMIT_COLOR : EditorColors.ANNOTATIONS_COLOR;
    }

    public ColorKey getColor() {
        return this.getColor(false);
    }

    public static AnnotationSource getInstance(boolean showMerged) {
        return showMerged ? MERGE : LOCAL;
    }
}

