/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.text;

import com.intellij.diagnostic.PluginException;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TextContentImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulator;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextContentBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.grazie.text.TextContentBuilder");
    public static final TextContentBuilder FromPsi = new TextContentBuilder(e -> e instanceof OuterLanguageElement ? TextContent.ExclusionKind.unknown : null, Collections.emptySet(), Collections.emptySet());
    private final Function<PsiElement, @Nullable TextContent.ExclusionKind> classifier;
    private final Set<Character> indentChars;
    private final Set<Character> suffixChars;

    private TextContentBuilder(Function<PsiElement, @Nullable TextContent.ExclusionKind> classifier, Set<Character> indentChars, Set<Character> suffixChars) {
        this.classifier = classifier;
        this.indentChars = indentChars;
        this.suffixChars = suffixChars;
    }

    public TextContentBuilder withUnknown(Predicate<PsiElement> unknown) {
        return this.appendClassifier(unknown, TextContent.ExclusionKind.unknown);
    }

    public TextContentBuilder excluding(Predicate<PsiElement> excluded) {
        return this.appendClassifier(excluded, TextContent.ExclusionKind.exclude);
    }

    public TextContentBuilder withMarkup(Predicate<PsiElement> markup) {
        return this.appendClassifier(markup, TextContent.ExclusionKind.markup);
    }

    private TextContentBuilder appendClassifier(Predicate<PsiElement> predicate, TextContent.ExclusionKind kind) {
        return new TextContentBuilder(e -> {
            TextContent.ExclusionKind prev = this.classifier.apply((PsiElement)e);
            return prev != null ? prev : (predicate.test((PsiElement)e) ? kind : prev);
        }, this.indentChars, this.suffixChars);
    }

    public TextContentBuilder removingIndents(String indentChars) {
        HashSet<Character> set = new HashSet<Character>(this.indentChars);
        for (int i = 0; i < indentChars.length(); ++i) {
            set.add(Character.valueOf(indentChars.charAt(i)));
        }
        return new TextContentBuilder(this.classifier, set, this.suffixChars);
    }

    public TextContentBuilder removingLineSuffixes(String suffixChars) {
        HashSet<Character> set = new HashSet<Character>(this.suffixChars);
        for (int i = 0; i < suffixChars.length(); ++i) {
            set.add(Character.valueOf(suffixChars.charAt(i)));
        }
        return new TextContentBuilder(this.classifier, this.indentChars, set);
    }

    @Nullable
    public TextContent build(PsiElement root, TextContent.TextDomain domain) {
        ElementManipulator manipulator = ElementManipulators.getManipulator((PsiElement)root);
        int length = root.getTextLength();
        if (manipulator != null) {
            TextRange valueRange = manipulator.getRangeInElement(root);
            if (TextContentBuilder.isWrongRange(valueRange, length)) {
                PluginException.logPluginError((Logger)LOG, (String)("The manipulator returned an incorrect range " + String.valueOf(valueRange) + " for PSI " + String.valueOf(root.getClass()) + " of length " + length), null, (Class)manipulator.getClass());
                return null;
            }
            return this.build(root, domain, valueRange);
        }
        return this.build(root, domain, new TextRange(0, length));
    }

    @Nullable
    public TextContent build(final PsiElement root, final TextContent.TextDomain domain, TextRange valueRange) {
        CharSequence fileText;
        TextRange rootRange = root.getTextRange();
        if (TextContentBuilder.isWrongRange(valueRange, rootRange.getLength())) {
            LOG.error("The range " + String.valueOf(valueRange) + " is out of the PSI element, length " + rootRange.getLength());
            return null;
        }
        final int rootStart = rootRange.getStartOffset();
        final TextRange fileValueRange = valueRange.shiftRight(rootStart);
        if (TextContentBuilder.isWrongRange(fileValueRange, (fileText = root.getContainingFile().getViewProvider().getContents()).length())) {
            LOG.error("The range " + String.valueOf(fileValueRange) + " is out of the file, length " + fileText.length());
            return null;
        }
        TextContent content = new PsiRecursiveElementWalkingVisitor(){
            final List<TextContentImpl.TokenInfo> tokens = new ArrayList<TextContentImpl.TokenInfo>();
            int currentStart = fileValueRange.getStartOffset();

            public void visitElement(@NotNull PsiElement element) {
                TextRange range;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((range = element.getTextRange().intersection(fileValueRange)) == null) {
                    return;
                }
                @Nullable TextContent.ExclusionKind kind = TextContentBuilder.this.classifier.apply(element);
                if (kind == TextContent.ExclusionKind.exclude) {
                    this.exclusionStarted(range);
                } else if (kind != null) {
                    this.exclusionStarted(range);
                    TextContentImpl.TokenKind tokenKind = kind == TextContent.ExclusionKind.markup ? TextContentImpl.TokenKind.markup : TextContentImpl.TokenKind.unknown;
                    this.tokens.add(new TextContentImpl.PsiToken("", root, TextRange.from((int)range.getStartOffset(), (int)0).shiftLeft(rootStart), tokenKind));
                } else {
                    super.visitElement(element);
                }
            }

            private void exclusionStarted(TextRange range) {
                if (range.getStartOffset() != this.currentStart) {
                    TextRange tokenRange = new TextRange(this.currentStart, range.getStartOffset());
                    String tokenText = tokenRange.subSequence(fileText).toString();
                    this.tokens.add(new TextContentImpl.PsiToken(tokenText, root, tokenRange.shiftLeft(rootStart), TextContentImpl.TokenKind.text));
                }
                this.currentStart = range.getEndOffset();
            }

            @Nullable
            TextContent walkPsiTree() {
                root.accept((PsiElementVisitor)this);
                this.exclusionStarted(TextRange.from((int)fileValueRange.getEndOffset(), (int)0));
                return this.tokens.isEmpty() ? null : new TextContentImpl(domain, this.tokens);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/grazie/text/TextContentBuilder$1", "visitElement"));
            }
        }.walkPsiTree();
        return content == null ? null : content.removeIndents(this.indentChars).removeLineSuffixes(this.suffixChars).trimWhitespace();
    }

    private static boolean isWrongRange(TextRange valueRange, int maxLength) {
        return valueRange.getStartOffset() < 0 || valueRange.getEndOffset() > maxLength;
    }
}

