///////////////////////////////////////////////////////////////////////////////
// Name:        wx/qt/private/compat.h
// Purpose:     Helpers for dealing with various Qt versions
// Author:      Vadim Zeitlin
// Created:     2022-10-21
// Copyright:   (c) 2022 Vadim Zeitlin <vadim@wxwidgets.org>
// Licence:     wxWindows licence
///////////////////////////////////////////////////////////////////////////////

#ifndef _WX_QT_PRIVATE_COMPAT_H_
#define _WX_QT_PRIVATE_COMPAT_H_

#include <QtGui/QFontMetrics>

// Hide the difference in name of QFontMetrics::width() in various Qt versions.
inline int
wxQtGetWidthFromMetrics(const QFontMetrics& metrics, const QString& string)
{
#if (QT_VERSION >= QT_VERSION_CHECK(5, 11, 0))
    return metrics.horizontalAdvance( string );
#else
    return metrics.width( string );
#endif
}

// Hide the difference in getting Qt event position in various Qt versions.
template<typename T>
inline QPoint wxQtGetEventPosition(T* event)
{
#if QT_VERSION_MAJOR >= 6
    return event->position().toPoint();
#else
    return event->pos();
#endif
}

#endif // _WX_QT_PRIVATE_COMPAT_H_
