// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py
// RUN: %clang_cc1 -triple thumbv8.1m.main-none-none-eabi -target-feature +mve -mfloat-abi hard -O0 -disable-O0-optnone -emit-llvm -o - %s | opt -S -passes=mem2reg | FileCheck %s
// RUN: %clang_cc1 -triple thumbv8.1m.main-none-none-eabi -target-feature +mve -mfloat-abi hard -O0 -disable-O0-optnone -DPOLYMORPHIC -emit-llvm -o - %s | opt -S -passes=mem2reg | FileCheck %s

// REQUIRES: aarch64-registered-target || arm-registered-target

#include <arm_mve.h>

// CHECK-LABEL: @test_vshlq_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.vector.v16i8.v16i8(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 0, i32 0, i32 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vshlq_s8(int8x16_t a, int8x16_t b)
{
#ifdef POLYMORPHIC
    return vshlq(a, b);
#else /* POLYMORPHIC */
    return vshlq_s8(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.vector.v8i16.v8i16(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 0, i32 0, i32 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vshlq_s16(int16x8_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vshlq(a, b);
#else /* POLYMORPHIC */
    return vshlq_s16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.vector.v4i32.v4i32(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 0, i32 0, i32 0)
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
int32x4_t test_vshlq_s32(int32x4_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vshlq(a, b);
#else /* POLYMORPHIC */
    return vshlq_s32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.vector.v16i8.v16i8(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 0, i32 0, i32 1)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vshlq_u8(uint8x16_t a, int8x16_t b)
{
#ifdef POLYMORPHIC
    return vshlq(a, b);
#else /* POLYMORPHIC */
    return vshlq_u8(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.vector.v8i16.v8i16(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 0, i32 0, i32 1)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vshlq_u16(uint16x8_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vshlq(a, b);
#else /* POLYMORPHIC */
    return vshlq_u16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.vector.v4i32.v4i32(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 0, i32 0, i32 1)
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
uint32x4_t test_vshlq_u32(uint32x4_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vshlq(a, b);
#else /* POLYMORPHIC */
    return vshlq_u32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_r_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.scalar.v16i8(<16 x i8> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 0, i32 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vshlq_r_s8(int8x16_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vshlq_r(a, b);
#else /* POLYMORPHIC */
    return vshlq_r_s8(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_r_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.scalar.v8i16(<8 x i16> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 0, i32 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vshlq_r_s16(int16x8_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vshlq_r(a, b);
#else /* POLYMORPHIC */
    return vshlq_r_s16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_r_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.scalar.v4i32(<4 x i32> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 0, i32 0)
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
int32x4_t test_vshlq_r_s32(int32x4_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vshlq_r(a, b);
#else /* POLYMORPHIC */
    return vshlq_r_s32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_r_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.scalar.v16i8(<16 x i8> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 0, i32 1)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vshlq_r_u8(uint8x16_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vshlq_r(a, b);
#else /* POLYMORPHIC */
    return vshlq_r_u8(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_r_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.scalar.v8i16(<8 x i16> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 0, i32 1)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vshlq_r_u16(uint16x8_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vshlq_r(a, b);
#else /* POLYMORPHIC */
    return vshlq_r_u16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_r_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.scalar.v4i32(<4 x i32> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 0, i32 1)
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
uint32x4_t test_vshlq_r_u32(uint32x4_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vshlq_r(a, b);
#else /* POLYMORPHIC */
    return vshlq_r_u32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.vector.v16i8.v16i8(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 1, i32 0, i32 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vqshlq_s8(int8x16_t a, int8x16_t b)
{
#ifdef POLYMORPHIC
    return vqshlq(a, b);
#else /* POLYMORPHIC */
    return vqshlq_s8(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.vector.v8i16.v8i16(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 0, i32 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vqshlq_s16(int16x8_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vqshlq(a, b);
#else /* POLYMORPHIC */
    return vqshlq_s16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.vector.v4i32.v4i32(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 1, i32 0, i32 0)
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
int32x4_t test_vqshlq_s32(int32x4_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vqshlq(a, b);
#else /* POLYMORPHIC */
    return vqshlq_s32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.vector.v16i8.v16i8(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 1, i32 0, i32 1)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vqshlq_u8(uint8x16_t a, int8x16_t b)
{
#ifdef POLYMORPHIC
    return vqshlq(a, b);
#else /* POLYMORPHIC */
    return vqshlq_u8(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.vector.v8i16.v8i16(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 0, i32 1)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vqshlq_u16(uint16x8_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vqshlq(a, b);
#else /* POLYMORPHIC */
    return vqshlq_u16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.vector.v4i32.v4i32(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 1, i32 0, i32 1)
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
uint32x4_t test_vqshlq_u32(uint32x4_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vqshlq(a, b);
#else /* POLYMORPHIC */
    return vqshlq_u32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_r_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.scalar.v16i8(<16 x i8> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 0, i32 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vqshlq_r_s8(int8x16_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vqshlq_r(a, b);
#else /* POLYMORPHIC */
    return vqshlq_r_s8(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_r_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.scalar.v8i16(<8 x i16> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 0, i32 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vqshlq_r_s16(int16x8_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vqshlq_r(a, b);
#else /* POLYMORPHIC */
    return vqshlq_r_s16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_r_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.scalar.v4i32(<4 x i32> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 0, i32 0)
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
int32x4_t test_vqshlq_r_s32(int32x4_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vqshlq_r(a, b);
#else /* POLYMORPHIC */
    return vqshlq_r_s32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_r_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.scalar.v16i8(<16 x i8> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 0, i32 1)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vqshlq_r_u8(uint8x16_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vqshlq_r(a, b);
#else /* POLYMORPHIC */
    return vqshlq_r_u8(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_r_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.scalar.v8i16(<8 x i16> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 0, i32 1)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vqshlq_r_u16(uint16x8_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vqshlq_r(a, b);
#else /* POLYMORPHIC */
    return vqshlq_r_u16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_r_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.scalar.v4i32(<4 x i32> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 0, i32 1)
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
uint32x4_t test_vqshlq_r_u32(uint32x4_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vqshlq_r(a, b);
#else /* POLYMORPHIC */
    return vqshlq_r_u32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.vector.v16i8.v16i8(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 0, i32 1, i32 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vrshlq_s8(int8x16_t a, int8x16_t b)
{
#ifdef POLYMORPHIC
    return vrshlq(a, b);
#else /* POLYMORPHIC */
    return vrshlq_s8(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.vector.v8i16.v8i16(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 0, i32 1, i32 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vrshlq_s16(int16x8_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vrshlq(a, b);
#else /* POLYMORPHIC */
    return vrshlq_s16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.vector.v4i32.v4i32(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 0, i32 1, i32 0)
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
int32x4_t test_vrshlq_s32(int32x4_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vrshlq(a, b);
#else /* POLYMORPHIC */
    return vrshlq_s32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.vector.v16i8.v16i8(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 0, i32 1, i32 1)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vrshlq_u8(uint8x16_t a, int8x16_t b)
{
#ifdef POLYMORPHIC
    return vrshlq(a, b);
#else /* POLYMORPHIC */
    return vrshlq_u8(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.vector.v8i16.v8i16(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 0, i32 1, i32 1)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vrshlq_u16(uint16x8_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vrshlq(a, b);
#else /* POLYMORPHIC */
    return vrshlq_u16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.vector.v4i32.v4i32(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 0, i32 1, i32 1)
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
uint32x4_t test_vrshlq_u32(uint32x4_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vrshlq(a, b);
#else /* POLYMORPHIC */
    return vrshlq_u32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_n_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.scalar.v16i8(<16 x i8> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 1, i32 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vrshlq_n_s8(int8x16_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vrshlq(a, b);
#else /* POLYMORPHIC */
    return vrshlq_n_s8(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.scalar.v8i16(<8 x i16> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 1, i32 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vrshlq_n_s16(int16x8_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vrshlq(a, b);
#else /* POLYMORPHIC */
    return vrshlq_n_s16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.scalar.v4i32(<4 x i32> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 1, i32 0)
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
int32x4_t test_vrshlq_n_s32(int32x4_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vrshlq(a, b);
#else /* POLYMORPHIC */
    return vrshlq_n_s32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_n_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.scalar.v16i8(<16 x i8> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 1, i32 1)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vrshlq_n_u8(uint8x16_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vrshlq(a, b);
#else /* POLYMORPHIC */
    return vrshlq_n_u8(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.scalar.v8i16(<8 x i16> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 1, i32 1)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vrshlq_n_u16(uint16x8_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vrshlq(a, b);
#else /* POLYMORPHIC */
    return vrshlq_n_u16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.scalar.v4i32(<4 x i32> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 1, i32 1)
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
uint32x4_t test_vrshlq_n_u32(uint32x4_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vrshlq(a, b);
#else /* POLYMORPHIC */
    return vrshlq_n_u32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.vector.v16i8.v16i8(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 1, i32 1, i32 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vqrshlq_s8(int8x16_t a, int8x16_t b)
{
#ifdef POLYMORPHIC
    return vqrshlq(a, b);
#else /* POLYMORPHIC */
    return vqrshlq_s8(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.vector.v8i16.v8i16(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 1, i32 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vqrshlq_s16(int16x8_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vqrshlq(a, b);
#else /* POLYMORPHIC */
    return vqrshlq_s16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.vector.v4i32.v4i32(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 1, i32 1, i32 0)
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
int32x4_t test_vqrshlq_s32(int32x4_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vqrshlq(a, b);
#else /* POLYMORPHIC */
    return vqrshlq_s32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.vector.v16i8.v16i8(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 1, i32 1, i32 1)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vqrshlq_u8(uint8x16_t a, int8x16_t b)
{
#ifdef POLYMORPHIC
    return vqrshlq(a, b);
#else /* POLYMORPHIC */
    return vqrshlq_u8(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.vector.v8i16.v8i16(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 1, i32 1)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vqrshlq_u16(uint16x8_t a, int16x8_t b)
{
#ifdef POLYMORPHIC
    return vqrshlq(a, b);
#else /* POLYMORPHIC */
    return vqrshlq_u16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.vector.v4i32.v4i32(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 1, i32 1, i32 1)
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
uint32x4_t test_vqrshlq_u32(uint32x4_t a, int32x4_t b)
{
#ifdef POLYMORPHIC
    return vqrshlq(a, b);
#else /* POLYMORPHIC */
    return vqrshlq_u32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_n_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.scalar.v16i8(<16 x i8> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 1, i32 0)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
int8x16_t test_vqrshlq_n_s8(int8x16_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vqrshlq(a, b);
#else /* POLYMORPHIC */
    return vqrshlq_n_s8(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.scalar.v8i16(<8 x i16> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 1, i32 0)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
int16x8_t test_vqrshlq_n_s16(int16x8_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vqrshlq(a, b);
#else /* POLYMORPHIC */
    return vqrshlq_n_s16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.scalar.v4i32(<4 x i32> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 1, i32 0)
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
int32x4_t test_vqrshlq_n_s32(int32x4_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vqrshlq(a, b);
#else /* POLYMORPHIC */
    return vqrshlq_n_s32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_n_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.scalar.v16i8(<16 x i8> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 1, i32 1)
// CHECK-NEXT:    ret <16 x i8> [[TMP0]]
//
uint8x16_t test_vqrshlq_n_u8(uint8x16_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vqrshlq(a, b);
#else /* POLYMORPHIC */
    return vqrshlq_n_u8(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.scalar.v8i16(<8 x i16> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 1, i32 1)
// CHECK-NEXT:    ret <8 x i16> [[TMP0]]
//
uint16x8_t test_vqrshlq_n_u16(uint16x8_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vqrshlq(a, b);
#else /* POLYMORPHIC */
    return vqrshlq_n_u16(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.scalar.v4i32(<4 x i32> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 1, i32 1)
// CHECK-NEXT:    ret <4 x i32> [[TMP0]]
//
uint32x4_t test_vqrshlq_n_u32(uint32x4_t a, int32_t b)
{
#ifdef POLYMORPHIC
    return vqrshlq(a, b);
#else /* POLYMORPHIC */
    return vqrshlq_n_u32(a, b);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_m_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 0, i32 0, i32 0, <16 x i1> [[TMP1]], <16 x i8> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
int8x16_t test_vshlq_m_s8(int8x16_t inactive, int8x16_t a, int8x16_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vshlq_m_s8(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_m_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 0, i32 0, i32 0, <8 x i1> [[TMP1]], <8 x i16> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
int16x8_t test_vshlq_m_s16(int16x8_t inactive, int16x8_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vshlq_m_s16(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_m_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 0, i32 0, i32 0, <4 x i1> [[TMP1]], <4 x i32> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
int32x4_t test_vshlq_m_s32(int32x4_t inactive, int32x4_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vshlq_m_s32(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_m_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 0, i32 0, i32 1, <16 x i1> [[TMP1]], <16 x i8> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vshlq_m_u8(uint8x16_t inactive, uint8x16_t a, int8x16_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vshlq_m_u8(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_m_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 0, i32 0, i32 1, <8 x i1> [[TMP1]], <8 x i16> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vshlq_m_u16(uint16x8_t inactive, uint16x8_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vshlq_m_u16(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_m_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 0, i32 0, i32 1, <4 x i1> [[TMP1]], <4 x i32> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
uint32x4_t test_vshlq_m_u32(uint32x4_t inactive, uint32x4_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vshlq_m_u32(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_x_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 0, i32 0, i32 0, <16 x i1> [[TMP1]], <16 x i8> undef)
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
int8x16_t test_vshlq_x_s8(int8x16_t a, int8x16_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshlq_x(a, b, p);
#else /* POLYMORPHIC */
    return vshlq_x_s8(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_x_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 0, i32 0, i32 0, <8 x i1> [[TMP1]], <8 x i16> undef)
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
int16x8_t test_vshlq_x_s16(int16x8_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshlq_x(a, b, p);
#else /* POLYMORPHIC */
    return vshlq_x_s16(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_x_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 0, i32 0, i32 0, <4 x i1> [[TMP1]], <4 x i32> undef)
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
int32x4_t test_vshlq_x_s32(int32x4_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshlq_x(a, b, p);
#else /* POLYMORPHIC */
    return vshlq_x_s32(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_x_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 0, i32 0, i32 1, <16 x i1> [[TMP1]], <16 x i8> undef)
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vshlq_x_u8(uint8x16_t a, int8x16_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshlq_x(a, b, p);
#else /* POLYMORPHIC */
    return vshlq_x_u8(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_x_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 0, i32 0, i32 1, <8 x i1> [[TMP1]], <8 x i16> undef)
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vshlq_x_u16(uint16x8_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshlq_x(a, b, p);
#else /* POLYMORPHIC */
    return vshlq_x_u16(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_x_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 0, i32 0, i32 1, <4 x i1> [[TMP1]], <4 x i32> undef)
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
uint32x4_t test_vshlq_x_u32(uint32x4_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshlq_x(a, b, p);
#else /* POLYMORPHIC */
    return vshlq_x_u32(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_m_r_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.scalar.predicated.v16i8.v16i1(<16 x i8> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 0, i32 0, <16 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
int8x16_t test_vshlq_m_r_s8(int8x16_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshlq_m_r(a, b, p);
#else /* POLYMORPHIC */
    return vshlq_m_r_s8(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_m_r_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.scalar.predicated.v8i16.v8i1(<8 x i16> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 0, i32 0, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
int16x8_t test_vshlq_m_r_s16(int16x8_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshlq_m_r(a, b, p);
#else /* POLYMORPHIC */
    return vshlq_m_r_s16(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_m_r_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.scalar.predicated.v4i32.v4i1(<4 x i32> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 0, i32 0, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
int32x4_t test_vshlq_m_r_s32(int32x4_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshlq_m_r(a, b, p);
#else /* POLYMORPHIC */
    return vshlq_m_r_s32(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_m_r_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.scalar.predicated.v16i8.v16i1(<16 x i8> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 0, i32 1, <16 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vshlq_m_r_u8(uint8x16_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshlq_m_r(a, b, p);
#else /* POLYMORPHIC */
    return vshlq_m_r_u8(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_m_r_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.scalar.predicated.v8i16.v8i1(<8 x i16> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 0, i32 1, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vshlq_m_r_u16(uint16x8_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshlq_m_r(a, b, p);
#else /* POLYMORPHIC */
    return vshlq_m_r_u16(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vshlq_m_r_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.scalar.predicated.v4i32.v4i1(<4 x i32> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 0, i32 1, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
uint32x4_t test_vshlq_m_r_u32(uint32x4_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vshlq_m_r(a, b, p);
#else /* POLYMORPHIC */
    return vshlq_m_r_u32(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_m_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 1, i32 0, i32 0, <16 x i1> [[TMP1]], <16 x i8> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
int8x16_t test_vqshlq_m_s8(int8x16_t inactive, int8x16_t a, int8x16_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vqshlq_m_s8(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_m_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 0, i32 0, <8 x i1> [[TMP1]], <8 x i16> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
int16x8_t test_vqshlq_m_s16(int16x8_t inactive, int16x8_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vqshlq_m_s16(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_m_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 1, i32 0, i32 0, <4 x i1> [[TMP1]], <4 x i32> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
int32x4_t test_vqshlq_m_s32(int32x4_t inactive, int32x4_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vqshlq_m_s32(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_m_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 1, i32 0, i32 1, <16 x i1> [[TMP1]], <16 x i8> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vqshlq_m_u8(uint8x16_t inactive, uint8x16_t a, int8x16_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vqshlq_m_u8(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_m_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 0, i32 1, <8 x i1> [[TMP1]], <8 x i16> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vqshlq_m_u16(uint16x8_t inactive, uint16x8_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vqshlq_m_u16(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_m_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 1, i32 0, i32 1, <4 x i1> [[TMP1]], <4 x i32> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
uint32x4_t test_vqshlq_m_u32(uint32x4_t inactive, uint32x4_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vqshlq_m_u32(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_m_r_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.scalar.predicated.v16i8.v16i1(<16 x i8> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 0, i32 0, <16 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
int8x16_t test_vqshlq_m_r_s8(int8x16_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshlq_m_r(a, b, p);
#else /* POLYMORPHIC */
    return vqshlq_m_r_s8(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_m_r_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.scalar.predicated.v8i16.v8i1(<8 x i16> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 0, i32 0, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
int16x8_t test_vqshlq_m_r_s16(int16x8_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshlq_m_r(a, b, p);
#else /* POLYMORPHIC */
    return vqshlq_m_r_s16(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_m_r_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.scalar.predicated.v4i32.v4i1(<4 x i32> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 0, i32 0, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
int32x4_t test_vqshlq_m_r_s32(int32x4_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshlq_m_r(a, b, p);
#else /* POLYMORPHIC */
    return vqshlq_m_r_s32(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_m_r_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.scalar.predicated.v16i8.v16i1(<16 x i8> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 0, i32 1, <16 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vqshlq_m_r_u8(uint8x16_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshlq_m_r(a, b, p);
#else /* POLYMORPHIC */
    return vqshlq_m_r_u8(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_m_r_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.scalar.predicated.v8i16.v8i1(<8 x i16> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 0, i32 1, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vqshlq_m_r_u16(uint16x8_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshlq_m_r(a, b, p);
#else /* POLYMORPHIC */
    return vqshlq_m_r_u16(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqshlq_m_r_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.scalar.predicated.v4i32.v4i1(<4 x i32> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 0, i32 1, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
uint32x4_t test_vqshlq_m_r_u32(uint32x4_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqshlq_m_r(a, b, p);
#else /* POLYMORPHIC */
    return vqshlq_m_r_u32(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_m_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 0, i32 1, i32 0, <16 x i1> [[TMP1]], <16 x i8> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
int8x16_t test_vrshlq_m_s8(int8x16_t inactive, int8x16_t a, int8x16_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vrshlq_m_s8(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_m_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 0, i32 1, i32 0, <8 x i1> [[TMP1]], <8 x i16> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
int16x8_t test_vrshlq_m_s16(int16x8_t inactive, int16x8_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vrshlq_m_s16(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_m_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 0, i32 1, i32 0, <4 x i1> [[TMP1]], <4 x i32> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
int32x4_t test_vrshlq_m_s32(int32x4_t inactive, int32x4_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vrshlq_m_s32(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_m_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 0, i32 1, i32 1, <16 x i1> [[TMP1]], <16 x i8> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vrshlq_m_u8(uint8x16_t inactive, uint8x16_t a, int8x16_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vrshlq_m_u8(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_m_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 0, i32 1, i32 1, <8 x i1> [[TMP1]], <8 x i16> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vrshlq_m_u16(uint16x8_t inactive, uint16x8_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vrshlq_m_u16(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_m_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 0, i32 1, i32 1, <4 x i1> [[TMP1]], <4 x i32> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
uint32x4_t test_vrshlq_m_u32(uint32x4_t inactive, uint32x4_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vrshlq_m_u32(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_x_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 0, i32 1, i32 0, <16 x i1> [[TMP1]], <16 x i8> undef)
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
int8x16_t test_vrshlq_x_s8(int8x16_t a, int8x16_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshlq_x(a, b, p);
#else /* POLYMORPHIC */
    return vrshlq_x_s8(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_x_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 0, i32 1, i32 0, <8 x i1> [[TMP1]], <8 x i16> undef)
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
int16x8_t test_vrshlq_x_s16(int16x8_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshlq_x(a, b, p);
#else /* POLYMORPHIC */
    return vrshlq_x_s16(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_x_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 0, i32 1, i32 0, <4 x i1> [[TMP1]], <4 x i32> undef)
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
int32x4_t test_vrshlq_x_s32(int32x4_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshlq_x(a, b, p);
#else /* POLYMORPHIC */
    return vrshlq_x_s32(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_x_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 0, i32 1, i32 1, <16 x i1> [[TMP1]], <16 x i8> undef)
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vrshlq_x_u8(uint8x16_t a, int8x16_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshlq_x(a, b, p);
#else /* POLYMORPHIC */
    return vrshlq_x_u8(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_x_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 0, i32 1, i32 1, <8 x i1> [[TMP1]], <8 x i16> undef)
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vrshlq_x_u16(uint16x8_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshlq_x(a, b, p);
#else /* POLYMORPHIC */
    return vrshlq_x_u16(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_x_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 0, i32 1, i32 1, <4 x i1> [[TMP1]], <4 x i32> undef)
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
uint32x4_t test_vrshlq_x_u32(uint32x4_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshlq_x(a, b, p);
#else /* POLYMORPHIC */
    return vrshlq_x_u32(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_m_n_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.scalar.predicated.v16i8.v16i1(<16 x i8> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 1, i32 0, <16 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
int8x16_t test_vrshlq_m_n_s8(int8x16_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshlq_m_n(a, b, p);
#else /* POLYMORPHIC */
    return vrshlq_m_n_s8(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_m_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.scalar.predicated.v8i16.v8i1(<8 x i16> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 1, i32 0, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
int16x8_t test_vrshlq_m_n_s16(int16x8_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshlq_m_n(a, b, p);
#else /* POLYMORPHIC */
    return vrshlq_m_n_s16(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_m_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.scalar.predicated.v4i32.v4i1(<4 x i32> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 1, i32 0, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
int32x4_t test_vrshlq_m_n_s32(int32x4_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshlq_m_n(a, b, p);
#else /* POLYMORPHIC */
    return vrshlq_m_n_s32(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_m_n_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.scalar.predicated.v16i8.v16i1(<16 x i8> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 1, i32 1, <16 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vrshlq_m_n_u8(uint8x16_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshlq_m_n(a, b, p);
#else /* POLYMORPHIC */
    return vrshlq_m_n_u8(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_m_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.scalar.predicated.v8i16.v8i1(<8 x i16> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 1, i32 1, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vrshlq_m_n_u16(uint16x8_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshlq_m_n(a, b, p);
#else /* POLYMORPHIC */
    return vrshlq_m_n_u16(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vrshlq_m_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.scalar.predicated.v4i32.v4i1(<4 x i32> [[A:%.*]], i32 [[B:%.*]], i32 0, i32 1, i32 1, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
uint32x4_t test_vrshlq_m_n_u32(uint32x4_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vrshlq_m_n(a, b, p);
#else /* POLYMORPHIC */
    return vrshlq_m_n_u32(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_m_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 1, i32 1, i32 0, <16 x i1> [[TMP1]], <16 x i8> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
int8x16_t test_vqrshlq_m_s8(int8x16_t inactive, int8x16_t a, int8x16_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vqrshlq_m_s8(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_m_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 1, i32 0, <8 x i1> [[TMP1]], <8 x i16> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
int16x8_t test_vqrshlq_m_s16(int16x8_t inactive, int16x8_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vqrshlq_m_s16(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_m_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 1, i32 1, i32 0, <4 x i1> [[TMP1]], <4 x i32> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
int32x4_t test_vqrshlq_m_s32(int32x4_t inactive, int32x4_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vqrshlq_m_s32(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_m_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.vector.predicated.v16i8.v16i8.v16i1(<16 x i8> [[A:%.*]], <16 x i8> [[B:%.*]], i32 1, i32 1, i32 1, <16 x i1> [[TMP1]], <16 x i8> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vqrshlq_m_u8(uint8x16_t inactive, uint8x16_t a, int8x16_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vqrshlq_m_u8(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_m_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.vector.predicated.v8i16.v8i16.v8i1(<8 x i16> [[A:%.*]], <8 x i16> [[B:%.*]], i32 1, i32 1, i32 1, <8 x i1> [[TMP1]], <8 x i16> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vqrshlq_m_u16(uint16x8_t inactive, uint16x8_t a, int16x8_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vqrshlq_m_u16(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_m_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.vector.predicated.v4i32.v4i32.v4i1(<4 x i32> [[A:%.*]], <4 x i32> [[B:%.*]], i32 1, i32 1, i32 1, <4 x i1> [[TMP1]], <4 x i32> [[INACTIVE:%.*]])
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
uint32x4_t test_vqrshlq_m_u32(uint32x4_t inactive, uint32x4_t a, int32x4_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshlq_m(inactive, a, b, p);
#else /* POLYMORPHIC */
    return vqrshlq_m_u32(inactive, a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_m_n_s8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.scalar.predicated.v16i8.v16i1(<16 x i8> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 1, i32 0, <16 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
int8x16_t test_vqrshlq_m_n_s8(int8x16_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshlq_m_n(a, b, p);
#else /* POLYMORPHIC */
    return vqrshlq_m_n_s8(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_m_n_s16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.scalar.predicated.v8i16.v8i1(<8 x i16> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 1, i32 0, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
int16x8_t test_vqrshlq_m_n_s16(int16x8_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshlq_m_n(a, b, p);
#else /* POLYMORPHIC */
    return vqrshlq_m_n_s16(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_m_n_s32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.scalar.predicated.v4i32.v4i1(<4 x i32> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 1, i32 0, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
int32x4_t test_vqrshlq_m_n_s32(int32x4_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshlq_m_n(a, b, p);
#else /* POLYMORPHIC */
    return vqrshlq_m_n_s32(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_m_n_u8(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <16 x i1> @llvm.arm.mve.pred.i2v.v16i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <16 x i8> @llvm.arm.mve.vshl.scalar.predicated.v16i8.v16i1(<16 x i8> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 1, i32 1, <16 x i1> [[TMP1]])
// CHECK-NEXT:    ret <16 x i8> [[TMP2]]
//
uint8x16_t test_vqrshlq_m_n_u8(uint8x16_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshlq_m_n(a, b, p);
#else /* POLYMORPHIC */
    return vqrshlq_m_n_u8(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_m_n_u16(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <8 x i1> @llvm.arm.mve.pred.i2v.v8i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <8 x i16> @llvm.arm.mve.vshl.scalar.predicated.v8i16.v8i1(<8 x i16> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 1, i32 1, <8 x i1> [[TMP1]])
// CHECK-NEXT:    ret <8 x i16> [[TMP2]]
//
uint16x8_t test_vqrshlq_m_n_u16(uint16x8_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshlq_m_n(a, b, p);
#else /* POLYMORPHIC */
    return vqrshlq_m_n_u16(a, b, p);
#endif /* POLYMORPHIC */
}

// CHECK-LABEL: @test_vqrshlq_m_n_u32(
// CHECK-NEXT:  entry:
// CHECK-NEXT:    [[TMP0:%.*]] = zext i16 [[P:%.*]] to i32
// CHECK-NEXT:    [[TMP1:%.*]] = call <4 x i1> @llvm.arm.mve.pred.i2v.v4i1(i32 [[TMP0]])
// CHECK-NEXT:    [[TMP2:%.*]] = call <4 x i32> @llvm.arm.mve.vshl.scalar.predicated.v4i32.v4i1(<4 x i32> [[A:%.*]], i32 [[B:%.*]], i32 1, i32 1, i32 1, <4 x i1> [[TMP1]])
// CHECK-NEXT:    ret <4 x i32> [[TMP2]]
//
uint32x4_t test_vqrshlq_m_n_u32(uint32x4_t a, int32_t b, mve_pred16_t p)
{
#ifdef POLYMORPHIC
    return vqrshlq_m_n(a, b, p);
#else /* POLYMORPHIC */
    return vqrshlq_m_n_u32(a, b, p);
#endif /* POLYMORPHIC */
}

