// RUN: rm -rf %t && mkdir -p %t
// RUN: clang-doc --format=mustache --output=%t --executor=standalone %s 
// RUN: FileCheck %s < %t/html/MyNamespace/index.html
// RUN: FileCheck %s < %t/html/GlobalNamespace/index.html --check-prefix=CHECK-GLOBAL

namespace MyNamespace {
  class Foo;
}

// CHECK:       <ul class="class-container">
// CHECK-NEXT:    <li id="{{[0-9A-F]*}}" style="max-height: 40px;">
// CHECK-NEXT:        <a href="_ZTVN11MyNamespace3FooE.html">
// CHECK-NEXT:            <pre><code class="language-cpp code-clang-doc">class Foo</code></pre>
// CHECK-NEXT:        </a>
// CHECK-NEXT:    </li>
// CHECK-NEXT: </ul>

// COM: Check that the empty global namespace doesn't contain tag mismatches.
// CHECK-GLOBAL:             <main>
// CHECK-GLOBAL-NEXT:            <div class="container">
// CHECK-GLOBAL-NEXT:                <div class="sidebar">
// CHECK-GLOBAL-NEXT:                    <h2> </h2>
// CHECK-GLOBAL-NEXT:                    <ul>
// CHECK-GLOBAL-NEXT:                    </ul>
// CHECK-GLOBAL-NEXT:                </div>
// CHECK-GLOBAL-NEXT:                <div class="resizer" id="resizer"></div>
// CHECK-GLOBAL-NEXT:                <div class="content">
// CHECK-GLOBAL-EMPTY:
// CHECK-GLOBAL-NEXT:                </div>
// CHECK-GLOBAL-NEXT:            </div>
// CHECK-GLOBAL-NEXT:        </main>
