select c.customer_priority as g0, t1rp1 as g1, t.taxRecord_bracket as g2, sum(oi.orderItem_weight) as p0, max(ca.category_demandScore) as p1, max(ca.category_auditDate) as p2, cast(avg(ca.category_valuation) as int) as p3, sum(t1rp2) as p4, sum( case when p.product_inventoryLastOrderedOn - ca.category_auditDate > 300 then 1 when p.product_inventoryLastOrderedOn - ca.category_auditDate > 150 then 10 when p.product_inventoryLastOrderedOn - ca.category_auditDate > 0 then 100 else 1000 end + (c.customer_priority * a.address_zone) ) as p5 from OrderItemView oi left outer join OrderView o on oi.orderItem_orderId = o.order_id left outer join ProductView p on oi.orderItem_productId = p.product_id left outer join CreditCardView cc on o.order_creditCardNumber = cc.creditCard_number left outer join CustomerView c on o.order_customerId = c.customer_id left outer join AddressView a on c.customer_id = a.address_customerId left outer join TaxRecordView t on a.address_id = t.taxRecord_addressId left outer join CategoryView ca on p.product_categoryName = ca.category_name left outer join ( select min(cc.creditCard_expirationDate) as t1rp1, sum(cc.creditCard_lastChargeAmount) as t1rp2, c.customer_id as t1pk from CustomerView c left outer join CreditCardView cc on c.customer_id = cc.creditCard_customerId group by c.customer_id ) t1 on c.customer_id = t1pk where cc.creditCard_lastChargeAmount > 90.0 and p.product_price > 34.0 group by c.customer_priority, t1rp1, t.taxRecord_bracket order by p1, p3, g2 limit 500;