# Summary

[Introduction](readme.md)

[Getting Started with Rust](rust-getting-started/readme.md)

- [Choosing between the windows and windows-sys crates](rust-getting-started/windows-or-windows-sys.md)
- [How are these crates built?](rust-getting-started/how-are-crates-built.md)
- [How do I find a particular API?](rust-getting-started/how-to-find-api.md)
- [What APIs are included?](rust-getting-started/what-apis-are-included.md)
- [Where's my favorite macro from the Windows SDK?](rust-getting-started/where-are-the-macros.md)
- [Calling your first API with the windows crate](rust-getting-started/calling-your-first-windows-api.md)
- [Calling your first API with the windows-sys crate](rust-getting-started/calling-your-first-windows-sys-api.md)
- [Calling your first COM API](rust-getting-started/calling-your-first-com-api.md)
- [Calling your first WinRT API](rust-getting-started/calling-your-first-winrt-api.md)
- [How do I query for a specific COM interface?](rust-getting-started/how-to-query-for-com-interface.md)
- [How do I implement an existing COM interface?](rust-getting-started/how-to-implement-com-interface.md)
- [How do I create stock collections for WinRT collection interfaces?](rust-getting-started/how-to-implement-winrt-collection.md)
- [Understanding the windows-targets crate](rust-getting-started/understanding-windows-targets.md)
- [Standalone code generation](rust-getting-started/standalone-code-generation.md)
- [Creating your first DLL in Rust](rust-getting-started/creating-your-first-dll.md)
- [Implement a traditional Win32-style API](rust-getting-started/implement-win32-api.md)
- [Working with strings in the windows crate](rust-getting-started/string-tutorial.md)