// C++/WinRT v2.0.250303.1

// SPDX-License-Identifier: MIT OR Apache-2.0
// SPDX-FileCopyrightText: Copyright (c) Microsoft Corporation
//
// Generated using .winmd files from https://github.com/microsoft/windows-rs
//

#pragma once
#ifndef WINRT_Windows_UI_Input_Preview_Text_0_H
#define WINRT_Windows_UI_Input_Preview_Text_0_H
WINRT_EXPORT namespace winrt::Windows::Foundation
{
    struct EventRegistrationToken;
    struct IAsyncAction;
    struct Rect;
    template <typename TSender, typename TResult> struct WINRT_IMPL_EMPTY_BASES TypedEventHandler;
}
WINRT_EXPORT namespace winrt::Windows::System
{
    enum class VirtualKey : int32_t;
}
WINRT_EXPORT namespace winrt::Windows::UI
{
    struct Color;
}
WINRT_EXPORT namespace winrt::Windows::UI::Core
{
    struct CorePhysicalKeyStatus;
}
WINRT_EXPORT namespace winrt::Windows::UI::Text
{
    enum class UnderlineType : int32_t;
}
WINRT_EXPORT namespace winrt::Windows::UI::Text::Core
{
    enum class CoreTextFormatUpdatingReason : int32_t;
    enum class CoreTextInputScope : int32_t;
    struct CoreTextRange;
}
WINRT_EXPORT namespace winrt::Windows::UI::Input::Preview::Text
{
    enum class KeyEventDeviceType : int32_t
    {
        Undefined = 0,
        HardwareKeyboard = 1,
        SoftwareKeyboard = 2,
        Gamepad = 3,
        Injection = 4,
    };
    enum class PayloadResult : int32_t
    {
        InEditing = 0,
        Pending = 1,
        Completed = 2,
        Overridden = 3,
        Outrun = 4,
        Rejected = 5,
        Canceled = 6,
    };
    enum class TextBoxContentAttribute : int32_t
    {
        None = 0,
        Selection = 1,
        Text = 2,
        Property = 3,
        Layout = 4,
    };
    enum class TextBoxFeatures : uint32_t
    {
        None = 0,
        ReadText = 0x1,
        WriteText = 0x2,
        AugmentText = 0x4,
    };
    enum class TextBoxSettings : uint32_t
    {
        None = 0,
        Private = 0x1,
        Multiline = 0x2,
        VerticalWriting = 0x4,
    };
    enum class TextChangeSource : int32_t
    {
        External = 0,
        HardwareKeyTyped = 1,
        SoftwareKeyTyped = 2,
        KeyboardImeInsertion = 3,
        OtherImeInsertion = 4,
        Reconversion = 5,
        AutoCompletion = 6,
        Mixed = 7,
    };
    enum class TextConversionMode : int32_t
    {
        Undefined = 0,
        AlphanumericHalfWidth = 1,
        AlphanumericFullWidth = 2,
        NativeHalfWidth = 3,
        NativeFullWidth = 4,
        KatakanaHalfWidth = 5,
        KatakanaFullWidth = 6,
        NativeHalfWidthNativeSymbol = 7,
        NativeFullWidthNativeSymbol = 8,
        NoConversion = 9,
        RequestConversion = 10,
        NativeEudc = 11,
    };
    enum class TextStyleAttributes : uint32_t
    {
        None = 0,
        TextColor = 0x1,
        BackgroundColor = 0x2,
        UnderlineColor = 0x4,
        UnderlineType = 0x8,
    };
    struct IConversionModeChangedEventArgs;
    struct IFocusEnteredEventArgs;
    struct IInputDelegationModeChangedEventArgs;
    struct IKeyEventReceivedEventArgs;
    struct IKeyboardInputProcessor;
    struct IReconversionRequestedEventArgs;
    struct ITextBoxContentChangedEventArgs;
    struct ITextBoxInfo;
    struct ITextBoxInfoChangedEventArgs;
    struct ITextComposition;
    struct ITextCompositionSegment;
    struct ITextEditSession;
    struct ITextInputProvider;
    struct ITextInputService;
    struct ITextInputServiceStatics;
    struct ConversionModeChangedEventArgs;
    struct FocusEnteredEventArgs;
    struct InputDelegationModeChangedEventArgs;
    struct KeyEventReceivedEventArgs;
    struct KeyboardInputProcessor;
    struct ReconversionRequestedEventArgs;
    struct TextBoxContentChangedEventArgs;
    struct TextBoxInfo;
    struct TextBoxInfoChangedEventArgs;
    struct TextComposition;
    struct TextCompositionSegment;
    struct TextEditSession;
    struct TextInputProvider;
    struct TextInputService;
    struct TextBoxId;
    struct TextInputServiceSubscription;
    struct TextStyle;
    struct PreviewTextContract;
}
namespace winrt::impl
{
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::IConversionModeChangedEventArgs>{ using type = interface_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::IFocusEnteredEventArgs>{ using type = interface_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::IInputDelegationModeChangedEventArgs>{ using type = interface_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::IKeyEventReceivedEventArgs>{ using type = interface_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor>{ using type = interface_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::IReconversionRequestedEventArgs>{ using type = interface_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::ITextBoxContentChangedEventArgs>{ using type = interface_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::ITextBoxInfo>{ using type = interface_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::ITextBoxInfoChangedEventArgs>{ using type = interface_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::ITextComposition>{ using type = interface_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::ITextCompositionSegment>{ using type = interface_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::ITextEditSession>{ using type = interface_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::ITextInputProvider>{ using type = interface_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::ITextInputService>{ using type = interface_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::ITextInputServiceStatics>{ using type = interface_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::ConversionModeChangedEventArgs>{ using type = class_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::FocusEnteredEventArgs>{ using type = class_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::InputDelegationModeChangedEventArgs>{ using type = class_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::KeyEventReceivedEventArgs>{ using type = class_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor>{ using type = class_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::ReconversionRequestedEventArgs>{ using type = class_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::TextBoxContentChangedEventArgs>{ using type = class_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::TextBoxInfo>{ using type = class_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::TextBoxInfoChangedEventArgs>{ using type = class_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::TextComposition>{ using type = class_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::TextCompositionSegment>{ using type = class_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::TextEditSession>{ using type = class_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::TextInputProvider>{ using type = class_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::TextInputService>{ using type = class_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::KeyEventDeviceType>{ using type = enum_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::PayloadResult>{ using type = enum_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::TextBoxContentAttribute>{ using type = enum_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::TextBoxFeatures>{ using type = enum_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::TextBoxSettings>{ using type = enum_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::TextChangeSource>{ using type = enum_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::TextConversionMode>{ using type = enum_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::TextStyleAttributes>{ using type = enum_category; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::TextBoxId>{ using type = struct_category<uint32_t>; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::TextInputServiceSubscription>{ using type = struct_category<winrt::Windows::UI::Input::Preview::Text::TextBoxFeatures, winrt::Windows::UI::Input::Preview::Text::TextBoxFeatures>; };
    template <> struct category<winrt::Windows::UI::Input::Preview::Text::TextStyle>{ using type = struct_category<winrt::Windows::UI::Input::Preview::Text::TextStyleAttributes, winrt::Windows::UI::Color, winrt::Windows::UI::Color, winrt::Windows::UI::Color, winrt::Windows::UI::Text::UnderlineType>; };
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::ConversionModeChangedEventArgs> = L"Windows.UI.Input.Preview.Text.ConversionModeChangedEventArgs";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::FocusEnteredEventArgs> = L"Windows.UI.Input.Preview.Text.FocusEnteredEventArgs";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::InputDelegationModeChangedEventArgs> = L"Windows.UI.Input.Preview.Text.InputDelegationModeChangedEventArgs";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::KeyEventReceivedEventArgs> = L"Windows.UI.Input.Preview.Text.KeyEventReceivedEventArgs";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor> = L"Windows.UI.Input.Preview.Text.KeyboardInputProcessor";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::ReconversionRequestedEventArgs> = L"Windows.UI.Input.Preview.Text.ReconversionRequestedEventArgs";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::TextBoxContentChangedEventArgs> = L"Windows.UI.Input.Preview.Text.TextBoxContentChangedEventArgs";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::TextBoxInfo> = L"Windows.UI.Input.Preview.Text.TextBoxInfo";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::TextBoxInfoChangedEventArgs> = L"Windows.UI.Input.Preview.Text.TextBoxInfoChangedEventArgs";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::TextComposition> = L"Windows.UI.Input.Preview.Text.TextComposition";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::TextCompositionSegment> = L"Windows.UI.Input.Preview.Text.TextCompositionSegment";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::TextEditSession> = L"Windows.UI.Input.Preview.Text.TextEditSession";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::TextInputProvider> = L"Windows.UI.Input.Preview.Text.TextInputProvider";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::TextInputService> = L"Windows.UI.Input.Preview.Text.TextInputService";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::KeyEventDeviceType> = L"Windows.UI.Input.Preview.Text.KeyEventDeviceType";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::PayloadResult> = L"Windows.UI.Input.Preview.Text.PayloadResult";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::TextBoxContentAttribute> = L"Windows.UI.Input.Preview.Text.TextBoxContentAttribute";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::TextBoxFeatures> = L"Windows.UI.Input.Preview.Text.TextBoxFeatures";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::TextBoxSettings> = L"Windows.UI.Input.Preview.Text.TextBoxSettings";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::TextChangeSource> = L"Windows.UI.Input.Preview.Text.TextChangeSource";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::TextConversionMode> = L"Windows.UI.Input.Preview.Text.TextConversionMode";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::TextStyleAttributes> = L"Windows.UI.Input.Preview.Text.TextStyleAttributes";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::TextBoxId> = L"Windows.UI.Input.Preview.Text.TextBoxId";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::TextInputServiceSubscription> = L"Windows.UI.Input.Preview.Text.TextInputServiceSubscription";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::TextStyle> = L"Windows.UI.Input.Preview.Text.TextStyle";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::IConversionModeChangedEventArgs> = L"Windows.UI.Input.Preview.Text.IConversionModeChangedEventArgs";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::IFocusEnteredEventArgs> = L"Windows.UI.Input.Preview.Text.IFocusEnteredEventArgs";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::IInputDelegationModeChangedEventArgs> = L"Windows.UI.Input.Preview.Text.IInputDelegationModeChangedEventArgs";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::IKeyEventReceivedEventArgs> = L"Windows.UI.Input.Preview.Text.IKeyEventReceivedEventArgs";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor> = L"Windows.UI.Input.Preview.Text.IKeyboardInputProcessor";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::IReconversionRequestedEventArgs> = L"Windows.UI.Input.Preview.Text.IReconversionRequestedEventArgs";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::ITextBoxContentChangedEventArgs> = L"Windows.UI.Input.Preview.Text.ITextBoxContentChangedEventArgs";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::ITextBoxInfo> = L"Windows.UI.Input.Preview.Text.ITextBoxInfo";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::ITextBoxInfoChangedEventArgs> = L"Windows.UI.Input.Preview.Text.ITextBoxInfoChangedEventArgs";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::ITextComposition> = L"Windows.UI.Input.Preview.Text.ITextComposition";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::ITextCompositionSegment> = L"Windows.UI.Input.Preview.Text.ITextCompositionSegment";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::ITextEditSession> = L"Windows.UI.Input.Preview.Text.ITextEditSession";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::ITextInputProvider> = L"Windows.UI.Input.Preview.Text.ITextInputProvider";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::ITextInputService> = L"Windows.UI.Input.Preview.Text.ITextInputService";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::ITextInputServiceStatics> = L"Windows.UI.Input.Preview.Text.ITextInputServiceStatics";
    template <> inline constexpr auto& name_v<winrt::Windows::UI::Input::Preview::Text::PreviewTextContract> = L"Windows.UI.Input.Preview.Text.PreviewTextContract";
    template <> inline constexpr guid guid_v<winrt::Windows::UI::Input::Preview::Text::IConversionModeChangedEventArgs>{ 0xB49761F9,0x5B21,0x513C,{ 0xB6,0xC0,0x78,0xF2,0x7D,0x26,0xB0,0x10 } }; // B49761F9-5B21-513C-B6C0-78F27D26B010
    template <> inline constexpr guid guid_v<winrt::Windows::UI::Input::Preview::Text::IFocusEnteredEventArgs>{ 0xCA4DC200,0x875F,0x501D,{ 0xAF,0x14,0x41,0x3A,0x0A,0xA1,0xED,0x5F } }; // CA4DC200-875F-501D-AF14-413A0AA1ED5F
    template <> inline constexpr guid guid_v<winrt::Windows::UI::Input::Preview::Text::IInputDelegationModeChangedEventArgs>{ 0x4BB448B2,0x67BA,0x5215,{ 0x87,0x83,0xB4,0x44,0xBD,0x28,0xEE,0xD3 } }; // 4BB448B2-67BA-5215-8783-B444BD28EED3
    template <> inline constexpr guid guid_v<winrt::Windows::UI::Input::Preview::Text::IKeyEventReceivedEventArgs>{ 0x0C30F686,0xA058,0x5ECC,{ 0xAB,0xD2,0x9C,0xC8,0x61,0xC1,0x18,0x5B } }; // 0C30F686-A058-5ECC-ABD2-9CC861C1185B
    template <> inline constexpr guid guid_v<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor>{ 0x2AFE79B6,0x5818,0x50E0,{ 0x8F,0xA8,0x81,0xBC,0x96,0x42,0x8C,0x46 } }; // 2AFE79B6-5818-50E0-8FA8-81BC96428C46
    template <> inline constexpr guid guid_v<winrt::Windows::UI::Input::Preview::Text::IReconversionRequestedEventArgs>{ 0x73852244,0xD202,0x55FE,{ 0x9E,0xDF,0xBE,0xB7,0xEC,0x19,0xF9,0x37 } }; // 73852244-D202-55FE-9EDF-BEB7EC19F937
    template <> inline constexpr guid guid_v<winrt::Windows::UI::Input::Preview::Text::ITextBoxContentChangedEventArgs>{ 0x2CB70A41,0x5AED,0x58C5,{ 0xB4,0xC1,0x8E,0xE4,0xE1,0x49,0x2F,0x9E } }; // 2CB70A41-5AED-58C5-B4C1-8EE4E1492F9E
    template <> inline constexpr guid guid_v<winrt::Windows::UI::Input::Preview::Text::ITextBoxInfo>{ 0xB122443D,0xE8F7,0x5F8B,{ 0x81,0x3D,0xAA,0xA0,0x94,0x1D,0x5F,0xA0 } }; // B122443D-E8F7-5F8B-813D-AAA0941D5FA0
    template <> inline constexpr guid guid_v<winrt::Windows::UI::Input::Preview::Text::ITextBoxInfoChangedEventArgs>{ 0xAC1275AF,0x648C,0x5BAC,{ 0xB2,0x9F,0xD1,0xEA,0x17,0xE9,0xE6,0xD6 } }; // AC1275AF-648C-5BAC-B29F-D1EA17E9E6D6
    template <> inline constexpr guid guid_v<winrt::Windows::UI::Input::Preview::Text::ITextComposition>{ 0x5CEA9AEA,0x524D,0x50A4,{ 0xB0,0x8A,0xC8,0x3D,0x8D,0x25,0xEC,0x6E } }; // 5CEA9AEA-524D-50A4-B08A-C83D8D25EC6E
    template <> inline constexpr guid guid_v<winrt::Windows::UI::Input::Preview::Text::ITextCompositionSegment>{ 0x0543F6C6,0xEB98,0x56D6,{ 0x88,0x08,0x2E,0xCA,0x6D,0x02,0xF6,0xA5 } }; // 0543F6C6-EB98-56D6-8808-2ECA6D02F6A5
    template <> inline constexpr guid guid_v<winrt::Windows::UI::Input::Preview::Text::ITextEditSession>{ 0x0BCAD18A,0xD31B,0x5787,{ 0xAF,0xF9,0x99,0x5E,0xE7,0x43,0xAE,0xA8 } }; // 0BCAD18A-D31B-5787-AFF9-995EE743AEA8
    template <> inline constexpr guid guid_v<winrt::Windows::UI::Input::Preview::Text::ITextInputProvider>{ 0xB0885FB7,0xE9F8,0x5849,{ 0xB0,0xEF,0xF8,0x15,0x5E,0xCF,0x60,0xD1 } }; // B0885FB7-E9F8-5849-B0EF-F8155ECF60D1
    template <> inline constexpr guid guid_v<winrt::Windows::UI::Input::Preview::Text::ITextInputService>{ 0x8E23F89C,0xAB1F,0x551A,{ 0x87,0x51,0x7D,0x4F,0x29,0xE3,0x4D,0x88 } }; // 8E23F89C-AB1F-551A-8751-7D4F29E34D88
    template <> inline constexpr guid guid_v<winrt::Windows::UI::Input::Preview::Text::ITextInputServiceStatics>{ 0x91B68F5E,0x02ED,0x4E09,{ 0xAE,0x89,0xDF,0xD7,0x35,0xCF,0x10,0xBC } }; // 91B68F5E-02ED-4E09-AE89-DFD735CF10BC
    template <> struct default_interface<winrt::Windows::UI::Input::Preview::Text::ConversionModeChangedEventArgs>{ using type = winrt::Windows::UI::Input::Preview::Text::IConversionModeChangedEventArgs; };
    template <> struct default_interface<winrt::Windows::UI::Input::Preview::Text::FocusEnteredEventArgs>{ using type = winrt::Windows::UI::Input::Preview::Text::IFocusEnteredEventArgs; };
    template <> struct default_interface<winrt::Windows::UI::Input::Preview::Text::InputDelegationModeChangedEventArgs>{ using type = winrt::Windows::UI::Input::Preview::Text::IInputDelegationModeChangedEventArgs; };
    template <> struct default_interface<winrt::Windows::UI::Input::Preview::Text::KeyEventReceivedEventArgs>{ using type = winrt::Windows::UI::Input::Preview::Text::IKeyEventReceivedEventArgs; };
    template <> struct default_interface<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor>{ using type = winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor; };
    template <> struct default_interface<winrt::Windows::UI::Input::Preview::Text::ReconversionRequestedEventArgs>{ using type = winrt::Windows::UI::Input::Preview::Text::IReconversionRequestedEventArgs; };
    template <> struct default_interface<winrt::Windows::UI::Input::Preview::Text::TextBoxContentChangedEventArgs>{ using type = winrt::Windows::UI::Input::Preview::Text::ITextBoxContentChangedEventArgs; };
    template <> struct default_interface<winrt::Windows::UI::Input::Preview::Text::TextBoxInfo>{ using type = winrt::Windows::UI::Input::Preview::Text::ITextBoxInfo; };
    template <> struct default_interface<winrt::Windows::UI::Input::Preview::Text::TextBoxInfoChangedEventArgs>{ using type = winrt::Windows::UI::Input::Preview::Text::ITextBoxInfoChangedEventArgs; };
    template <> struct default_interface<winrt::Windows::UI::Input::Preview::Text::TextComposition>{ using type = winrt::Windows::UI::Input::Preview::Text::ITextComposition; };
    template <> struct default_interface<winrt::Windows::UI::Input::Preview::Text::TextCompositionSegment>{ using type = winrt::Windows::UI::Input::Preview::Text::ITextCompositionSegment; };
    template <> struct default_interface<winrt::Windows::UI::Input::Preview::Text::TextEditSession>{ using type = winrt::Windows::UI::Input::Preview::Text::ITextEditSession; };
    template <> struct default_interface<winrt::Windows::UI::Input::Preview::Text::TextInputProvider>{ using type = winrt::Windows::UI::Input::Preview::Text::ITextInputProvider; };
    template <> struct default_interface<winrt::Windows::UI::Input::Preview::Text::TextInputService>{ using type = winrt::Windows::UI::Input::Preview::Text::ITextInputService; };
    template <> struct abi<winrt::Windows::UI::Input::Preview::Text::IConversionModeChangedEventArgs>
    {
        struct WINRT_IMPL_NOVTABLE type : inspectable_abi
        {
            virtual int32_t __stdcall get_NewConversionMode(int32_t*) noexcept = 0;
        };
    };
    template <> struct abi<winrt::Windows::UI::Input::Preview::Text::IFocusEnteredEventArgs>
    {
        struct WINRT_IMPL_NOVTABLE type : inspectable_abi
        {
            virtual int32_t __stdcall get_FocusedTextBoxInfo(void**) noexcept = 0;
        };
    };
    template <> struct abi<winrt::Windows::UI::Input::Preview::Text::IInputDelegationModeChangedEventArgs>
    {
        struct WINRT_IMPL_NOVTABLE type : inspectable_abi
        {
            virtual int32_t __stdcall get_DelegationOn(bool*) noexcept = 0;
        };
    };
    template <> struct abi<winrt::Windows::UI::Input::Preview::Text::IKeyEventReceivedEventArgs>
    {
        struct WINRT_IMPL_NOVTABLE type : inspectable_abi
        {
            virtual int32_t __stdcall get_VirtualKey(int32_t*) noexcept = 0;
            virtual int32_t __stdcall get_KeyStatus(struct struct_Windows_UI_Core_CorePhysicalKeyStatus*) noexcept = 0;
            virtual int32_t __stdcall get_Unicode(void**) noexcept = 0;
            virtual int32_t __stdcall get_Source(int32_t*) noexcept = 0;
            virtual int32_t __stdcall IsKeyPressed(int32_t, bool*) noexcept = 0;
            virtual int32_t __stdcall IsToggleKeyOn(int32_t, bool*) noexcept = 0;
            virtual int32_t __stdcall get_EditSession(void**) noexcept = 0;
            virtual int32_t __stdcall get_Handled(bool*) noexcept = 0;
            virtual int32_t __stdcall put_Handled(bool) noexcept = 0;
        };
    };
    template <> struct abi<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor>
    {
        struct WINRT_IMPL_NOVTABLE type : inspectable_abi
        {
            virtual int32_t __stdcall get_InputProfile(void**) noexcept = 0;
            virtual int32_t __stdcall get_IsActive(bool*) noexcept = 0;
            virtual int32_t __stdcall get_HasFocusedTextBox(bool*) noexcept = 0;
            virtual int32_t __stdcall get_FocusedTextBoxId(struct struct_Windows_UI_Input_Preview_Text_TextBoxId*) noexcept = 0;
            virtual int32_t __stdcall get_FocusedTextBoxInfo(void**) noexcept = 0;
            virtual int32_t __stdcall get_FocusedTextBoxBounds(void**) noexcept = 0;
            virtual int32_t __stdcall get_SelectionBounds(void**) noexcept = 0;
            virtual int32_t __stdcall get_ConversionMode(int32_t*) noexcept = 0;
            virtual int32_t __stdcall put_ConversionMode(int32_t) noexcept = 0;
            virtual int32_t __stdcall CreateEditSession(void**) noexcept = 0;
            virtual int32_t __stdcall add_Activated(void*, winrt::event_token*) noexcept = 0;
            virtual int32_t __stdcall remove_Activated(winrt::event_token) noexcept = 0;
            virtual int32_t __stdcall add_Deactivated(void*, winrt::event_token*) noexcept = 0;
            virtual int32_t __stdcall remove_Deactivated(winrt::event_token) noexcept = 0;
            virtual int32_t __stdcall add_KeyEventReceived(void*, winrt::event_token*) noexcept = 0;
            virtual int32_t __stdcall remove_KeyEventReceived(winrt::event_token) noexcept = 0;
            virtual int32_t __stdcall add_FocusEntered(void*, winrt::event_token*) noexcept = 0;
            virtual int32_t __stdcall remove_FocusEntered(winrt::event_token) noexcept = 0;
            virtual int32_t __stdcall add_FocusRemoved(void*, winrt::event_token*) noexcept = 0;
            virtual int32_t __stdcall remove_FocusRemoved(winrt::event_token) noexcept = 0;
            virtual int32_t __stdcall add_ConversionModeChanged(void*, winrt::event_token*) noexcept = 0;
            virtual int32_t __stdcall remove_ConversionModeChanged(winrt::event_token) noexcept = 0;
            virtual int32_t __stdcall add_TextBoxInfoChanged(void*, winrt::event_token*) noexcept = 0;
            virtual int32_t __stdcall remove_TextBoxInfoChanged(winrt::event_token) noexcept = 0;
            virtual int32_t __stdcall add_TextBoxContentChanged(void*, winrt::event_token*) noexcept = 0;
            virtual int32_t __stdcall remove_TextBoxContentChanged(winrt::event_token) noexcept = 0;
            virtual int32_t __stdcall add_CompositionTerminated(void*, winrt::event_token*) noexcept = 0;
            virtual int32_t __stdcall remove_CompositionTerminated(winrt::event_token) noexcept = 0;
            virtual int32_t __stdcall add_ReconversionRequested(void*, winrt::event_token*) noexcept = 0;
            virtual int32_t __stdcall remove_ReconversionRequested(winrt::event_token) noexcept = 0;
        };
    };
    template <> struct abi<winrt::Windows::UI::Input::Preview::Text::IReconversionRequestedEventArgs>
    {
        struct WINRT_IMPL_NOVTABLE type : inspectable_abi
        {
            virtual int32_t __stdcall get_Range(struct struct_Windows_UI_Text_Core_CoreTextRange*) noexcept = 0;
        };
    };
    template <> struct abi<winrt::Windows::UI::Input::Preview::Text::ITextBoxContentChangedEventArgs>
    {
        struct WINRT_IMPL_NOVTABLE type : inspectable_abi
        {
            virtual int32_t __stdcall get_TextBoxId(struct struct_Windows_UI_Input_Preview_Text_TextBoxId*) noexcept = 0;
            virtual int32_t __stdcall get_Source(int32_t*) noexcept = 0;
            virtual int32_t __stdcall get_SelectionBounds(winrt::Windows::Foundation::Rect*) noexcept = 0;
            virtual int32_t __stdcall IsContentAttributeChanged(int32_t, bool*) noexcept = 0;
        };
    };
    template <> struct abi<winrt::Windows::UI::Input::Preview::Text::ITextBoxInfo>
    {
        struct WINRT_IMPL_NOVTABLE type : inspectable_abi
        {
            virtual int32_t __stdcall get_Id(struct struct_Windows_UI_Input_Preview_Text_TextBoxId*) noexcept = 0;
            virtual int32_t __stdcall get_InputScope(int32_t*) noexcept = 0;
            virtual int32_t __stdcall get_AppName(void**) noexcept = 0;
            virtual int32_t __stdcall get_Url(void**) noexcept = 0;
            virtual int32_t __stdcall get_Settings(uint32_t*) noexcept = 0;
            virtual int32_t __stdcall get_DisabledFeatures(uint32_t*) noexcept = 0;
        };
    };
    template <> struct abi<winrt::Windows::UI::Input::Preview::Text::ITextBoxInfoChangedEventArgs>
    {
        struct WINRT_IMPL_NOVTABLE type : inspectable_abi
        {
            virtual int32_t __stdcall get_TextBoxInfo(void**) noexcept = 0;
        };
    };
    template <> struct abi<winrt::Windows::UI::Input::Preview::Text::ITextComposition>
    {
        struct WINRT_IMPL_NOVTABLE type : inspectable_abi
        {
            virtual int32_t __stdcall get_Text(void**) noexcept = 0;
            virtual int32_t __stdcall get_FirstSegment(void**) noexcept = 0;
            virtual int32_t __stdcall get_SelectedSegment(void**) noexcept = 0;
            virtual int32_t __stdcall get_CaretPosition(uint32_t*) noexcept = 0;
            virtual int32_t __stdcall put_CaretPosition(uint32_t) noexcept = 0;
            virtual int32_t __stdcall InsertText(void*, void**) noexcept = 0;
            virtual int32_t __stdcall Complete() noexcept = 0;
            virtual int32_t __stdcall CompleteUnconverted() noexcept = 0;
            virtual int32_t __stdcall CompleteFirstSegment() noexcept = 0;
        };
    };
    template <> struct abi<winrt::Windows::UI::Input::Preview::Text::ITextCompositionSegment>
    {
        struct WINRT_IMPL_NOVTABLE type : inspectable_abi
        {
            virtual int32_t __stdcall get_Text(void**) noexcept = 0;
            virtual int32_t __stdcall put_Text(void*) noexcept = 0;
            virtual int32_t __stdcall get_ConvertedText(void**) noexcept = 0;
            virtual int32_t __stdcall put_ConvertedText(void*) noexcept = 0;
            virtual int32_t __stdcall get_UnconvertedText(void**) noexcept = 0;
            virtual int32_t __stdcall put_UnconvertedText(void*) noexcept = 0;
            virtual int32_t __stdcall get_Range(struct struct_Windows_UI_Text_Core_CoreTextRange*) noexcept = 0;
            virtual int32_t __stdcall get_ConversionState(int32_t*) noexcept = 0;
            virtual int32_t __stdcall put_ConversionState(int32_t) noexcept = 0;
            virtual int32_t __stdcall get_Next(void**) noexcept = 0;
            virtual int32_t __stdcall get_Previous(void**) noexcept = 0;
            virtual int32_t __stdcall GetTextStyle(struct struct_Windows_UI_Input_Preview_Text_TextStyle*) noexcept = 0;
            virtual int32_t __stdcall SetTextStyle(struct struct_Windows_UI_Input_Preview_Text_TextStyle) noexcept = 0;
        };
    };
    template <> struct abi<winrt::Windows::UI::Input::Preview::Text::ITextEditSession>
    {
        struct WINRT_IMPL_NOVTABLE type : inspectable_abi
        {
            virtual int32_t __stdcall get_TextBoxId(struct struct_Windows_UI_Input_Preview_Text_TextBoxId*) noexcept = 0;
            virtual int32_t __stdcall get_TextLength(int32_t*) noexcept = 0;
            virtual int32_t __stdcall get_PopulatedRange(struct struct_Windows_UI_Text_Core_CoreTextRange*) noexcept = 0;
            virtual int32_t __stdcall PopulateAsync(struct struct_Windows_UI_Text_Core_CoreTextRange, void**) noexcept = 0;
            virtual int32_t __stdcall GetText(struct struct_Windows_UI_Text_Core_CoreTextRange, void**) noexcept = 0;
            virtual int32_t __stdcall GetSelectedRange(struct struct_Windows_UI_Text_Core_CoreTextRange*) noexcept = 0;
            virtual int32_t __stdcall SetSelectedRange(struct struct_Windows_UI_Text_Core_CoreTextRange) noexcept = 0;
            virtual int32_t __stdcall ReplaceText(struct struct_Windows_UI_Text_Core_CoreTextRange, void*, struct struct_Windows_UI_Text_Core_CoreTextRange*) noexcept = 0;
            virtual int32_t __stdcall get_Composition(void**) noexcept = 0;
            virtual int32_t __stdcall StartComposition(void**) noexcept = 0;
            virtual int32_t __stdcall StartReconversion(struct struct_Windows_UI_Text_Core_CoreTextRange, void**) noexcept = 0;
            virtual int32_t __stdcall SubmitPayload(bool*) noexcept = 0;
            virtual int32_t __stdcall SubmitPayloadAsync(void**) noexcept = 0;
        };
    };
    template <> struct abi<winrt::Windows::UI::Input::Preview::Text::ITextInputProvider>
    {
        struct WINRT_IMPL_NOVTABLE type : inspectable_abi
        {
            virtual int32_t __stdcall GetSubscription(struct struct_Windows_UI_Input_Preview_Text_TextInputServiceSubscription*) noexcept = 0;
            virtual int32_t __stdcall SetSubscription(struct struct_Windows_UI_Input_Preview_Text_TextInputServiceSubscription) noexcept = 0;
            virtual int32_t __stdcall get_HasFocusedTextBox(bool*) noexcept = 0;
            virtual int32_t __stdcall get_FocusedTextBoxId(struct struct_Windows_UI_Input_Preview_Text_TextBoxId*) noexcept = 0;
            virtual int32_t __stdcall get_FocusedTextBoxInfo(void**) noexcept = 0;
            virtual int32_t __stdcall get_FocusedTextBoxBounds(void**) noexcept = 0;
            virtual int32_t __stdcall get_SelectionBounds(void**) noexcept = 0;
            virtual int32_t __stdcall CreateEditSession(void**) noexcept = 0;
            virtual int32_t __stdcall TryStartDelegation(bool*) noexcept = 0;
            virtual int32_t __stdcall StopDelegation() noexcept = 0;
            virtual int32_t __stdcall add_FocusEntered(void*, winrt::event_token*) noexcept = 0;
            virtual int32_t __stdcall remove_FocusEntered(winrt::event_token) noexcept = 0;
            virtual int32_t __stdcall add_FocusRemoved(void*, winrt::event_token*) noexcept = 0;
            virtual int32_t __stdcall remove_FocusRemoved(winrt::event_token) noexcept = 0;
            virtual int32_t __stdcall add_TextBoxInfoChanged(void*, winrt::event_token*) noexcept = 0;
            virtual int32_t __stdcall remove_TextBoxInfoChanged(winrt::event_token) noexcept = 0;
            virtual int32_t __stdcall add_TextBoxContentChanged(void*, winrt::event_token*) noexcept = 0;
            virtual int32_t __stdcall remove_TextBoxContentChanged(winrt::event_token) noexcept = 0;
            virtual int32_t __stdcall add_CompositionTerminated(void*, winrt::event_token*) noexcept = 0;
            virtual int32_t __stdcall remove_CompositionTerminated(winrt::event_token) noexcept = 0;
            virtual int32_t __stdcall add_ReconversionRequested(void*, winrt::event_token*) noexcept = 0;
            virtual int32_t __stdcall remove_ReconversionRequested(winrt::event_token) noexcept = 0;
            virtual int32_t __stdcall add_InputDelegationModeChanged(void*, winrt::event_token*) noexcept = 0;
            virtual int32_t __stdcall remove_InputDelegationModeChanged(winrt::event_token) noexcept = 0;
        };
    };
    template <> struct abi<winrt::Windows::UI::Input::Preview::Text::ITextInputService>
    {
        struct WINRT_IMPL_NOVTABLE type : inspectable_abi
        {
            virtual int32_t __stdcall CreateKeyboardInputProcessor(void*, void**) noexcept = 0;
            virtual int32_t __stdcall CreateTextInputProvider(void*, void**) noexcept = 0;
        };
    };
    template <> struct abi<winrt::Windows::UI::Input::Preview::Text::ITextInputServiceStatics>
    {
        struct WINRT_IMPL_NOVTABLE type : inspectable_abi
        {
            virtual int32_t __stdcall GetForCurrentThread(void**) noexcept = 0;
        };
    };
    template <typename D>
    struct consume_Windows_UI_Input_Preview_Text_IConversionModeChangedEventArgs
    {
        [[nodiscard]] auto NewConversionMode() const;
    };
    template <> struct consume<winrt::Windows::UI::Input::Preview::Text::IConversionModeChangedEventArgs>
    {
        template <typename D> using type = consume_Windows_UI_Input_Preview_Text_IConversionModeChangedEventArgs<D>;
    };
    template <typename D>
    struct consume_Windows_UI_Input_Preview_Text_IFocusEnteredEventArgs
    {
        [[nodiscard]] auto FocusedTextBoxInfo() const;
    };
    template <> struct consume<winrt::Windows::UI::Input::Preview::Text::IFocusEnteredEventArgs>
    {
        template <typename D> using type = consume_Windows_UI_Input_Preview_Text_IFocusEnteredEventArgs<D>;
    };
    template <typename D>
    struct consume_Windows_UI_Input_Preview_Text_IInputDelegationModeChangedEventArgs
    {
        [[nodiscard]] auto DelegationOn() const;
    };
    template <> struct consume<winrt::Windows::UI::Input::Preview::Text::IInputDelegationModeChangedEventArgs>
    {
        template <typename D> using type = consume_Windows_UI_Input_Preview_Text_IInputDelegationModeChangedEventArgs<D>;
    };
    template <typename D>
    struct consume_Windows_UI_Input_Preview_Text_IKeyEventReceivedEventArgs
    {
        [[nodiscard]] auto VirtualKey() const;
        [[nodiscard]] auto KeyStatus() const;
        [[nodiscard]] auto Unicode() const;
        [[nodiscard]] auto Source() const;
        auto IsKeyPressed(winrt::Windows::System::VirtualKey const& vkey) const;
        auto IsToggleKeyOn(winrt::Windows::System::VirtualKey const& vkey) const;
        [[nodiscard]] auto EditSession() const;
        [[nodiscard]] auto Handled() const;
        auto Handled(bool value) const;
    };
    template <> struct consume<winrt::Windows::UI::Input::Preview::Text::IKeyEventReceivedEventArgs>
    {
        template <typename D> using type = consume_Windows_UI_Input_Preview_Text_IKeyEventReceivedEventArgs<D>;
    };
    template <typename D>
    struct consume_Windows_UI_Input_Preview_Text_IKeyboardInputProcessor
    {
        [[nodiscard]] auto InputProfile() const;
        [[nodiscard]] auto IsActive() const;
        [[nodiscard]] auto HasFocusedTextBox() const;
        [[nodiscard]] auto FocusedTextBoxId() const;
        [[nodiscard]] auto FocusedTextBoxInfo() const;
        [[nodiscard]] auto FocusedTextBoxBounds() const;
        [[nodiscard]] auto SelectionBounds() const;
        [[nodiscard]] auto ConversionMode() const;
        auto ConversionMode(winrt::Windows::UI::Input::Preview::Text::TextConversionMode const& value) const;
        auto CreateEditSession() const;
        auto Activated(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor, winrt::Windows::Foundation::IInspectable> const& handler) const;
        using Activated_revoker = impl::event_revoker<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor, &impl::abi_t<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor>::remove_Activated>;
        [[nodiscard]] auto Activated(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor, winrt::Windows::Foundation::IInspectable> const& handler) const;
        auto Activated(winrt::event_token const& token) const noexcept;
        auto Deactivated(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor, winrt::Windows::Foundation::IInspectable> const& handler) const;
        using Deactivated_revoker = impl::event_revoker<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor, &impl::abi_t<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor>::remove_Deactivated>;
        [[nodiscard]] auto Deactivated(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor, winrt::Windows::Foundation::IInspectable> const& handler) const;
        auto Deactivated(winrt::event_token const& token) const noexcept;
        auto KeyEventReceived(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor, winrt::Windows::UI::Input::Preview::Text::KeyEventReceivedEventArgs> const& handler) const;
        using KeyEventReceived_revoker = impl::event_revoker<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor, &impl::abi_t<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor>::remove_KeyEventReceived>;
        [[nodiscard]] auto KeyEventReceived(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor, winrt::Windows::UI::Input::Preview::Text::KeyEventReceivedEventArgs> const& handler) const;
        auto KeyEventReceived(winrt::event_token const& token) const noexcept;
        auto FocusEntered(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor, winrt::Windows::UI::Input::Preview::Text::FocusEnteredEventArgs> const& handler) const;
        using FocusEntered_revoker = impl::event_revoker<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor, &impl::abi_t<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor>::remove_FocusEntered>;
        [[nodiscard]] auto FocusEntered(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor, winrt::Windows::UI::Input::Preview::Text::FocusEnteredEventArgs> const& handler) const;
        auto FocusEntered(winrt::event_token const& token) const noexcept;
        auto FocusRemoved(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor, winrt::Windows::Foundation::IInspectable> const& handler) const;
        using FocusRemoved_revoker = impl::event_revoker<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor, &impl::abi_t<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor>::remove_FocusRemoved>;
        [[nodiscard]] auto FocusRemoved(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor, winrt::Windows::Foundation::IInspectable> const& handler) const;
        auto FocusRemoved(winrt::event_token const& token) const noexcept;
        auto ConversionModeChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor, winrt::Windows::UI::Input::Preview::Text::ConversionModeChangedEventArgs> const& handler) const;
        using ConversionModeChanged_revoker = impl::event_revoker<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor, &impl::abi_t<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor>::remove_ConversionModeChanged>;
        [[nodiscard]] auto ConversionModeChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor, winrt::Windows::UI::Input::Preview::Text::ConversionModeChangedEventArgs> const& handler) const;
        auto ConversionModeChanged(winrt::event_token const& token) const noexcept;
        auto TextBoxInfoChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor, winrt::Windows::UI::Input::Preview::Text::TextBoxInfoChangedEventArgs> const& handler) const;
        using TextBoxInfoChanged_revoker = impl::event_revoker<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor, &impl::abi_t<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor>::remove_TextBoxInfoChanged>;
        [[nodiscard]] auto TextBoxInfoChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor, winrt::Windows::UI::Input::Preview::Text::TextBoxInfoChangedEventArgs> const& handler) const;
        auto TextBoxInfoChanged(winrt::event_token const& token) const noexcept;
        auto TextBoxContentChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor, winrt::Windows::UI::Input::Preview::Text::TextBoxContentChangedEventArgs> const& handler) const;
        using TextBoxContentChanged_revoker = impl::event_revoker<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor, &impl::abi_t<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor>::remove_TextBoxContentChanged>;
        [[nodiscard]] auto TextBoxContentChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor, winrt::Windows::UI::Input::Preview::Text::TextBoxContentChangedEventArgs> const& handler) const;
        auto TextBoxContentChanged(winrt::event_token const& token) const noexcept;
        auto CompositionTerminated(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor, winrt::Windows::Foundation::IInspectable> const& handler) const;
        using CompositionTerminated_revoker = impl::event_revoker<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor, &impl::abi_t<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor>::remove_CompositionTerminated>;
        [[nodiscard]] auto CompositionTerminated(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor, winrt::Windows::Foundation::IInspectable> const& handler) const;
        auto CompositionTerminated(winrt::event_token const& token) const noexcept;
        auto ReconversionRequested(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor, winrt::Windows::UI::Input::Preview::Text::ReconversionRequestedEventArgs> const& handler) const;
        using ReconversionRequested_revoker = impl::event_revoker<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor, &impl::abi_t<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor>::remove_ReconversionRequested>;
        [[nodiscard]] auto ReconversionRequested(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::KeyboardInputProcessor, winrt::Windows::UI::Input::Preview::Text::ReconversionRequestedEventArgs> const& handler) const;
        auto ReconversionRequested(winrt::event_token const& token) const noexcept;
    };
    template <> struct consume<winrt::Windows::UI::Input::Preview::Text::IKeyboardInputProcessor>
    {
        template <typename D> using type = consume_Windows_UI_Input_Preview_Text_IKeyboardInputProcessor<D>;
    };
    template <typename D>
    struct consume_Windows_UI_Input_Preview_Text_IReconversionRequestedEventArgs
    {
        [[nodiscard]] auto Range() const;
    };
    template <> struct consume<winrt::Windows::UI::Input::Preview::Text::IReconversionRequestedEventArgs>
    {
        template <typename D> using type = consume_Windows_UI_Input_Preview_Text_IReconversionRequestedEventArgs<D>;
    };
    template <typename D>
    struct consume_Windows_UI_Input_Preview_Text_ITextBoxContentChangedEventArgs
    {
        [[nodiscard]] auto TextBoxId() const;
        [[nodiscard]] auto Source() const;
        [[nodiscard]] auto SelectionBounds() const;
        auto IsContentAttributeChanged(winrt::Windows::UI::Input::Preview::Text::TextBoxContentAttribute const& value) const;
    };
    template <> struct consume<winrt::Windows::UI::Input::Preview::Text::ITextBoxContentChangedEventArgs>
    {
        template <typename D> using type = consume_Windows_UI_Input_Preview_Text_ITextBoxContentChangedEventArgs<D>;
    };
    template <typename D>
    struct consume_Windows_UI_Input_Preview_Text_ITextBoxInfo
    {
        [[nodiscard]] auto Id() const;
        [[nodiscard]] auto InputScope() const;
        [[nodiscard]] auto AppName() const;
        [[nodiscard]] auto Url() const;
        [[nodiscard]] auto Settings() const;
        [[nodiscard]] auto DisabledFeatures() const;
    };
    template <> struct consume<winrt::Windows::UI::Input::Preview::Text::ITextBoxInfo>
    {
        template <typename D> using type = consume_Windows_UI_Input_Preview_Text_ITextBoxInfo<D>;
    };
    template <typename D>
    struct consume_Windows_UI_Input_Preview_Text_ITextBoxInfoChangedEventArgs
    {
        [[nodiscard]] auto TextBoxInfo() const;
    };
    template <> struct consume<winrt::Windows::UI::Input::Preview::Text::ITextBoxInfoChangedEventArgs>
    {
        template <typename D> using type = consume_Windows_UI_Input_Preview_Text_ITextBoxInfoChangedEventArgs<D>;
    };
    template <typename D>
    struct consume_Windows_UI_Input_Preview_Text_ITextComposition
    {
        [[nodiscard]] auto Text() const;
        [[nodiscard]] auto FirstSegment() const;
        [[nodiscard]] auto SelectedSegment() const;
        [[nodiscard]] auto CaretPosition() const;
        auto CaretPosition(uint32_t value) const;
        auto InsertText(param::hstring const& text) const;
        auto Complete() const;
        auto CompleteUnconverted() const;
        auto CompleteFirstSegment() const;
    };
    template <> struct consume<winrt::Windows::UI::Input::Preview::Text::ITextComposition>
    {
        template <typename D> using type = consume_Windows_UI_Input_Preview_Text_ITextComposition<D>;
    };
    template <typename D>
    struct consume_Windows_UI_Input_Preview_Text_ITextCompositionSegment
    {
        [[nodiscard]] auto Text() const;
        auto Text(param::hstring const& value) const;
        [[nodiscard]] auto ConvertedText() const;
        auto ConvertedText(param::hstring const& value) const;
        [[nodiscard]] auto UnconvertedText() const;
        auto UnconvertedText(param::hstring const& value) const;
        [[nodiscard]] auto Range() const;
        [[nodiscard]] auto ConversionState() const;
        auto ConversionState(winrt::Windows::UI::Text::Core::CoreTextFormatUpdatingReason const& value) const;
        [[nodiscard]] auto Next() const;
        [[nodiscard]] auto Previous() const;
        auto GetTextStyle() const;
        auto SetTextStyle(winrt::Windows::UI::Input::Preview::Text::TextStyle const& value) const;
    };
    template <> struct consume<winrt::Windows::UI::Input::Preview::Text::ITextCompositionSegment>
    {
        template <typename D> using type = consume_Windows_UI_Input_Preview_Text_ITextCompositionSegment<D>;
    };
    template <typename D>
    struct consume_Windows_UI_Input_Preview_Text_ITextEditSession
    {
        [[nodiscard]] auto TextBoxId() const;
        [[nodiscard]] auto TextLength() const;
        [[nodiscard]] auto PopulatedRange() const;
        auto PopulateAsync(winrt::Windows::UI::Text::Core::CoreTextRange const& range) const;
        auto GetText(winrt::Windows::UI::Text::Core::CoreTextRange const& range) const;
        auto GetSelectedRange() const;
        auto SetSelectedRange(winrt::Windows::UI::Text::Core::CoreTextRange const& value) const;
        auto ReplaceText(winrt::Windows::UI::Text::Core::CoreTextRange const& replaceRange, param::hstring const& text) const;
        [[nodiscard]] auto Composition() const;
        auto StartComposition() const;
        auto StartReconversion(winrt::Windows::UI::Text::Core::CoreTextRange const& range) const;
        auto SubmitPayload() const;
        auto SubmitPayloadAsync() const;
    };
    template <> struct consume<winrt::Windows::UI::Input::Preview::Text::ITextEditSession>
    {
        template <typename D> using type = consume_Windows_UI_Input_Preview_Text_ITextEditSession<D>;
    };
    template <typename D>
    struct consume_Windows_UI_Input_Preview_Text_ITextInputProvider
    {
        auto GetSubscription() const;
        auto SetSubscription(winrt::Windows::UI::Input::Preview::Text::TextInputServiceSubscription const& subscription) const;
        [[nodiscard]] auto HasFocusedTextBox() const;
        [[nodiscard]] auto FocusedTextBoxId() const;
        [[nodiscard]] auto FocusedTextBoxInfo() const;
        [[nodiscard]] auto FocusedTextBoxBounds() const;
        [[nodiscard]] auto SelectionBounds() const;
        auto CreateEditSession() const;
        auto TryStartDelegation() const;
        auto StopDelegation() const;
        auto FocusEntered(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::TextInputProvider, winrt::Windows::UI::Input::Preview::Text::FocusEnteredEventArgs> const& handler) const;
        using FocusEntered_revoker = impl::event_revoker<winrt::Windows::UI::Input::Preview::Text::ITextInputProvider, &impl::abi_t<winrt::Windows::UI::Input::Preview::Text::ITextInputProvider>::remove_FocusEntered>;
        [[nodiscard]] auto FocusEntered(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::TextInputProvider, winrt::Windows::UI::Input::Preview::Text::FocusEnteredEventArgs> const& handler) const;
        auto FocusEntered(winrt::event_token const& token) const noexcept;
        auto FocusRemoved(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::TextInputProvider, winrt::Windows::Foundation::IInspectable> const& handler) const;
        using FocusRemoved_revoker = impl::event_revoker<winrt::Windows::UI::Input::Preview::Text::ITextInputProvider, &impl::abi_t<winrt::Windows::UI::Input::Preview::Text::ITextInputProvider>::remove_FocusRemoved>;
        [[nodiscard]] auto FocusRemoved(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::TextInputProvider, winrt::Windows::Foundation::IInspectable> const& handler) const;
        auto FocusRemoved(winrt::event_token const& token) const noexcept;
        auto TextBoxInfoChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::TextInputProvider, winrt::Windows::UI::Input::Preview::Text::TextBoxInfoChangedEventArgs> const& handler) const;
        using TextBoxInfoChanged_revoker = impl::event_revoker<winrt::Windows::UI::Input::Preview::Text::ITextInputProvider, &impl::abi_t<winrt::Windows::UI::Input::Preview::Text::ITextInputProvider>::remove_TextBoxInfoChanged>;
        [[nodiscard]] auto TextBoxInfoChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::TextInputProvider, winrt::Windows::UI::Input::Preview::Text::TextBoxInfoChangedEventArgs> const& handler) const;
        auto TextBoxInfoChanged(winrt::event_token const& token) const noexcept;
        auto TextBoxContentChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::TextInputProvider, winrt::Windows::UI::Input::Preview::Text::TextBoxContentChangedEventArgs> const& handler) const;
        using TextBoxContentChanged_revoker = impl::event_revoker<winrt::Windows::UI::Input::Preview::Text::ITextInputProvider, &impl::abi_t<winrt::Windows::UI::Input::Preview::Text::ITextInputProvider>::remove_TextBoxContentChanged>;
        [[nodiscard]] auto TextBoxContentChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::TextInputProvider, winrt::Windows::UI::Input::Preview::Text::TextBoxContentChangedEventArgs> const& handler) const;
        auto TextBoxContentChanged(winrt::event_token const& token) const noexcept;
        auto CompositionTerminated(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::TextInputProvider, winrt::Windows::Foundation::IInspectable> const& handler) const;
        using CompositionTerminated_revoker = impl::event_revoker<winrt::Windows::UI::Input::Preview::Text::ITextInputProvider, &impl::abi_t<winrt::Windows::UI::Input::Preview::Text::ITextInputProvider>::remove_CompositionTerminated>;
        [[nodiscard]] auto CompositionTerminated(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::TextInputProvider, winrt::Windows::Foundation::IInspectable> const& handler) const;
        auto CompositionTerminated(winrt::event_token const& token) const noexcept;
        auto ReconversionRequested(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::TextInputProvider, winrt::Windows::UI::Input::Preview::Text::ReconversionRequestedEventArgs> const& handler) const;
        using ReconversionRequested_revoker = impl::event_revoker<winrt::Windows::UI::Input::Preview::Text::ITextInputProvider, &impl::abi_t<winrt::Windows::UI::Input::Preview::Text::ITextInputProvider>::remove_ReconversionRequested>;
        [[nodiscard]] auto ReconversionRequested(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::TextInputProvider, winrt::Windows::UI::Input::Preview::Text::ReconversionRequestedEventArgs> const& handler) const;
        auto ReconversionRequested(winrt::event_token const& token) const noexcept;
        auto InputDelegationModeChanged(winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::TextInputProvider, winrt::Windows::UI::Input::Preview::Text::InputDelegationModeChangedEventArgs> const& handler) const;
        using InputDelegationModeChanged_revoker = impl::event_revoker<winrt::Windows::UI::Input::Preview::Text::ITextInputProvider, &impl::abi_t<winrt::Windows::UI::Input::Preview::Text::ITextInputProvider>::remove_InputDelegationModeChanged>;
        [[nodiscard]] auto InputDelegationModeChanged(auto_revoke_t, winrt::Windows::Foundation::TypedEventHandler<winrt::Windows::UI::Input::Preview::Text::TextInputProvider, winrt::Windows::UI::Input::Preview::Text::InputDelegationModeChangedEventArgs> const& handler) const;
        auto InputDelegationModeChanged(winrt::event_token const& token) const noexcept;
    };
    template <> struct consume<winrt::Windows::UI::Input::Preview::Text::ITextInputProvider>
    {
        template <typename D> using type = consume_Windows_UI_Input_Preview_Text_ITextInputProvider<D>;
    };
    template <typename D>
    struct consume_Windows_UI_Input_Preview_Text_ITextInputService
    {
        auto CreateKeyboardInputProcessor(param::hstring const& inputProfile) const;
        auto CreateTextInputProvider(param::hstring const& inputProfile) const;
    };
    template <> struct consume<winrt::Windows::UI::Input::Preview::Text::ITextInputService>
    {
        template <typename D> using type = consume_Windows_UI_Input_Preview_Text_ITextInputService<D>;
    };
    template <typename D>
    struct consume_Windows_UI_Input_Preview_Text_ITextInputServiceStatics
    {
        auto GetForCurrentThread() const;
    };
    template <> struct consume<winrt::Windows::UI::Input::Preview::Text::ITextInputServiceStatics>
    {
        template <typename D> using type = consume_Windows_UI_Input_Preview_Text_ITextInputServiceStatics<D>;
    };
    struct struct_Windows_UI_Input_Preview_Text_TextBoxId
    {
        uint32_t Value;
    };
    template <> struct abi<Windows::UI::Input::Preview::Text::TextBoxId>
    {
        using type = struct_Windows_UI_Input_Preview_Text_TextBoxId;
    };
    struct struct_Windows_UI_Input_Preview_Text_TextInputServiceSubscription
    {
        uint32_t requiredEnabledFeatures;
        uint32_t requiredDisabledFeatures;
    };
    template <> struct abi<Windows::UI::Input::Preview::Text::TextInputServiceSubscription>
    {
        using type = struct_Windows_UI_Input_Preview_Text_TextInputServiceSubscription;
    };
    struct struct_Windows_UI_Input_Preview_Text_TextStyle
    {
        uint32_t mask;
        struct{ uint8_t A; uint8_t R; uint8_t G; uint8_t B; } textColor;
        struct{ uint8_t A; uint8_t R; uint8_t G; uint8_t B; } backgroundColor;
        struct{ uint8_t A; uint8_t R; uint8_t G; uint8_t B; } underlineColor;
        int32_t underlineType;
    };
    template <> struct abi<Windows::UI::Input::Preview::Text::TextStyle>
    {
        using type = struct_Windows_UI_Input_Preview_Text_TextStyle;
    };
}
#endif
