; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=memcpyopt,dce -S -verify-memoryssa | FileCheck %s

; Negative test
; Check this test is not transformed into memset, or cause a compiler warning
; warning: Compiler has made implicit assumption that TypeSize is not scalable. This may or may not lead to broken code.

define void @foo(ptr %p) {
; CHECK-LABEL: @foo(
; CHECK-NEXT:    store <vscale x 16 x i8> zeroinitializer, ptr [[P:%.*]], align 16
; CHECK-NEXT:    [[TMP1:%.*]] = getelementptr <vscale x 16 x i8>, ptr [[P]], i64 1
; CHECK-NEXT:    store <vscale x 16 x i8> zeroinitializer, ptr [[TMP1]], align 16
; CHECK-NEXT:    ret void
;
  store <vscale x 16 x i8> zeroinitializer, ptr %p
  %tmp1 = getelementptr <vscale x 16 x i8>, ptr %p, i64 1
  store <vscale x 16 x i8> zeroinitializer, ptr %tmp1
  ret void
}

; Test the compiler does not crash on a store of a scalable aggregate type.
define void @test_no_crash_scalable_agg(ptr %p) {
; CHECK-LABEL: @test_no_crash_scalable_agg(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    store { <vscale x 16 x i1>, <vscale x 16 x i1> } zeroinitializer, ptr [[P:%.*]], align 2
; CHECK-NEXT:    ret void
;
entry:
  store { <vscale x 16 x i1>, <vscale x 16 x i1> } zeroinitializer, ptr %p, align 2
  ret void
}

; Positive test

define void @memset_vscale_index_zero(ptr %p, i8 %z) {
; CHECK-LABEL: @memset_vscale_index_zero(
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[P:%.*]], i8 [[Z:%.*]], i64 17, i1 false)
; CHECK-NEXT:    ret void
;
  store i8 %z, ptr %p
  %tmp1 = getelementptr <vscale x 16 x i8>, ptr %p, i32 0, i32 1
  store i8 %z, ptr %tmp1
  %tmp2 = getelementptr <vscale x 16 x i8>, ptr %p, i32 0, i32 2
  store i8 %z, ptr %tmp2
  %tmp3 = getelementptr <vscale x 16 x i8>, ptr %p, i32 0, i32 3
  store i8 %z, ptr %tmp3
  %tmp4 = getelementptr <vscale x 16 x i8>, ptr %p, i32 0, i32 4
  store i8 %z, ptr %tmp4
  %tmp5 = getelementptr <vscale x 16 x i8>, ptr %p, i32 0, i32 5
  store i8 %z, ptr %tmp5
  %tmp6 = getelementptr <vscale x 16 x i8>, ptr %p, i32 0, i32 6
  store i8 %z, ptr %tmp6
  %tmp7 = getelementptr <vscale x 16 x i8>, ptr %p, i32 0, i32 7
  store i8 %z, ptr %tmp7
  %tmp8 = getelementptr <vscale x 16 x i8>, ptr %p, i32 0, i32 8
  store i8 %z, ptr %tmp8
  %tmp9 = getelementptr <vscale x 16 x i8>, ptr %p, i32 0, i32 9
  store i8 %z, ptr %tmp9
  %tmp10 = getelementptr <vscale x 16 x i8>, ptr %p, i32 0, i32 10
  store i8 %z, ptr %tmp10
  %tmp11 = getelementptr <vscale x 16 x i8>, ptr %p, i32 0, i32 11
  store i8 %z, ptr %tmp11
  %tmp12 = getelementptr <vscale x 16 x i8>, ptr %p, i32 0, i32 12
  store i8 %z, ptr %tmp12
  %tmp13 = getelementptr <vscale x 16 x i8>, ptr %p, i32 0, i32 13
  store i8 %z, ptr %tmp13
  %tmp14 = getelementptr <vscale x 16 x i8>, ptr %p, i32 0, i32 14
  store i8 %z, ptr %tmp14
  %tmp15 = getelementptr <vscale x 16 x i8>, ptr %p, i32 0, i32 15
  store i8 %z, ptr %tmp15
  %tmp16 = getelementptr <vscale x 16 x i8>, ptr %p, i32 0, i32 16
  store i8 %z, ptr %tmp16
  ret void
}

define void @memset_vscale_index_nonzero(ptr %p, i8 %z) {
; CHECK-LABEL: @memset_vscale_index_nonzero(
; CHECK-NEXT:    [[TMP0:%.*]] = getelementptr <vscale x 16 x i8>, ptr [[P:%.*]], i32 1, i32 0
; CHECK-NEXT:    call void @llvm.memset.p0.i64(ptr align 1 [[TMP0]], i8 [[Z:%.*]], i64 17, i1 false)
; CHECK-NEXT:    ret void
;
  %tmp0 = getelementptr <vscale x 16 x i8>, ptr %p, i32 1, i32 0
  store i8 %z, ptr %tmp0
  %tmp1 = getelementptr <vscale x 16 x i8>, ptr %p, i32 1, i32 1
  store i8 %z, ptr %tmp1
  %tmp2 = getelementptr <vscale x 16 x i8>, ptr %p, i32 1, i32 2
  store i8 %z, ptr %tmp2
  %tmp3 = getelementptr <vscale x 16 x i8>, ptr %p, i32 1, i32 3
  store i8 %z, ptr %tmp3
  %tmp4 = getelementptr <vscale x 16 x i8>, ptr %p, i32 1, i32 4
  store i8 %z, ptr %tmp4
  %tmp5 = getelementptr <vscale x 16 x i8>, ptr %p, i32 1, i32 5
  store i8 %z, ptr %tmp5
  %tmp6 = getelementptr <vscale x 16 x i8>, ptr %p, i32 1, i32 6
  store i8 %z, ptr %tmp6
  %tmp7 = getelementptr <vscale x 16 x i8>, ptr %p, i32 1, i32 7
  store i8 %z, ptr %tmp7
  %tmp8 = getelementptr <vscale x 16 x i8>, ptr %p, i32 1, i32 8
  store i8 %z, ptr %tmp8
  %tmp9 = getelementptr <vscale x 16 x i8>, ptr %p, i32 1, i32 9
  store i8 %z, ptr %tmp9
  %tmp10 = getelementptr <vscale x 16 x i8>, ptr %p, i32 1, i32 10
  store i8 %z, ptr %tmp10
  %tmp11 = getelementptr <vscale x 16 x i8>, ptr %p, i32 1, i32 11
  store i8 %z, ptr %tmp11
  %tmp12 = getelementptr <vscale x 16 x i8>, ptr %p, i32 1, i32 12
  store i8 %z, ptr %tmp12
  %tmp13 = getelementptr <vscale x 16 x i8>, ptr %p, i32 1, i32 13
  store i8 %z, ptr %tmp13
  %tmp14 = getelementptr <vscale x 16 x i8>, ptr %p, i32 1, i32 14
  store i8 %z, ptr %tmp14
  %tmp15 = getelementptr <vscale x 16 x i8>, ptr %p, i32 1, i32 15
  store i8 %z, ptr %tmp15
  %tmp16 = getelementptr <vscale x 16 x i8>, ptr %p, i32 1, i32 16
  store i8 %z, ptr %tmp16
  ret void
}
