/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.coverage.j2d;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.TileObserver;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.sis.internal.coverage.j2d.ImageUtilities;
import org.apache.sis.internal.coverage.j2d.TileOpExecutor;
import org.apache.sis.internal.coverage.j2d.TiledImage;
import org.apache.sis.internal.coverage.j2d.WriteSupport;
import org.apache.sis.internal.feature.Resources;

public class WritableTiledImage
extends TiledImage
implements WritableRenderedImage {
    private volatile TileObserver[] observers;
    private final Map<Point, Integer> writables = new LinkedHashMap<Point, Integer>();

    public WritableTiledImage(Map<String, Object> map, ColorModel colorModel, int n, int n2, int n3, int n4, WritableRaster ... writableRasterArray) {
        super(map, colorModel, n, n2, n3, n4, writableRasterArray);
    }

    @Override
    public synchronized void addTileObserver(TileObserver tileObserver) {
        this.observers = WriteSupport.addTileObserver(this.observers, tileObserver);
    }

    @Override
    public synchronized void removeTileObserver(TileObserver tileObserver) {
        this.observers = WriteSupport.removeTileObserver(this.observers, tileObserver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WritableRaster getWritableTile(int n3, int n4) {
        Integer n5;
        WritableRaster writableRaster = (WritableRaster)super.getTile(n3, n4);
        Point point = new Point(n3, n4);
        Map<Point, Integer> map = this.writables;
        synchronized (map) {
            n5 = this.writables.merge(point, 1, (n, n2) -> n + 1);
        }
        if (n5 <= 1) {
            WriteSupport.fireTileUpdate(this.observers, this, n3, n4, true);
        }
        return writableRaster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseWritableTile(int n2, int n3) {
        boolean bl;
        Integer n4;
        Point point2 = new Point(n2, n3);
        Map<Point, Integer> map = this.writables;
        synchronized (map) {
            n4 = this.writables.computeIfPresent(point2, (point, n) -> n - 1);
            boolean bl2 = bl = n4 != null && n4 <= 0;
            if (bl) {
                this.writables.remove(point2);
            }
        }
        if (n4 == null) {
            throw new IllegalArgumentException(Resources.format((short)61, n2, n3));
        }
        if (bl) {
            WriteSupport.fireTileUpdate(this.observers, this, n2, n3, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTileWritable(int n, int n2) {
        Point point = new Point(n, n2);
        Map<Point, Integer> map = this.writables;
        synchronized (map) {
            return this.writables.containsKey(point);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Point[] getWritableTileIndices() {
        Point[] pointArray;
        Map<Point, Integer> map = this.writables;
        synchronized (map) {
            int n = this.writables.size();
            if (n == 0) {
                return null;
            }
            pointArray = this.writables.keySet().toArray(new Point[n]);
        }
        for (int i = 0; i < pointArray.length; ++i) {
            pointArray[i] = new Point(pointArray[i]);
        }
        return pointArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasTileWriters() {
        Map<Point, Integer> map = this.writables;
        synchronized (map) {
            return !this.writables.isEmpty();
        }
    }

    @Override
    public void setData(final Raster raster) {
        Rectangle rectangle = raster.getBounds();
        ImageUtilities.clipBounds(this, rectangle);
        if (!rectangle.isEmpty()) {
            TileOpExecutor tileOpExecutor = new TileOpExecutor(this, rectangle){

                @Override
                protected void writeTo(WritableRaster writableRaster) {
                    writableRaster.setRect(raster);
                }
            };
            tileOpExecutor.writeTo(this);
        }
    }
}

