/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.extraction;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class XmlSanitizingReader
extends FilterReader {
    private static final Pattern NULL_ENTITY_PATTERN = Pattern.compile("&#(0+|x0+);", 2);
    private static final int BUFFER_SIZE = 8192;
    private static final int OVERLAP_SIZE = 16;
    private final char[] readBuffer = new char[8208];
    private final char[] buffer = new char[8208];
    private final StringBuilder sb = new StringBuilder(8208);
    private final StringBuffer result = new StringBuffer(8208);
    private int bufferPos = 0;
    private int bufferLimit = 0;
    private int overlapLen = 0;
    private boolean eof = false;

    XmlSanitizingReader(Reader in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        if (this.bufferPos < this.bufferLimit) {
            return this.buffer[this.bufferPos++];
        }
        if (this.fillBuffer() == -1) {
            return -1;
        }
        return this.buffer[this.bufferPos++];
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int totalRead = 0;
        while (totalRead < len) {
            int available = this.bufferLimit - this.bufferPos;
            if (available > 0) {
                int toCopy = Math.min(available, len - totalRead);
                System.arraycopy(this.buffer, this.bufferPos, cbuf, off + totalRead, toCopy);
                this.bufferPos += toCopy;
                totalRead += toCopy;
                continue;
            }
            if (this.fillBuffer() != -1) continue;
            return totalRead == 0 ? -1 : totalRead;
        }
        return totalRead;
    }

    private int fillBuffer() throws IOException {
        int read;
        if (this.eof) {
            return -1;
        }
        if (this.overlapLen > 0) {
            System.arraycopy(this.buffer, this.bufferLimit - this.overlapLen, this.readBuffer, 0, this.overlapLen);
        }
        if ((read = this.in.read(this.readBuffer, this.overlapLen, 8192)) == -1) {
            this.eof = true;
            if (this.overlapLen == 0) {
                return -1;
            }
            read = 0;
        }
        this.sb.setLength(0);
        this.sb.append(this.readBuffer, 0, this.overlapLen + read);
        this.result.setLength(0);
        Matcher matcher = NULL_ENTITY_PATTERN.matcher(this.sb);
        while (matcher.find()) {
            matcher.appendReplacement(this.result, "");
        }
        matcher.appendTail(this.result);
        this.result.getChars(0, this.result.length(), this.buffer, 0);
        this.bufferLimit = this.result.length();
        this.bufferPos = this.overlapLen;
        if (this.bufferPos > this.bufferLimit) {
            this.bufferPos = this.bufferLimit;
        }
        this.overlapLen = this.eof ? 0 : Math.min(16, this.bufferLimit);
        return this.bufferLimit - this.bufferPos;
    }
}

