\name{PatchBasedDenoisingImageFilter}
\alias{PatchBasedDenoisingImageFilter}
\title{PatchBasedDenoisingImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Derived class implementing a specific patch-based denoising algorithm,
as detailed below.
PatchBasedDenoisingImageFilter}
\details{
This class is derived from the base class PatchBasedDenoisingBaseImageFilter ; please refer to the documentation of the base class first. This
class implements a denoising filter that uses iterative non-local, or
semi-local, weighted averaging of image patches for image denoising.
The intensity at each pixel 'p' gets updated as a weighted average of
intensities of a chosen subset of pixels from the image.
This class implements the denoising algorithm using a Gaussian kernel
function for nonparametric density estimation. The class implements a
scheme to automatically estimated the kernel bandwidth parameter
(namely, sigma) using leave-one-out cross validation. It implements
schemes for random sampling of patches non-locally (from the entire
image) as well as semi-locally (from the spatial proximity of the
pixel being denoised at the specific point in time). It implements a
specific scheme for defining patch weights (mask) as described in
Awate and Whitaker 2005 IEEE CVPR and 2006 IEEE TPAMI.
See:
PatchBasedDenoisingBaseImageFilter
itk::PatchBasedDenoisingImageFilter for the Doxygen on the original ITK class.
PatchBasedDenoisingImageFilter}
%C++ includes: sitkPatchBasedDenoisingImageFilter.h
\section{Methods}{
\describe{
\item{Self AlwaysTreatComponentsAsEuclideanOff():}{}
\item{Self AlwaysTreatComponentsAsEuclideanOn():}{
Set the value of AlwaysTreatComponentsAsEuclidean to true or false
respectfully.
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{bool GetAlwaysTreatComponentsAsEuclidean() const:}{
Set/Get flag indicating whether all components should always be
treated as if they are in euclidean space regardless of pixel type.
Defaults to false.
}
\item{bool GetKernelBandwidthEstimation() const:}{
Set/Get flag indicating whether kernel-bandwidth should be estimated
automatically from the image data. Defaults to true.
}
\item{double GetKernelBandwidthFractionPixelsForEstimation() const:}{
Set/Get the fraction of the image to use for kernel bandwidth sigma
estimation. To reduce the computational burden for computing sigma, a
small random fraction of the image pixels can be used.
}
\item{double GetKernelBandwidthMultiplicationFactor() const:}{
Set/Get the kernel bandwidth sigma multiplication factor used to
modify the automatically-estimated kernel bandwidth sigma. At times,
it may be desirable to modify the value of the automatically-estimated
sigma. Typically, this number isn't very far from 1. Note: This is
used only when KernelBandwidthEstimation is True/On.
}
\item{double GetKernelBandwidthSigma() const:}{
Set/Get initial kernel bandwidth estimate. To prevent the class from
automatically modifying this estimate, set KernelBandwidthEstimation
to false in the base class.
}
\item{uint32_t GetKernelBandwidthUpdateFrequency() const:}{
Set/Get the update frequency for the kernel bandwidth estimation. An
optimal bandwidth will be re-estimated based on the denoised image
after every 'n' iterations. Must be a positive integer. Defaults to 3,
i.e. bandwidth updated after every 3 denoising iteration.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{NoiseModelType GetNoiseModel() const:}{
Set/Get the noise model type. Defaults to GAUSSIAN. To use the noise
model during denoising, FidelityWeight must be positive.
}
\item{double GetNoiseModelFidelityWeight() const:}{
Set/Get the weight on the fidelity term (penalizes deviations from the
noisy data). This option is used when a noise model is specified. This
weight controls the balance between the smoothing and the closeness to
the noisy data.
}
\item{double GetNoiseSigma() const:}{}
\item{uint32_t GetNumberOfIterations() const:}{
Set/Get the number of denoising iterations to perform. Must be a
positive integer. Defaults to 1.
}
\item{uint32_t GetNumberOfSamplePatches() const:}{}
\item{uint32_t GetPatchRadius() const:}{
Set/Get the patch radius specified in physical coordinates. Patch
radius is preferably set to an even number. Currently, only isotropic
patches in physical space are allowed; patches can be anisotropic in
voxel space.
}
\item{double GetSampleVariance() const:}{
Set/Get the variance of the domain where patches are sampled.
}
\item{Self KernelBandwidthEstimationOff():}{}
\item{Self KernelBandwidthEstimationOn():}{
Set the value of KernelBandwidthEstimation to true or false
respectfully.
}
\item{ PatchBasedDenoisingImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetAlwaysTreatComponentsAsEuclidean(bool AlwaysTreatComponentsAsEuclidean):}{
Set/Get flag indicating whether all components should always be
treated as if they are in euclidean space regardless of pixel type.
Defaults to false.
}
\item{Self SetKernelBandwidthEstimation(bool KernelBandwidthEstimation):}{
Set/Get flag indicating whether kernel-bandwidth should be estimated
automatically from the image data. Defaults to true.
}
\item{Self SetKernelBandwidthFractionPixelsForEstimation(double KernelBandwidthFractionPixelsForEstimation):}{
Set/Get the fraction of the image to use for kernel bandwidth sigma
estimation. To reduce the computational burden for computing sigma, a
small random fraction of the image pixels can be used.
}
\item{Self SetKernelBandwidthMultiplicationFactor(double KernelBandwidthMultiplicationFactor):}{
Set/Get the kernel bandwidth sigma multiplication factor used to
modify the automatically-estimated kernel bandwidth sigma. At times,
it may be desirable to modify the value of the automatically-estimated
sigma. Typically, this number isn't very far from 1. Note: This is
used only when KernelBandwidthEstimation is True/On.
}
\item{Self SetKernelBandwidthSigma(double KernelBandwidthSigma):}{
Set/Get initial kernel bandwidth estimate. To prevent the class from
automatically modifying this estimate, set KernelBandwidthEstimation
to false in the base class.
}
\item{Self SetKernelBandwidthUpdateFrequency(uint32_t KernelBandwidthUpdateFrequency):}{
Set/Get the update frequency for the kernel bandwidth estimation. An
optimal bandwidth will be re-estimated based on the denoised image
after every 'n' iterations. Must be a positive integer. Defaults to 3,
i.e. bandwidth updated after every 3 denoising iteration.
}
\item{Self SetNoiseModel(NoiseModelType NoiseModel):}{
Set/Get the noise model type. Defaults to GAUSSIAN. To use the noise
model during denoising, FidelityWeight must be positive.
}
\item{Self SetNoiseModelFidelityWeight(double NoiseModelFidelityWeight):}{
Set/Get the weight on the fidelity term (penalizes deviations from the
noisy data). This option is used when a noise model is specified. This
weight controls the balance between the smoothing and the closeness to
the noisy data.
}
\item{Self SetNoiseSigma(double NoiseSigma):}{
Set/Get the noise sigma. Used by the noise model where appropriate,
defaults to 5\% of the image intensity range
}
\item{Self SetNumberOfIterations(uint32_t NumberOfIterations):}{
Set/Get the number of denoising iterations to perform. Must be a
positive integer. Defaults to 1.
}
\item{Self SetNumberOfSamplePatches(uint32_t NumberOfSamplePatches):}{
Set/Get the number of patches to sample for each pixel.
}
\item{Self SetPatchRadius(uint32_t PatchRadius):}{
Set/Get the patch radius specified in physical coordinates. Patch
radius is preferably set to an even number. Currently, only isotropic
patches in physical space are allowed; patches can be anisotropic in
voxel space.
}
\item{Self SetSampleVariance(double SampleVariance):}{
Set/Get the variance of the domain where patches are sampled.
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~PatchBasedDenoisingImageFilter():}{
Destructor
}
}
}
