import re
from collections.abc import Callable, ItemsView, Iterator
from pathlib import Path
from types import TracebackType
from typing import Any

from django.http.request import HttpRequest, QueryDict
from django.http.response import Http404, HttpResponse
from django.template import Engine
from django.utils.safestring import SafeString

DEBUG_ENGINE: Engine

class CallableSettingWrapper:
    def __init__(self, callable_setting: Callable | type[Any]) -> None: ...

class ExceptionCycleWarning(UserWarning): ...

def technical_500_response(
    request: HttpRequest,
    exc_type: type[BaseException] | None,
    exc_value: BaseException | None,
    tb: TracebackType | None,
    status_code: int = ...,
) -> HttpResponse: ...
def get_default_exception_reporter_filter() -> SafeExceptionReporterFilter: ...
def get_exception_reporter_filter(request: HttpRequest | None) -> SafeExceptionReporterFilter: ...

class SafeExceptionReporterFilter:
    cleansed_substitute: str
    hidden_settings: re.Pattern[str]
    def cleanse_setting(self, key: int | str, value: Any) -> Any: ...
    def get_safe_settings(self) -> dict[str, Any]: ...
    def get_safe_request_meta(self, request: HttpRequest) -> dict[str, Any]: ...
    def get_safe_cookies(self, request: HttpRequest) -> dict[str, Any]: ...
    def is_active(self, request: HttpRequest | None) -> bool: ...
    def get_cleansed_multivaluedict(self, request: HttpRequest, multivaluedict: QueryDict) -> QueryDict: ...
    def get_post_parameters(self, request: HttpRequest | None) -> dict[str, Any]: ...
    def cleanse_special_types(self, request: HttpRequest | None, value: Any) -> Any: ...
    def get_traceback_frame_variables(self, request: Any, tb_frame: Any) -> ItemsView[str, Any]: ...

class ExceptionReporter:
    request: HttpRequest | None
    filter: SafeExceptionReporterFilter
    exc_type: type[BaseException] | None
    exc_value: BaseException | None
    tb: TracebackType | None
    is_email: bool
    template_info: Any | None
    template_does_not_exist: bool
    postmortem: Any | None
    @property
    def html_template_path(self) -> Path: ...
    @property
    def text_template_path(self) -> Path: ...
    def __init__(
        self,
        request: HttpRequest | None,
        exc_type: type[BaseException] | None,
        exc_value: BaseException | None,
        tb: TracebackType | None,
        is_email: bool = ...,
    ) -> None: ...
    def get_traceback_data(self) -> dict[str, Any]: ...
    def get_traceback_html(self) -> SafeString: ...
    def get_traceback_text(self) -> SafeString: ...
    def get_traceback_frames(self) -> list[Any]: ...
    def get_exception_traceback_frames(
        self, exc_value: BaseException | None, tb: TracebackType | None
    ) -> Iterator[dict[str, Any]]: ...

def technical_404_response(request: HttpRequest, exception: Http404) -> HttpResponse: ...
def default_urlconf(request: HttpResponse | None) -> HttpResponse: ...
def builtin_template_path(name: str) -> Path: ...
def get_caller(request: HttpRequest) -> str: ...
def get_exception_reporter_class(request: HttpRequest) -> ExceptionReporter: ...
