/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.repository;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.Result;
import com.jetbrains.python.ResultKt;
import com.jetbrains.python.errorProcessing.PyError;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackageVersionComparator;
import com.jetbrains.python.packaging.common.PythonPackageDetails;
import com.jetbrains.python.packaging.common.PythonSimplePackageDetails;
import com.jetbrains.python.packaging.pip.PypiPackageCache;
import com.jetbrains.python.packaging.repository.PyPackageRepository;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J&\u0010\u0007\u001a\u0018\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\b\u0012\u0004\u0012\u00020\t`\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/packaging/repository/PyPIPackageRepository;", "Lcom/jetbrains/python/packaging/repository/PyPackageRepository;", "<init>", "()V", "getPackages", "", "", "buildPackageDetails", "Lcom/jetbrains/python/Result;", "Lcom/jetbrains/python/packaging/common/PythonPackageDetails;", "Lcom/jetbrains/python/errorProcessing/PyError;", "Lcom/jetbrains/python/errorProcessing/PyResult;", "packageName", "intellij.python.community.impl"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nPyPackageRepositoryUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyPackageRepositoryUtil.kt\ncom/jetbrains/python/packaging/repository/PyPIPackageRepository\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,80:1\n40#2,3:81\n*S KotlinDebug\n*F\n+ 1 PyPackageRepositoryUtil.kt\ncom/jetbrains/python/packaging/repository/PyPIPackageRepository\n*L\n53#1:81,3\n*E\n"})
public final class PyPIPackageRepository
extends PyPackageRepository {
    @NotNull
    public static final PyPIPackageRepository INSTANCE = new PyPIPackageRepository();

    private PyPIPackageRepository() {
        super("PyPI", "https://pypi.org/simple/", null);
    }

    @Override
    @NotNull
    public Set<String> getPackages() {
        boolean $i$f$service = false;
        Class<PypiPackageCache> serviceClass$iv = PypiPackageCache.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return ((PypiPackageCache)object).getPackages();
    }

    @Override
    @NotNull
    public Result<PythonPackageDetails, PyError> buildPackageDetails(@NotNull String packageName) {
        Object $this$buildPackageDetails_u24lambda_u241;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        PythonPackageDetails pythonPackageDetails = ResultKt.getOrNull(super.buildPackageDetails(packageName));
        if (pythonPackageDetails != null) {
            PythonPackageDetails it = pythonPackageDetails;
            boolean bl = false;
            return Result.Companion.success(it);
        }
        String string = this.getRepositoryUrl();
        if (string == null) {
            Object[] objectArray = new Object[]{this.getName()};
            String string2 = PyBundle.message("python.packaging.error.no.repository.url", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return Result.Companion.localizedError(string2);
        }
        String repositoryUrl = string;
        Object[] objectArray = this;
        try {
            $this$buildPackageDetails_u24lambda_u241 = objectArray;
            boolean bl = false;
            $this$buildPackageDetails_u24lambda_u241 = kotlin.Result.constructor-impl(PyPIPackageUtil.parsePackageVersionsFromRepository(repositoryUrl, packageName));
        }
        catch (Throwable bl) {
            $this$buildPackageDetails_u24lambda_u241 = kotlin.Result.constructor-impl((Object)kotlin.ResultKt.createFailure((Throwable)bl));
        }
        objectArray = $this$buildPackageDetails_u24lambda_u241;
        Throwable throwable = kotlin.Result.exceptionOrNull-impl((Object)objectArray);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl = false;
            Throwable throwable3 = throwable2;
            if (throwable3 instanceof PyPIPackageUtil.NotSimpleRepositoryApiUrlException || throwable3 instanceof IOException) {
                String string3 = ((Exception)throwable2).getLocalizedMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLocalizedMessage(...)");
                return Result.Companion.localizedError(string3);
            }
            throw throwable2;
        }
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getOrElse(...)");
        List versions2 = (List)objectArray;
        Iterable iterable = versions2;
        Comparator<String> comparator = PyPackageVersionComparator.getSTR_COMPARATOR().reversed();
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"reversed(...)");
        objectArray = new Object[]{this.getName()};
        PythonSimplePackageDetails simplePackageDetails = new PythonSimplePackageDetails(packageName, CollectionsKt.sortedWith((Iterable)iterable, comparator), this, null, PyBundle.message("python.packages.no.details.in.repo", objectArray), null, null, null, null, null, 1000, null);
        return Result.Companion.success(simplePackageDetails);
    }
}

