/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.google.common.base.Preconditions;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.codeInsight.intentions.PyGenerateDocstringIntention;
import com.jetbrains.python.codeInsight.intentions.PyTypeHintGenerationUtil;
import com.jetbrains.python.codeInsight.intentions.SpecifyTypeInPy3AnnotationsIntention;
import com.jetbrains.python.codeInsight.intentions.TypeIntention;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.docstrings.PyDocstringGenerator;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.toolbox.Substring;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpecifyTypeInDocstringIntention
extends TypeIntention {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("INTN.NAME.specify.type.in.docstring", new Object[0]);
        if (string == null) {
            SpecifyTypeInDocstringIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    public void doInvoke(@NotNull Project project, Editor editor2, PsiFile file) throws IncorrectOperationException {
        PyNamedParameter parameter;
        if (project == null) {
            SpecifyTypeInDocstringIntention.$$$reportNull$$$0(1);
        }
        if ((parameter = this.findOnlySuitableParameter(editor2, file)) != null) {
            PyFunction parentFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)parameter, PyFunction.class);
            if (parentFunction != null) {
                SpecifyTypeInDocstringIntention.generateDocstring(parameter, parentFunction);
            }
            return;
        }
        PyFunction function = this.findOnlySuitableFunction(editor2, file);
        if (function != null) {
            SpecifyTypeInDocstringIntention.generateDocstring(null, function);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static void generateDocstring(@Nullable PyNamedParameter param, @NotNull PyFunction pyFunction) {
        if (pyFunction == null) {
            SpecifyTypeInDocstringIntention.$$$reportNull$$$0(2);
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)pyFunction)) {
            return;
        }
        if (!PyGenerateDocstringIntention.ensureNotPlainDocstringFormat(pyFunction)) {
            return;
        }
        PyDocstringGenerator docstringGenerator = PyDocstringGenerator.forDocStringOwner(pyFunction);
        if (param != null) {
            String type2 = SpecifyTypeInPy3AnnotationsIntention.parameterType(param);
            docstringGenerator.withParamTypedByName(param, type2);
        } else {
            PyTypeHintGenerationUtil.AnnotationInfo info = SpecifyTypeInPy3AnnotationsIntention.returnType(pyFunction);
            docstringGenerator.withReturnValue(info.getAnnotationText());
        }
        WriteAction.run(() -> {
            docstringGenerator.addFirstEmptyLine().buildAndInsert();
            SpecifyTypeInDocstringIntention.startTemplate(docstringGenerator);
        });
    }

    @Override
    protected void updateText(boolean isReturn) {
        this.setText(PyPsiBundle.message(isReturn ? "INTN.specify.return.type.in.docstring" : "INTN.specify.type.in.docstring", new Object[0]));
    }

    @Override
    protected boolean isParamTypeDefined(@NotNull PyNamedParameter parameter) {
        PyFunction pyFunction;
        if (parameter == null) {
            SpecifyTypeInDocstringIntention.$$$reportNull$$$0(3);
        }
        if ((pyFunction = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)parameter, PyFunction.class)) != null) {
            StructuredDocString structuredDocString = pyFunction.getStructuredDocString();
            if (structuredDocString == null) {
                return false;
            }
            Substring typeSub = structuredDocString.getParamTypeSubstring(StringUtil.notNullize((String)parameter.getName()));
            return typeSub != null && !typeSub.isEmpty();
        }
        return false;
    }

    @Override
    protected boolean isReturnTypeDefined(@NotNull PyFunction function) {
        StructuredDocString structuredDocString;
        if (function == null) {
            SpecifyTypeInDocstringIntention.$$$reportNull$$$0(4);
        }
        return (structuredDocString = function.getStructuredDocString()) != null && structuredDocString.getReturnType() != null;
    }

    public static void startTemplate(PyDocstringGenerator generator) {
        Substring substring;
        Preconditions.checkNotNull((Object)generator.getDocStringOwner(), (Object)"For this action docstring owner must be supplied");
        PyStringLiteralExpression docStringExpression = (PyStringLiteralExpression)generator.getDocStringExpression();
        assert (docStringExpression != null);
        TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)docStringExpression);
        if (generator.getAddedParams().size() > 1) {
            throw new IllegalArgumentException("TemplateBuilder can be created only for one parameter");
        }
        PyDocstringGenerator.DocstringParam paramToEdit = generator.getParamToEdit();
        DocStringFormat format = generator.getDocStringFormat();
        if (format == DocStringFormat.PLAIN) {
            return;
        }
        StructuredDocString parsed2 = DocStringUtil.parseDocString(format, docStringExpression);
        if (paramToEdit.isReturnValue()) {
            substring = parsed2.getReturnTypeSubstring();
        } else {
            String paramName = paramToEdit.getName();
            substring = parsed2.getParamTypeSubstring(paramName);
        }
        if (substring == null) {
            return;
        }
        builder.replaceRange(substring.getTextRange(), PyDocstringGenerator.getDefaultType(generator.getParamToEdit()));
        VirtualFile virtualFile = generator.getDocStringOwner().getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Editor targetEditor = PsiEditorUtil.findEditor((PsiElement)generator.getDocStringOwner());
        if (targetEditor != null) {
            PyUtil.updateDocumentUnblockedAndCommitted((PsiElement)generator.getDocStringOwner(), document -> {
                builder.run(targetEditor, true);
                return null;
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/SpecifyTypeInDocstringIntention";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFunction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/SpecifyTypeInDocstringIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generateDocstring";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isParamTypeDefined";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isReturnTypeDefined";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

