/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.inspections;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spellchecker.inspections.BaseSplitter;
import com.intellij.spellchecker.inspections.PlainTextSplitter;
import com.intellij.util.Consumer;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CommentSplitter
extends BaseSplitter {
    private static final Pattern HTML = Pattern.compile("<(\\S+?)[^<>]*?>(.*?)</\\1>");
    private static final CommentSplitter INSTANCE = new CommentSplitter();

    public static CommentSplitter getInstance() {
        return INSTANCE;
    }

    @Override
    public void split(@Nullable String text, @NotNull TextRange range, @NotNull Consumer<TextRange> consumer) {
        if (range == null) {
            CommentSplitter.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            CommentSplitter.$$$reportNull$$$0(1);
        }
        if (text == null || StringUtil.isEmpty((String)text)) {
            return;
        }
        List<TextRange> toCheck = CommentSplitter.excludeByPattern(text, range, HTML, 2);
        PlainTextSplitter ps = PlainTextSplitter.getInstance();
        for (TextRange r : toCheck) {
            ps.split(text, r, consumer);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "range";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/spellchecker/inspections/CommentSplitter";
        objectArray[2] = "split";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

