/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.action;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.TransactionRunnable;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.action.HgAbstractGlobalAction;
import org.zmlx.hg4idea.util.HgUtil;

abstract class HgAbstractFilesAction
extends DumbAwareAction {
    private static final Logger LOG = Logger.getInstance((String)HgAbstractGlobalAction.class.getName());

    HgAbstractFilesAction() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            HgAbstractFilesAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    protected abstract boolean isEnabled(Project var1, HgVcs var2, VirtualFile var3);

    protected abstract void batchPerform(Project var1, HgVcs var2, List<VirtualFile> var3, DataContext var4);

    public final void actionPerformed(@NotNull AnActionEvent event) {
        if (event == null) {
            HgAbstractFilesAction.$$$reportNull$$$0(1);
        }
        final DataContext dataContext = event.getDataContext();
        final Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        final VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (project == null || files == null || files.length == 0) {
            return;
        }
        project.save();
        final HgVcs vcs = HgVcs.getInstance(project);
        if (vcs == null || !ProjectLevelVcsManager.getInstance((Project)project).checkAllFilesAreUnder((AbstractVcs)vcs, files)) {
            return;
        }
        AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)project);
        List exceptions = helper.runTransactionRunnable((AbstractVcs)vcs, new TransactionRunnable(){

            public void run(List<VcsException> exceptions) {
                try {
                    HgAbstractFilesAction.this.execute(project, vcs, files, dataContext);
                }
                catch (VcsException ex) {
                    exceptions.add(ex);
                }
            }
        }, null);
        helper.showErrors(exceptions, vcs.getDisplayName());
    }

    public final void update(@NotNull AnActionEvent e) {
        if (e == null) {
            HgAbstractFilesAction.$$$reportNull$$$0(2);
        }
        Presentation presentation = e.getPresentation();
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        VirtualFile[] files = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        if (files == null || files.length == 0) {
            presentation.setEnabled(false);
            return;
        }
        HgVcs vcs = HgVcs.getInstance(project);
        if (vcs == null) {
            presentation.setEnabled(false);
            return;
        }
        if (!ProjectLevelVcsManager.getInstance((Project)project).checkAllFilesAreUnder((AbstractVcs)vcs, files)) {
            presentation.setEnabled(false);
            return;
        }
        boolean enabled = false;
        for (VirtualFile file : files) {
            boolean fileEnabled = this.isEnabled(project, vcs, file);
            if (!fileEnabled) continue;
            enabled = true;
            break;
        }
        presentation.setEnabled(enabled);
    }

    private void execute(Project project, HgVcs activeVcs, VirtualFile[] files, DataContext context) throws VcsException {
        LinkedList<VirtualFile> enabledFiles = new LinkedList<VirtualFile>();
        for (VirtualFile file : files) {
            if (!this.isEnabled(project, activeVcs, file)) continue;
            enabledFiles.add(file);
        }
        this.batchPerform(project, activeVcs, enabledFiles, context);
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (VirtualFile file : files) {
                file.refresh(false, true);
            }
        });
        try {
            for (VirtualFile file : enabledFiles) {
                HgUtil.markFileDirty(project, file);
            }
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOG.info("Exception while marking files dirty", (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/zmlx/hg4idea/action/HgAbstractFilesAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/zmlx/hg4idea/action/HgAbstractFilesAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

