/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sh.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.formatting.IndentInfo;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.lineIndent.LineIndentProvider;
import com.intellij.sh.ShFileType;
import com.intellij.sh.ShLanguage;
import com.intellij.sh.ShTypes;
import com.intellij.sh.formatter.ShSemanticEditorPosition;
import com.intellij.sh.lexer.ShTokenTypes;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShLineIndentProvider
implements LineIndentProvider {
    @Nullable
    public String getLineIndent(@NotNull Project project, @NotNull Editor editor, @Nullable Language language, int offset) {
        ShSemanticEditorPosition position;
        if (project == null) {
            ShLineIndentProvider.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ShLineIndentProvider.$$$reportNull$$$0(1);
        }
        if (offset > 0 && ((position = ShLineIndentProvider.getPosition(editor, offset - 1)).isAt(ShTypes.LINEFEED) || position.isAt(ShTokenTypes.WHITESPACE))) {
            ShLineIndentProvider.moveAtEndOfPreviousLine(position);
            if (position.isAtAnyOf(ShTypes.DO, ShTypes.LEFT_CURLY, ShTypes.ELSE, ShTypes.THEN)) {
                return ShLineIndentProvider.getIndentString(editor, position.getStartOffset(), true);
            }
            if (position.isAt(ShTypes.CASE_END)) {
                return ShLineIndentProvider.getIndentString(editor, position.getStartOffset(), false);
            }
            if (ShLineIndentProvider.isInCasePattern(editor, position)) {
                return ShLineIndentProvider.getIndentString(editor, position.getStartOffset(), true);
            }
        }
        return null;
    }

    public boolean isSuitableFor(@Nullable Language language) {
        return language instanceof ShLanguage;
    }

    private static boolean isInCasePattern(@NotNull Editor editor, ShSemanticEditorPosition position) {
        CharSequence docChars;
        int lineStart;
        if (editor == null) {
            ShLineIndentProvider.$$$reportNull$$$0(2);
        }
        if ((lineStart = CharArrayUtil.shiftBackwardUntil((CharSequence)(docChars = editor.getDocument().getCharsSequence()), (int)position.getStartOffset(), (String)"\n") + 1) >= 0) {
            ShSemanticEditorPosition possiblePatternPosition = ShLineIndentProvider.getPosition(editor, lineStart);
            possiblePatternPosition.moveAfterOptionalMix(ShTokenTypes.WHITESPACE);
            possiblePatternPosition.moveAfterOptionalMix(ShTypes.WORD);
            possiblePatternPosition.moveAfterOptionalMix(ShTokenTypes.WHITESPACE);
            return possiblePatternPosition.isAt(ShTypes.RIGHT_PAREN);
        }
        return false;
    }

    private static void moveAtEndOfPreviousLine(ShSemanticEditorPosition position) {
        position.moveBeforeOptionalMix(ShTokenTypes.WHITESPACE);
        if (position.isAt(ShTypes.LINEFEED)) {
            position.moveBefore();
            position.moveBeforeOptionalMix(ShTokenTypes.WHITESPACE);
        }
    }

    @NotNull
    private static String getIndentString(@NotNull Editor editor, int offset, boolean shouldExpand) {
        int indentEnd;
        int diff;
        int indentStart;
        if (editor == null) {
            ShLineIndentProvider.$$$reportNull$$$0(3);
        }
        CodeStyleSettings settings = CodeStyle.getSettings((Editor)editor);
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions((FileType)ShFileType.INSTANCE);
        CharSequence docChars = editor.getDocument().getCharsSequence();
        Object baseIndent = "";
        if (offset > 0 && (indentStart = CharArrayUtil.shiftBackwardUntil((CharSequence)docChars, (int)offset, (String)"\n") + 1) >= 0 && (diff = (indentEnd = CharArrayUtil.shiftForward((CharSequence)docChars, (int)indentStart, (String)" \t")) - indentStart) > 0) {
            if (shouldExpand) {
                baseIndent = docChars.subSequence(indentStart, indentEnd).toString();
            } else if (diff >= indentOptions.INDENT_SIZE) {
                baseIndent = docChars.subSequence(indentStart, indentEnd - indentOptions.INDENT_SIZE).toString();
            }
        }
        if (shouldExpand) {
            baseIndent = (String)baseIndent + new IndentInfo(0, indentOptions.INDENT_SIZE, 0).generateNewWhiteSpace(indentOptions);
        }
        String string = baseIndent;
        if (string == null) {
            ShLineIndentProvider.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static ShSemanticEditorPosition getPosition(@NotNull Editor editor, int offset) {
        if (editor == null) {
            ShLineIndentProvider.$$$reportNull$$$0(5);
        }
        return ShSemanticEditorPosition.createEditorPosition(editor, offset);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sh/formatter/ShLineIndentProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sh/formatter/ShLineIndentProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndent";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isInCasePattern";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIndentString";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getPosition";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

