/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.RefsModel;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.visible.EmptyVisibleGraph;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 32\u00020\u00012\u00020\u0002:\u000223BO\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u001a\b\u0002\u0010\r\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0018\u0010\u001e\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u001f\u0012\u0006\u0012\u0004\u0018\u00010 0\u001aH\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\fH\u0016J\b\u0010$\u001a\u00020\nH\u0016J\u0016\u0010%\u001a\u0004\u0018\u00010\u001f2\n\u0010&\u001a\u00060\u0007j\u0002`\bH\u0016J#\u0010'\u001a\u0004\u0018\u0001H(\"\u0004\b\u0000\u0010(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0\u000fH\u0016\u00a2\u0006\u0002\u0010*J+\u0010+\u001a\u00020,\"\u0004\b\u0000\u0010(2\f\u0010)\u001a\b\u0012\u0004\u0012\u0002H(0\u000f2\b\u0010-\u001a\u0004\u0018\u0001H(H\u0016\u00a2\u0006\u0002\u0010.J\r\u0010/\u001a\u000700\u00a2\u0006\u0002\b1H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0005\u001a\f\u0012\b\u0012\u00060\u0007j\u0002`\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0019\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0018\u00a8\u00064"}, d2={"Lcom/intellij/vcs/log/visible/VisiblePack;", "Lcom/intellij/vcs/log/VcsLogDataPack;", "Lcom/intellij/openapi/util/UserDataHolder;", "dataPack", "Lcom/intellij/vcs/log/data/DataPackBase;", "visibleGraph", "Lcom/intellij/vcs/log/graph/VisibleGraph;", "", "Lcom/intellij/vcs/log/VcsLogCommitStorageIndex;", "canRequestMore", "", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "data", "", "Lcom/intellij/openapi/util/Key;", "", "<init>", "(Lcom/intellij/vcs/log/data/DataPackBase;Lcom/intellij/vcs/log/graph/VisibleGraph;ZLcom/intellij/vcs/log/VcsLogFilterCollection;Ljava/util/Map;)V", "getDataPack", "()Lcom/intellij/vcs/log/data/DataPackBase;", "getVisibleGraph", "()Lcom/intellij/vcs/log/graph/VisibleGraph;", "getCanRequestMore", "()Z", "additionalData", "", "getAdditionalData", "()Ljava/util/Map;", "isFull", "getLogProviders", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "getRefs", "Lcom/intellij/vcs/log/VcsLogRefs;", "getFilters", "isEmpty", "getRootAtHead", "headCommitIndex", "getUserData", "T", "key", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "putUserData", "", "value", "(Lcom/intellij/openapi/util/Key;Ljava/lang/Object;)V", "toString", "", "Lorg/jetbrains/annotations/NonNls;", "ErrorVisiblePack", "Companion", "intellij.platform.vcs.log.impl"})
public class VisiblePack
implements VcsLogDataPack,
UserDataHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataPackBase dataPack;
    @NotNull
    private final VisibleGraph<Integer> visibleGraph;
    private final boolean canRequestMore;
    @NotNull
    private final VcsLogFilterCollection filters;
    @NotNull
    private final Map<Key<?>, Object> additionalData;
    @JvmField
    @NotNull
    public static final VisiblePack EMPTY;
    @JvmField
    @NotNull
    public static final Key<Boolean> NO_GRAPH_INFORMATION;

    @JvmOverloads
    public VisiblePack(@NotNull DataPackBase dataPack, @NotNull VisibleGraph<Integer> visibleGraph, boolean canRequestMore, @NotNull VcsLogFilterCollection filters, @NotNull Map<Key<?>, ? extends Object> data) {
        Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
        Intrinsics.checkNotNullParameter(visibleGraph, (String)"visibleGraph");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        this.dataPack = dataPack;
        this.visibleGraph = visibleGraph;
        this.canRequestMore = canRequestMore;
        this.filters = filters;
        this.additionalData = new ConcurrentHashMap(data);
    }

    public /* synthetic */ VisiblePack(DataPackBase dataPackBase, VisibleGraph visibleGraph, boolean bl, VcsLogFilterCollection vcsLogFilterCollection, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            map = MapsKt.emptyMap();
        }
        this(dataPackBase, (VisibleGraph<Integer>)visibleGraph, bl, vcsLogFilterCollection, map);
    }

    @NotNull
    public final DataPackBase getDataPack() {
        return this.dataPack;
    }

    @NotNull
    public final VisibleGraph<Integer> getVisibleGraph() {
        return this.visibleGraph;
    }

    public final boolean getCanRequestMore() {
        return this.canRequestMore;
    }

    @NotNull
    public final Map<Key<?>, Object> getAdditionalData() {
        return this.additionalData;
    }

    public final boolean isFull() {
        return this.dataPack.isFull();
    }

    @NotNull
    public Map<VirtualFile, VcsLogProvider> getLogProviders() {
        Map<VirtualFile, VcsLogProvider> map = this.dataPack.getLogProviders();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getLogProviders(...)");
        return map;
    }

    @NotNull
    public VcsLogRefs getRefs() {
        RefsModel refsModel = this.dataPack.getRefsModel();
        Intrinsics.checkNotNullExpressionValue((Object)refsModel, (String)"getRefsModel(...)");
        return refsModel;
    }

    @NotNull
    public VcsLogFilterCollection getFilters() {
        return this.filters;
    }

    public boolean isEmpty() {
        return this.visibleGraph.getVisibleCommitCount() == 0;
    }

    @Nullable
    public VirtualFile getRootAtHead(int headCommitIndex) {
        return this.dataPack.getRefsModel().rootAtHead(headCommitIndex);
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        return (T)this.additionalData.get(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        this.additionalData.put(key, value);
    }

    @NotNull
    public String toString() {
        return "VisiblePack{size=" + this.visibleGraph.getVisibleCommitCount() + ", filters=" + this.filters + ", canRequestMore=" + this.canRequestMore + "}";
    }

    @JvmOverloads
    public VisiblePack(@NotNull DataPackBase dataPack, @NotNull VisibleGraph<Integer> visibleGraph, boolean canRequestMore, @NotNull VcsLogFilterCollection filters) {
        Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
        Intrinsics.checkNotNullParameter(visibleGraph, (String)"visibleGraph");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        this(dataPack, visibleGraph, canRequestMore, filters, null, 16, null);
    }

    static {
        DataPack dataPack = DataPack.EMPTY;
        VisibleGraph<Integer> visibleGraph = EmptyVisibleGraph.getInstance();
        VcsLogFilterCollection vcsLogFilterCollection = VcsLogFilterObject.EMPTY_COLLECTION;
        EMPTY = new VisiblePack(dataPack, visibleGraph, vcsLogFilterCollection){
            {
                DataPackBase dataPackBase = $super_call_param$1;
                Intrinsics.checkNotNull($super_call_param$2);
                super(dataPackBase, $super_call_param$2, false, $super_call_param$3, null, 16, null);
            }

            public String toString() {
                return "EmptyVisiblePack";
            }
        };
        Key key = Key.create((String)"NO_GRAPH_INFORMATION");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        NO_GRAPH_INFORMATION = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/vcs/log/visible/VisiblePack$Companion;", "", "<init>", "()V", "EMPTY", "Lcom/intellij/vcs/log/visible/VisiblePack;", "NO_GRAPH_INFORMATION", "Lcom/intellij/openapi/util/Key;", "", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/vcs/log/visible/VisiblePack$ErrorVisiblePack;", "Lcom/intellij/vcs/log/visible/VisiblePack;", "dataPack", "Lcom/intellij/vcs/log/data/DataPackBase;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "error", "", "<init>", "(Lcom/intellij/vcs/log/data/DataPackBase;Lcom/intellij/vcs/log/VcsLogFilterCollection;Ljava/lang/Throwable;)V", "getError", "()Ljava/lang/Throwable;", "intellij.platform.vcs.log.impl"})
    public static final class ErrorVisiblePack
    extends VisiblePack {
        @NotNull
        private final Throwable error;

        public ErrorVisiblePack(@NotNull DataPackBase dataPack, @NotNull VcsLogFilterCollection filters, @NotNull Throwable error) {
            Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
            Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            VisibleGraph<Integer> visibleGraph = EmptyVisibleGraph.getInstance();
            Intrinsics.checkNotNullExpressionValue(visibleGraph, (String)"getInstance(...)");
            super(dataPack, visibleGraph, false, filters, null, 16, null);
            this.error = error;
        }

        @NotNull
        public final Throwable getError() {
            return this.error;
        }
    }
}

