/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridPagingModel;
import com.intellij.database.datagrid.ModelIndex;
import org.jetbrains.annotations.NotNull;

public abstract class GridPagingModelImpl<Row, Column>
implements GridPagingModel<Row, Column> {
    protected final GridModel<Row, Column> myModel;

    protected GridPagingModelImpl(GridModel<Row, Column> model) {
        this.myModel = model;
    }

    @Override
    @NotNull
    public ModelIndex<Row> findRow(int rowDataIdx) {
        int modelRowIdx = rowDataIdx >= this.getPageStart() && rowDataIdx <= this.getPageEnd() ? rowDataIdx - this.getPageStart() : -1;
        ModelIndex<Row> modelIndex = ModelIndex.forRow(this.myModel, modelRowIdx);
        if (modelIndex == null) {
            GridPagingModelImpl.$$$reportNull$$$0(0);
        }
        return modelIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/GridPagingModelImpl", "findRow"));
    }

    public static class SinglePage<Row, Column>
    extends GridPagingModelImpl<Row, Column> {
        public SinglePage(GridModel<Row, Column> model) {
            super(model);
        }

        @Override
        public boolean isFirstPage() {
            return true;
        }

        @Override
        public boolean isLastPage() {
            return true;
        }

        @Override
        public void setPageSize(int pageSize) {
        }

        @Override
        public int getPageSize() {
            return -1;
        }

        @Override
        public boolean pageSizeSet() {
            return false;
        }

        @Override
        public long getTotalRowCount() {
            return this.myModel.getRowCount();
        }

        @Override
        public boolean isTotalRowCountPrecise() {
            return true;
        }

        @Override
        public boolean isTotalRowCountUpdateable() {
            return false;
        }

        @Override
        public int getPageStart() {
            return 1;
        }

        @Override
        public int getPageEnd() {
            return this.myModel.getRowCount();
        }
    }
}

