/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.textmate.joni;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.textmate.regex.MatchData;
import org.jetbrains.plugins.textmate.regex.RegexFacade;
import org.jetbrains.plugins.textmate.regex.TextMateString;
import org.joni.Matcher;
import org.joni.Regex;
import org.joni.Region;
import org.joni.exception.JOniException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J2\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/textmate/joni/JoniRegexFacade;", "Lorg/jetbrains/plugins/textmate/regex/RegexFacade;", "myRegex", "Lorg/joni/Regex;", "<init>", "(Lorg/joni/Regex;)V", "match", "Lorg/jetbrains/plugins/textmate/regex/MatchData;", "string", "Lorg/jetbrains/plugins/textmate/regex/TextMateString;", "checkCancelledCallback", "Ljava/lang/Runnable;", "byteOffset", "", "matchBeginPosition", "", "matchBeginString", "Companion", "intellij.textmate.joni"})
public final class JoniRegexFacade
implements RegexFacade {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Regex myRegex;
    private static final long MATCHING_TIMEOUT = Duration.getInWholeNanoseconds-impl((long)DurationKt.toDuration((int)300, (DurationUnit)DurationUnit.MILLISECONDS));
    @NotNull
    private static final Logger LOGGER;

    public JoniRegexFacade(@NotNull Regex myRegex) {
        Intrinsics.checkNotNullParameter((Object)myRegex, (String)"myRegex");
        this.myRegex = myRegex;
    }

    @Override
    @NotNull
    public MatchData match(@NotNull TextMateString string, @Nullable Runnable checkCancelledCallback) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return this.match(string, 0, true, true, checkCancelledCallback);
    }

    @Override
    @NotNull
    public MatchData match(@NotNull TextMateString string, int byteOffset, boolean matchBeginPosition, boolean matchBeginString, @Nullable Runnable checkCancelledCallback) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int gosOffset = matchBeginPosition ? byteOffset : Integer.MAX_VALUE;
        int options = matchBeginString ? 0 : 65536;
        Runnable runnable = checkCancelledCallback;
        if (runnable != null) {
            runnable.run();
        }
        Matcher matcher = this.myRegex.matcher(string.getBytes(), 0, string.getBytes().length, MATCHING_TIMEOUT);
        try {
            int matchIndex = matcher.search(gosOffset, byteOffset, string.getBytes().length, options);
            return switch (matchIndex) {
                case -1 -> MatchData.Companion.getNOT_MATCHED();
                case -2 -> {
                    LOGGER.info("Matching regex was interrupted on string: {}", (Object)StringsKt.decodeToString((byte[])string.getBytes()));
                    yield MatchData.Companion.getNOT_MATCHED();
                }
                default -> {
                    MatchData var11_10;
                    MatchData it = var11_10 = JoniRegexFacade.Companion.matchData(matcher.getEagerRegion());
                    boolean $i$a$-also-JoniRegexFacade$match$1 = false;
                    JoniRegexFacade.Companion.checkMatched(it, string);
                    yield var11_10;
                }
            };
        }
        catch (JOniException e) {
            Object[] objectArray = new Object[]{StringsKt.decodeToString((byte[])string.getBytes()), ((Object)((Object)e)).getClass().getName(), e.getMessage()};
            LOGGER.info("Failed to match textmate regex '{}' with {}: {}", objectArray);
            return MatchData.Companion.getNOT_MATCHED();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Object[] objectArray = new Object[]{StringsKt.decodeToString((byte[])string.getBytes()), e.getClass().getName(), e.getMessage()};
            LOGGER.info("Failed to match textmate regex '{}' with {}: {}", objectArray);
            return MatchData.Companion.getNOT_MATCHED();
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(JoniRegexFacade.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u00020\u000b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/textmate/joni/JoniRegexFacade$Companion;", "", "<init>", "()V", "MATCHING_TIMEOUT", "", "LOGGER", "Lorg/slf4j/Logger;", "checkMatched", "", "match", "Lorg/jetbrains/plugins/textmate/regex/MatchData;", "string", "Lorg/jetbrains/plugins/textmate/regex/TextMateString;", "matchData", "matchedRegion", "Lorg/joni/Region;", "intellij.textmate.joni"})
    public static final class Companion {
        private Companion() {
        }

        private final void checkMatched(MatchData match, TextMateString string) {
            if (!(!match.getMatched() || MatchData.byteOffset$default(match, 0, 1, null).getEnd() <= string.getBytes().length)) {
                boolean bl = false;
                String string2 = "Match data out of bounds: " + MatchData.byteOffset$default(match, 0, 1, null).getStart() + " > " + string.getBytes().length + "\n" + new String(string.getBytes(), Charsets.UTF_8);
                throw new IllegalStateException(string2.toString());
            }
        }

        private final MatchData matchData(Region matchedRegion) {
            if (matchedRegion != null) {
                int[] offsets = new int[matchedRegion.getNumRegs() * 2];
                int n = matchedRegion.getNumRegs();
                for (int i = 0; i < n; ++i) {
                    int startIndex = i * 2;
                    offsets[startIndex] = matchedRegion.getBeg(i);
                    offsets[startIndex + 1] = matchedRegion.getEnd(i);
                }
                return new MatchData(true, offsets);
            }
            return MatchData.Companion.getNOT_MATCHED();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

