/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.text.DateFormat;
import java.util.Date;
import oracle.ucp.jdbc.oracle.FailoverStatisticsCounters;

class FailoverStatisticsItem {
    final long timestamp;
    final Type type;
    final String serviceName;
    final String instanceName;
    final String dbUniqName;
    final String hostName;
    String reason;
    boolean successful;
    int availConns;
    int borrowedConns;
    FailoverStatisticsCounters availMarked = new FailoverStatisticsCounters();
    FailoverStatisticsCounters borrowedMarked = new FailoverStatisticsCounters();
    FailoverStatisticsCounters availClosed = new FailoverStatisticsCounters();
    FailoverStatisticsCounters borrowedClosed = new FailoverStatisticsCounters();
    int cardinality;
    int targetedToTearConns;
    int tornDownConns;
    int markedToCloseConns;
    int targetUpEventNewConns;
    int upEventNewConnCount;

    FailoverStatisticsItem(long timestamp, Type type) {
        this.timestamp = timestamp;
        this.type = type;
        this.hostName = null;
        this.dbUniqName = null;
        this.instanceName = null;
        this.serviceName = null;
    }

    FailoverStatisticsItem(Type type, String serviceName, String instanceName, String dbUniqName, String hostName) {
        this.timestamp = System.currentTimeMillis();
        this.type = type;
        this.serviceName = serviceName;
        this.instanceName = instanceName;
        this.dbUniqName = dbUniqName;
        this.hostName = hostName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String sTimestamp = DateFormat.getDateTimeInstance(2, 3).format(new Date(this.timestamp));
        sb.append(sTimestamp).append(this.successful ? " SUCCESS" : " FAILURE");
        if (this.type == Type.SERVICE_DOWN || this.type == Type.HOST_DOWN || this.type == Type.INSTANCE_DOWN) {
            sb.append(" <Reason:").append(null != this.reason ? this.reason : "unplanned").append('>');
        }
        sb.append(" <Type:").append((Object)this.type).append('>');
        if (this.type == Type.HOST_DOWN || this.type == Type.HOST_UP) {
            sb.append(" <Host:\"").append(this.hostName).append("\">");
        } else {
            sb.append(" <Service:\"").append(this.serviceName).append("\">").append(" <Instance:\"").append(this.instanceName).append("\">").append(" <Db:\"").append(this.dbUniqName).append("\">");
        }
        sb.append(" Connections:").append("(Available=").append(this.availConns).append(" Affected=").append(this.availClosed.affected).append(" FailedToProcess=").append(this.availMarked.failed + this.availClosed.failed).append(" MarkedDown=").append(this.availMarked.markedBad).append(" Closed=").append(this.availClosed.abortedAndClosed).append(")").append("(Borrowed=").append(this.borrowedConns).append(" Affected=").append(this.borrowedClosed.affected).append(" FailedToProcess=").append(this.borrowedMarked.failed + this.borrowedClosed.failed).append(" MarkedDown=").append(this.borrowedMarked.markedBad).append(" MarkedDeferredClose=").append(this.borrowedMarked.markedCloseOnReturn).append(" Closed=").append(this.borrowedClosed.abortedAndClosed).append(")");
        if (this.type == Type.SERVICE_UP || this.type == Type.HOST_UP || this.type == Type.INSTANCE_UP) {
            sb.append(" cardinality=").append(this.cardinality).append(" targetedToTear=").append(this.targetedToTearConns).append(" tornDown=").append(this.tornDownConns).append(" markedToClose=").append(this.markedToCloseConns).append(" targetUpEventNewConns=").append(this.targetUpEventNewConns).append(" upEventNewConns=").append(this.upEventNewConnCount);
        }
        sb.append('\n');
        return sb.toString();
    }

    static enum Type {
        SERVICE_DOWN,
        SERVICE_UP,
        HOST_DOWN,
        HOST_UP,
        INSTANCE_DOWN,
        INSTANCE_UP,
        NOT_PROCESSED;

    }
}

