/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

class CharacterSet2ByteFixed
extends CharacterSetWithConverter {
    static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverter2ByteFixed";
    static final short MAX_7BIT = 127;
    static final short MIN_8BIT_SB = 161;
    static final short MAX_8BIT_SB = 223;
    static final short CHARLENGTH = 2;
    static Class m_charConvSuperclass;

    CharacterSet2ByteFixed(int oracleId, JdbcCharacterConverters charConverter) {
        super(oracleId, charConverter);
    }

    static CharacterSet2ByteFixed getInstance(int oracleId, JdbcCharacterConverters charConverter) {
        if (charConverter.getGroupId() == 6) {
            return new CharacterSet2ByteFixed(oracleId, charConverter);
        }
        return null;
    }

    @Override
    int decode(CharacterWalker walker) throws SQLException {
        int c = walker.bytes[walker.next] & 0xFF;
        ++walker.next;
        if (walker.bytes.length > walker.next) {
            c = c << 8 | walker.bytes[walker.next];
            ++walker.next;
        } else {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182).fillInStackTrace();
        }
        return c;
    }

    @Override
    void encode(CharacterBuffer buffer, int c) throws SQLException {
        CharacterSet2ByteFixed.need(buffer, 2);
        buffer.bytes[buffer.next++] = (byte)(c >> 8 & 0xFF);
        buffer.bytes[buffer.next++] = (byte)(c & 0xFF);
    }
}

