/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.aq;

import java.sql.SQLException;
import java.util.EventObject;
import oracle.jdbc.aq.AQMessageProperties;

public abstract class AQNotificationEvent
extends EventObject {
    protected AQNotificationEvent(Object source) {
        super(source);
    }

    public abstract AQMessageProperties getMessageProperties() throws SQLException;

    public abstract String getRegistration() throws SQLException;

    public abstract byte[] getPayload() throws SQLException;

    public abstract String getQueueName() throws SQLException;

    public abstract byte[] getMessageId() throws SQLException;

    public abstract String getConsumerName() throws SQLException;

    public abstract String getConnectionInformation();

    public abstract EventType getEventType();

    public abstract AdditionalEventType getAdditionalEventType();

    @Override
    public abstract String toString();

    public static enum AdditionalEventType {
        NONE(0),
        TIMEOUT(1),
        GROUPING(2);

        private final int code;

        private AdditionalEventType(int _code) {
            this.code = _code;
        }

        public final int getCode() {
            return this.code;
        }

        public static final AdditionalEventType getEventType(int code) {
            if (code == TIMEOUT.getCode()) {
                return TIMEOUT;
            }
            if (code == GROUPING.getCode()) {
                return GROUPING;
            }
            return NONE;
        }
    }

    public static enum EventType {
        REGULAR(0),
        DEREG(1);

        private final int code;

        private EventType(int _code) {
            this.code = _code;
        }

        public final int getCode() {
            return this.code;
        }
    }
}

